/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.PartitionableSinkTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001'\t)\u0002+\u0019:uSRLwN\\1cY\u0016\u001c\u0016N\\6UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\tQAY1uG\"T!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\t\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013%\u0011%\u0001\u0003vi&dW#\u0001\u0012\u0011\u0005U\u0019\u0013B\u0001\u0013\u0017\u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r\u0019\u0002\u0001\u0015!\u0003#\u0003\u0015)H/\u001b7!\u0011\u0015A\u0003\u0001\"\u0003*\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\u0007)\u0002T\b\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0003V]&$\b\"B\u0019(\u0001\u0004\u0011\u0014\u0001\u00028b[\u0016\u0004\"a\r\u001e\u000f\u0005QB\u0004CA\u001b-\u001b\u00051$BA\u001c\u0013\u0003\u0019a$o\\8u}%\u0011\u0011\bL\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:Y!)ah\na\u0001\u007f\u0005I1\u000f[;gM2,')\u001f\t\u0003W\u0001K!!\u0011\u0017\u0003\u000f\t{w\u000e\\3b]\")1\t\u0001C\u0001\t\u0006QA/Z:u'R\fG/[2\u0015\u0003)B#A\u0011$\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%\u0003\u0012!\u00026v]&$\u0018BA&I\u0005\u0011!Vm\u001d;\t\u000b5\u0003A\u0011\u0001#\u0002\u0017Q,7\u000f\u001e#z]\u0006l\u0017n\u0019\u0015\u0003\u0019\u001aCQ\u0001\u0015\u0001\u0005\u0002\u0011\u000bA\u0003^3ti\u0012Kh.Y7jGNCWO\u001a4mK\nK\bFA(G\u0011\u0015\u0019\u0006\u0001\"\u0001E\u0003-!Xm\u001d;QCJ$\u0018.\u00197)\u0005I3\u0005\"\u0002,\u0001\t\u0003!\u0015a\u0004;fgR<&o\u001c8h'R\fG/[2)\tU3\u0005,W\u0001\tKb\u0004Xm\u0019;fI\u000e\n!\f\u0005\u0002\\=6\tAL\u0003\u0002^\u0015\u0005\u0019\u0011\r]5\n\u0005}c&a\u0005,bY&$\u0017\r^5p]\u0016C8-\u001a9uS>t\u0007\"B1\u0001\t\u0003!\u0015a\u0004;fgR<&o\u001c8h\r&,G\u000eZ:)\t\u00014\u0005,\u0017\u0005\u0006I\u0002!\t\u0001R\u0001\u0015i\u0016\u001cHo\u0015;bi&\u001cw+\u001b;i-\u0006dW/Z:)\u0005\r4\u0005")
public class PartitionableSinkTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    private void createTable(String name, boolean shuffleBy) {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(270).append("\n         |create table ").append(name).append(" (\n         |  a bigint,\n         |  b bigint,\n         |  c bigint\n         |) partitioned by (b, c) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '/non',\n         |  ").append((Object)(shuffleBy ? "'sink.shuffle-by-partition.enable'='true'," : "")).append("\n         |  'format' = 'testcsv'\n         |)\n         |").toString())).stripMargin());
    }

    @Test
    public void testStatic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1, c=1) SELECT a FROM MyTable");
    }

    @Test
    public void testDynamic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testDynamicShuffleBy() {
        this.createTable("sinkShuffleBy", true);
        this.util().verifyExecPlanInsert("INSERT INTO sinkShuffleBy SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testPartial() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1) SELECT a, c FROM MyTable");
    }

    @Test(expected=ValidationException.class)
    public void testWrongStatic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (a=1) SELECT b, c FROM MyTable");
    }

    @Test(expected=ValidationException.class)
    public void testWrongFields() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1) SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testStaticWithValues() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1, c=1) VALUES (5)");
    }

    public PartitionableSinkTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.PartitionableSinkTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.createTable("sink", false);
    }
}

