/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkRuleSetProgram;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateRemoveRule;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Me!B\u0001\u0003\u0003\u0003\t\"aH!hOJ,w-\u0019;f%\u0016$WoY3He>,\b/\u001b8h)\u0016\u001cHOQ1tK*\u00111\u0001B\u0001\u0007G>lWn\u001c8\u000b\u0005\u00151\u0011\u0001\u00029mC:T!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)b!A\u0003vi&d7/\u0003\u0002\u0018)\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\ro&$\b.\u0012=fGBc\u0017M\u001c\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\b\u0005>|G.Z1o\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\u00111%\n\t\u0003I\u0001i\u0011A\u0001\u0005\u00063\u0001\u0002\rA\u0007\u0005\bO\u0001\u0011\r\u0011\"\u0005)\u0003\u0011)H/\u001b7\u0016\u0003%\u0002\"a\u0005\u0016\n\u0005-\"\"A\u0005\"bi\u000eDG+\u00192mKR+7\u000f^+uS2Da!\f\u0001!\u0002\u0013I\u0013!B;uS2\u0004\u0003\"B\u0018\u0001\t\u0003\u0001\u0014!B:fiV\u0004H#A\u0019\u0011\u0005m\u0011\u0014BA\u001a\u001d\u0005\u0011)f.\u001b;)\u00059*\u0004C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u000f\u0003\u0015QWO\\5u\u0013\tQtG\u0001\u0004CK\u001a|'/\u001a\u0005\u0006y\u0001!\t\u0001M\u0001\u0016i\u0016\u001cH/Q4h/&$\bn\\;u\u0003\u001e<7)\u00197mQ\tYd\b\u0005\u00027\u007f%\u0011\u0001i\u000e\u0002\u0005)\u0016\u001cH\u000fC\u0003C\u0001\u0011\u0005\u0001'\u0001\u000fuKN$\u0018iZ4XSRDw.\u001e;SK\u0012,8-Z$s_V\u0004\u0018N\\4)\u0005\u0005s\u0004\"B#\u0001\t\u0003\u0001\u0014!\t;fgR\u001c\u0016N\\4mK\u0006;wm\u00148UC\ndWmV5uQVs\u0017.];f\u0017\u0016L\bF\u0001#?\u0011\u0015A\u0005\u0001\"\u00011\u0003\u0011\"Xm\u001d;TS:<G.Z!hO>sG+\u00192mK^KG\u000f[8viVs\u0017.];f\u0017\u0016L\bFA$?\u0011\u0015Y\u0005\u0001\"\u00011\u0003\t\"Xm\u001d;TS:<G.Z!hO>sG+\u00192mK^KG\u000f[+oSF,XmS3zg\"\u0012!J\u0010\u0005\u0006\u001d\u0002!\t\u0001M\u0001\"i\u0016\u001cHoU5oO2,\u0017iZ4XSRD7i\u001c8ti\u0006tGo\u0012:pkB\\U-\u001f\u0015\u0003\u001bzBQ!\u0015\u0001\u0005\u0002A\n\u0011\u0005^3tiNKgn\u001a7f\u0003\u001e<wJ\u001c7z\u0007>t7\u000f^1oi\u001e\u0013x.\u001e9LKfD#\u0001\u0015 \t\u000bQ\u0003A\u0011\u0001\u0019\u0002\u001dQ,7\u000f^'vYRL\u0017iZ4tc!\u00121K\u0010\u0005\u0006/\u0002!\t\u0001M\u0001\u000fi\u0016\u001cH/T;mi&\fumZ:3Q\t1f\bC\u0003[\u0001\u0011\u0005\u0001'A\nuKN$\u0018iZ4P]&sg.\u001a:K_&t\u0017\u0007\u000b\u0002Z}!)Q\f\u0001C\u0001a\u0005\u0019B/Z:u\u0003\u001e<wJ\\%o]\u0016\u0014(j\\5oe!\u0012AL\u0010\u0005\u0006A\u0002!\t\u0001M\u0001\u0014i\u0016\u001cH/Q4h\u001f:LeN\\3s\u0015>Lgn\r\u0015\u0003?zBQa\u0019\u0001\u0005\u0002A\n!\u0003^3ti\u0006;wm\u00148MK\u001a$(j\\5oc!\u0012!M\u0010\u0005\u0006M\u0002!\t\u0001M\u0001\u0013i\u0016\u001cH/Q4h\u001f:dUM\u001a;K_&t'\u0007\u000b\u0002f}!)\u0011\u000e\u0001C\u0001a\u0005\u0011B/Z:u\u0003\u001e<wJ\u001c'fMRTu.\u001b84Q\tAg\bC\u0003m\u0001\u0011\u0005\u0001'A\nuKN$\u0018iZ4P]JKw\r\u001b;K_&t\u0017\u0007\u000b\u0002l}!)q\u000e\u0001C\u0001a\u0005\u0019B/Z:u\u0003\u001e<wJ\u001c*jO\"$(j\\5oe!\u0012aN\u0010\u0005\u0006e\u0002!\t\u0001M\u0001\u0014i\u0016\u001cH/Q4h\u001f:\u0014\u0016n\u001a5u\u0015>Lgn\r\u0015\u0003czBQ!\u001e\u0001\u0005\u0002A\n!\u0003^3ti\u0006;wm\u00148Gk2d'j\\5oc!\u0012AO\u0010\u0005\u0006q\u0002!\t\u0001M\u0001\u0013i\u0016\u001cH/Q4h\u001f:4U\u000f\u001c7K_&t'\u0007\u000b\u0002x}!)1\u0010\u0001C\u0001a\u0005iA/Z:u\u0003\u001e<wJ\\(wKJD#A\u001f \t\u000by\u0004A\u0011\u0001\u0019\u0002!Q,7\u000f^!hO>sw+\u001b8e_^\f\u0004FA??\u0011\u0019\t\u0019\u0001\u0001C\u0001a\u0005\u0001B/Z:u\u0003\u001e<wJ\\,j]\u0012|wO\r\u0015\u0004\u0003\u0003q\u0004BBA\u0005\u0001\u0011\u0005\u0001'\u0001\tuKN$\u0018iZ4P]^Kg\u000eZ8xg!\u001a\u0011q\u0001 \t\r\u0005=\u0001\u0001\"\u00011\u0003A!Xm\u001d;BO\u001e|enV5oI><H\u0007K\u0002\u0002\u000eyBa!!\u0006\u0001\t\u0003\u0001\u0014\u0001\u0005;fgR\fumZ(o/&tGm\\<6Q\r\t\u0019B\u0010\u0005\u0007\u00037\u0001A\u0011\u0001\u0019\u00021Q,7\u000f^!hO^KG\u000f[$s_V\u0004\u0018N\\4TKR\u001c\u0018\u0007K\u0002\u0002\u001ayBa!!\t\u0001\t\u0003\u0001\u0014\u0001\u0007;fgR\fumZ,ji\"<%o\\;qS:<7+\u001a;te!\u001a\u0011q\u0004 \t\r\u0005\u001d\u0002\u0001\"\u00011\u0003a!Xm\u001d;BO\u001e<\u0016\u000e\u001e5He>,\b/\u001b8h'\u0016$8o\r\u0015\u0004\u0003Kq\u0004BBA\u0017\u0001\u0011\u0005\u0001'A\tuKN$\u0018iZ4XSRD'k\u001c7mkBD3!a\u000b?\u0011\u0019\t\u0019\u0004\u0001C\u0001a\u0005yA/Z:u\u0003\u001e<w+\u001b;i\u0007V\u0014W\rK\u0002\u00022yBa!!\u000f\u0001\t\u0003\u0001\u0014A\u0006;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ\u0019)\u0007\u0005]b\b\u0003\u0004\u0002@\u0001!\t\u0001M\u0001\u0017i\u0016\u001cHoU5oO2,G)[:uS:\u001cG/Q4he!\u001a\u0011Q\b \t\r\u0005\u0015\u0003\u0001\"\u00011\u0003%\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e|v+\u001b;i\u001d>tG)[:uS:\u001cG/Q4hc!\u001a\u00111\t \t\r\u0005-\u0003\u0001\"\u00011\u0003%\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e|v+\u001b;i\u001d>tG)[:uS:\u001cG/Q4he!\u001a\u0011\u0011\n \t\r\u0005E\u0003\u0001\"\u00011\u0003%\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e|v+\u001b;i\u001d>tG)[:uS:\u001cG/Q4hg!\u001a\u0011q\n \t\r\u0005]\u0003\u0001\"\u00011\u0003%\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e|v+\u001b;i\u001d>tG)[:uS:\u001cG/Q4hi!\u001a\u0011Q\u000b \t\r\u0005u\u0003\u0001\"\u00011\u0003Y!Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!hON\f\u0004fAA.}!1\u00111\r\u0001\u0005\u0002A\na\u0003^3ti6+H\u000e^5ESN$\u0018N\\2u\u0003\u001e<7O\r\u0015\u0004\u0003Cr\u0004BBA5\u0001\u0011\u0005\u0001'\u0001\fuKN$X*\u001e7uS\u0012K7\u000f^5oGR\fumZ:4Q\r\t9G\u0010\u0005\u0007\u0003_\u0002A\u0011\u0001\u0019\u0002SQ,7\u000f^'vYRLG)[:uS:\u001cG/Q4hg~;\u0016\u000e\u001e5O_:$\u0015n\u001d;j]\u000e$\u0018iZ42Q\r\tiG\u0010\u0005\b\u0003k\u0002A\u0011AA<\u0003)1XM]5gsBc\u0017M\u001c\u000b\u0004c\u0005e\u0004\u0002CA>\u0003g\u0002\r!! \u0002\u0011M\fH.U;fef\u0004B!a \u0002\u000e:!\u0011\u0011QAE!\r\t\u0019\tH\u0007\u0003\u0003\u000bS1!a\"\u0011\u0003\u0019a$o\\8u}%\u0019\u00111\u0012\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\ty)!%\u0003\rM#(/\u001b8h\u0015\r\tY\t\b")
public abstract class AggregateReduceGroupingTestBase
extends TableTestBase {
    private final boolean withExecPlan;
    private final BatchTableTestUtil util;

    public BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        this.util().addTableSource("T1", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.STRING()}), (String[])((Object[])new String[]{"a1", "b1", "c1", "d1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"a1"))).build());
        this.util().addTableSource("T2", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING()}), (String[])((Object[])new String[]{"a2", "b2", "c2"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"b2"), (Object)ImmutableSet.of((Object)"a2", (Object)"b2"))).build());
        this.util().addTableSource("T3", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.LONG()}), (String[])((Object[])new String[]{"a3", "b3", "c3", "d3"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(1000L)).build());
        this.util().addTableSource("T4", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.LOCAL_DATE_TIME()}), (String[])((Object[])new String[]{"a4", "b4", "c4", "d4"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"a4"))).build());
    }

    @Test
    public void testAggWithoutAggCall() {
        FlinkChainedProgram<BatchOptimizeContext> programs = this.util().getBatchProgram();
        ((FlinkRuleSetProgram)programs.getFlinkRuleSetProgram(FlinkBatchProgram$.MODULE$.LOGICAL()).get()).remove(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FlinkAggregateRemoveRule.INSTANCE}));
        this.util().replaceBatchProgram(programs);
        this.util().verifyRelPlan("SELECT a1, b1, c1 FROM T1 GROUP BY a1, b1, c1");
    }

    @Test
    public void testAggWithoutReduceGrouping() {
        this.verifyPlan("SELECT a3, b3, count(c3) FROM T3 GROUP BY a3, b3");
    }

    @Test
    public void testSingleAggOnTableWithUniqueKey() {
        this.verifyPlan("SELECT a1, b1, count(c1) FROM T1 GROUP BY a1, b1");
    }

    @Test
    public void testSingleAggOnTableWithoutUniqueKey() {
        this.verifyPlan("SELECT a3, b3, count(c3) FROM T3 GROUP BY a3, b3");
    }

    @Test
    public void testSingleAggOnTableWithUniqueKeys() {
        this.verifyPlan("SELECT  b2, c2, avg(a2) FROM T2 GROUP BY b2, c2");
    }

    @Test
    public void testSingleAggWithConstantGroupKey() {
        this.verifyPlan("SELECT a1, b1, count(c1) FROM T1 GROUP BY a1, b1, 1, true");
    }

    @Test
    public void testSingleAggOnlyConstantGroupKey() {
        this.verifyPlan("SELECT count(c1) FROM T1 GROUP BY 1, true");
    }

    @Test
    public void testMultiAggs1() {
        this.verifyPlan("SELECT a1, b1, c1, d1, m, COUNT(*) FROM (SELECT a1, b1, c1, COUNT(d1) AS d1, MAX(d1) AS m FROM T1 GROUP BY a1, b1, c1) t GROUP BY a1, b1, c1, d1, m");
    }

    @Test
    public void testMultiAggs2() {
        this.verifyPlan("SELECT a3, b3, c, s, a, COUNT(*) FROM (SELECT a3, b3, COUNT(c3) AS c, SUM(d3) AS s, AVG(d3) AS a FROM T3 GROUP BY a3, b3) t GROUP BY a3, b3, c, s, a");
    }

    @Test
    public void testAggOnInnerJoin1() {
        this.verifyPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1, T2 WHERE a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @Test
    public void testAggOnInnerJoin2() {
        this.verifyPlan("SELECT a2, b2, a3, b3, COUNT(c2), AVG(d3) FROM (SELECT * FROM T2, T3 WHERE b2 = a3) t GROUP BY a2, b2, a3, b3");
    }

    @Test
    public void testAggOnInnerJoin3() {
        this.verifyPlan("SELECT a1, b1, a2, b2, a3, b3, COUNT(c1) FROM (SELECT * FROM T1, T2, T3 WHERE a1 = b2 AND a1 = a3) t GROUP BY a1, b1, a2, b2, a3, b3");
    }

    @Test
    public void testAggOnLeftJoin1() {
        this.verifyPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1 LEFT JOIN T2 ON a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @Test
    public void testAggOnLeftJoin2() {
        this.verifyPlan("SELECT a1, b1, a3, b3, COUNT(c1) FROM (SELECT * FROM T1 LEFT JOIN T3 ON a1 = a3) t GROUP BY a1, b1, a3, b3");
    }

    @Test
    public void testAggOnLeftJoin3() {
        this.verifyPlan("SELECT a3, b3, a1, b1, COUNT(c1) FROM (SELECT * FROM T3 LEFT JOIN T1 ON a1 = a3) t GROUP BY a3, b3, a1, b1");
    }

    @Test
    public void testAggOnRightJoin1() {
        this.verifyPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1 RIGHT JOIN T2 ON a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @Test
    public void testAggOnRightJoin2() {
        this.verifyPlan("SELECT a1, b1, a3, b3, COUNT(c1) FROM (SELECT * FROM T1 RIGHT JOIN T3 ON a1 = a3) t GROUP BY a1, b1, a3, b3");
    }

    @Test
    public void testAggOnRightJoin3() {
        this.verifyPlan("SELECT a3, b3, a1, b1, COUNT(c1) FROM (SELECT * FROM T3 RIGHT JOIN T1 ON a1 = a3) t GROUP BY a3, b3, a1, b1");
    }

    @Test
    public void testAggOnFullJoin1() {
        this.verifyPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1 FULL OUTER JOIN T2 ON a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @Test
    public void testAggOnFullJoin2() {
        this.verifyPlan("SELECT a1, b1, a3, b3, COUNT(c1) FROM (SELECT * FROM T1 FULL OUTER JOIN T3 ON a1 = a3) t GROUP BY a1, b1, a3, b3");
    }

    @Test
    public void testAggOnOver() {
        this.verifyPlan("SELECT a1, b1, c, COUNT(d1) FROM (SELECT a1, b1, d1, COUNT(*) OVER (PARTITION BY c1) AS c FROM T1) t GROUP BY a1, b1, c");
    }

    @Test
    public void testAggOnWindow1() {
        this.verifyPlan("SELECT a4, b4, COUNT(c4) FROM T4 GROUP BY a4, b4, TUMBLE(d4, INTERVAL '15' MINUTE)");
    }

    @Test
    public void testAggOnWindow2() {
        this.verifyPlan("SELECT a4, c4, COUNT(b4), AVG(b4) FROM T4 GROUP BY a4, c4, TUMBLE(d4, INTERVAL '15' MINUTE)");
    }

    @Test
    public void testAggOnWindow3() {
        this.verifyPlan("SELECT a4, c4, s, COUNT(b4) FROM (SELECT a4, c4, VAR_POP(b4) AS b4, TUMBLE_START(d4, INTERVAL '15' MINUTE) AS s, TUMBLE_END(d4, INTERVAL '15' MINUTE) AS e FROM T4 GROUP BY a4, c4, TUMBLE(d4, INTERVAL '15' MINUTE)) t GROUP BY a4, c4, s");
    }

    @Test
    public void testAggOnWindow4() {
        this.verifyPlan("SELECT a4, c4, e, COUNT(b4) FROM (SELECT a4, c4, VAR_POP(b4) AS b4, TUMBLE_START(d4, INTERVAL '15' MINUTE) AS s, TUMBLE_END(d4, INTERVAL '15' MINUTE) AS e FROM T4 GROUP BY a4, c4, TUMBLE(d4, INTERVAL '15' MINUTE)) t GROUP BY a4, c4, e");
    }

    @Test
    public void testAggOnWindow5() {
        this.verifyPlan("SELECT a4, b4, c4, COUNT(*) FROM (SELECT a4, c4, VAR_POP(b4) AS b4, TUMBLE_START(d4, INTERVAL '15' MINUTE) AS s, TUMBLE_END(d4, INTERVAL '15' MINUTE) AS e FROM T4 GROUP BY a4, c4, TUMBLE(d4, INTERVAL '15' MINUTE)) t GROUP BY a4, b4, c4");
    }

    @Test
    public void testAggWithGroupingSets1() {
        this.verifyPlan("SELECT a1, b1, c1, COUNT(d1) FROM T1 GROUP BY GROUPING SETS ((a1, b1), (a1, c1))");
    }

    @Test
    public void testAggWithGroupingSets2() {
        this.verifyPlan("SELECT a1, SUM(b1) AS s FROM T1 GROUP BY GROUPING SETS((a1, c1), (a1), ())");
    }

    @Test
    public void testAggWithGroupingSets3() {
        this.verifyPlan("SELECT a1, b1, c1, COUNT(d1) FROM T1 GROUP BY GROUPING SETS ((a1, b1, c1), (a1, b1, d1))");
    }

    @Test
    public void testAggWithRollup() {
        this.verifyPlan("SELECT a1, b1, c1, COUNT(d1) FROM T1 GROUP BY ROLLUP (a1, b1, c1)");
    }

    @Test
    public void testAggWithCube() {
        this.verifyPlan("SELECT a1, b1, c1, COUNT(d1) FROM T1 GROUP BY CUBE (a1, b1, c1)");
    }

    @Test
    public void testSingleDistinctAgg1() {
        this.verifyPlan("SELECT a1, COUNT(DISTINCT c1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testSingleDistinctAgg2() {
        this.verifyPlan("SELECT a1, b1, COUNT(DISTINCT c1) FROM T1 GROUP BY a1, b1");
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg1() {
        this.verifyPlan("SELECT a1, COUNT(DISTINCT b1), SUM(b1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg2() {
        this.verifyPlan("SELECT a1, c1, COUNT(DISTINCT b1), SUM(b1) FROM T1 GROUP BY a1, c1");
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg3() {
        this.verifyPlan("SELECT a1, COUNT(DISTINCT c1), SUM(b1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg4() {
        this.verifyPlan("SELECT a1, d1, COUNT(DISTINCT c1), SUM(b1) FROM T1 GROUP BY a1, d1");
    }

    @Test
    public void testMultiDistinctAggs1() {
        this.verifyPlan("SELECT a1, COUNT(DISTINCT b1), SUM(DISTINCT b1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testMultiDistinctAggs2() {
        this.verifyPlan("SELECT a1, d1, COUNT(DISTINCT c1), SUM(DISTINCT b1) FROM T1 GROUP BY a1, d1");
    }

    @Test
    public void testMultiDistinctAggs3() {
        this.verifyPlan("SELECT a1, SUM(DISTINCT b1), MAX(DISTINCT b1), MIN(DISTINCT c1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testMultiDistinctAggs_WithNonDistinctAgg1() {
        this.verifyPlan("SELECT a1, d1, COUNT(DISTINCT c1), MAX(DISTINCT b1), SUM(b1) FROM T1 GROUP BY a1, d1");
    }

    public void verifyPlan(String sqlQuery) {
        if (this.withExecPlan) {
            this.util().verifyExecPlan(sqlQuery);
        } else {
            this.util().verifyRelPlan(sqlQuery);
        }
    }

    public AggregateReduceGroupingTestBase(boolean withExecPlan) {
        this.withExecPlan = withExecPlan;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

