/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.util.Collection;
import java.util.Optional;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.planner.plan.common.TableFactoryTest$;
import org.apache.flink.table.planner.plan.utils.TestContextTableFactory;
import org.apache.flink.table.planner.plan.utils.TestContextTableFactory$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001#\t\u0001B+\u00192mK\u001a\u000b7\r^8ssR+7\u000f\u001e\u0006\u0003\u0007\u0011\taaY8n[>t'BA\u0003\u0007\u0003\u0011\u0001H.\u00198\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u0011e\u0001!\u0011!Q\u0001\ni\tq![:CCR\u001c\u0007\u000e\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBDA\u0004C_>dW-\u00198\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u001aA\u0001\u0007!\u0004C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002\tU$\u0018\u000e\\\u000b\u0002SI!!\u0006L\u00183\r\u0011Y\u0003\u0001A\u0015\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0005Mi\u0013B\u0001\u0018\u0015\u00055!\u0016M\u00197f)\u0016\u001cH/\u0016;jYB\u00111\u0004M\u0005\u0003cq\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u001cg%\u0011A\u0007\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0007m\u0001\u0001\u000b\u0011B\u0015\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000ba\u0002A\u0011A\u001d\u0002\r\t,gm\u001c:f)\u0005Q\u0004CA\u000e<\u0013\taDD\u0001\u0003V]&$\bFA\u001c?!\ty$)D\u0001A\u0015\t\te\"A\u0003kk:LG/\u0003\u0002D\u0001\n1!)\u001a4pe\u0016DQ!\u0012\u0001\u0005\u0002e\n!\u0004^3tiR\u000b'\r\\3T_V\u00148-Z*j].4\u0015m\u0019;pefD#\u0001R$\u0011\u0005}B\u0015BA%A\u0005\u0011!Vm\u001d;)\t\u0001Y\u0015K\u0015\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u0002\u000baA];o]\u0016\u0014\u0018B\u0001)N\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c\u0013a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-\u0002\u000bqA];o]\u0016\u00148/\u0003\u0002Y+\ni\u0001+\u0019:b[\u0016$XM]5{K\u0012<QA\u0017\u0002\t\u0002m\u000b\u0001\u0003V1cY\u00164\u0015m\u0019;pef$Vm\u001d;\u0011\u0005\u0011bf!B\u0001\u0003\u0011\u0003i6C\u0001/_!\tYr,\u0003\u0002a9\t1\u0011I\\=SK\u001aDQ!\t/\u0005\u0002\t$\u0012a\u0017\u0005\u0006Ir#\t!Z\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cH#\u00014\u0011\u0007\u001d\\'$D\u0001i\u0015\t9\u0013NC\u0001k\u0003\u0011Q\u0017M^1\n\u00051D'AC\"pY2,7\r^5p]\"\"1M\\;w!\ty'O\u0004\u0002Ua&\u0011\u0011/V\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\n\u0005M$(A\u0003)be\u0006lW\r^3sg*\u0011\u0011/V\u0001\u0005]\u0006lW-I\u0001x\u00031I7OQ1uG\"T\u0004e\u001f\u0019~\u0001")
public class TableFactoryTest
extends TableTestBase {
    private final boolean isBatch;
    private final TableTestUtil util;

    @Parameterized.Parameters(name="isBatch: {0}")
    public static Collection<Object> parameters() {
        return TableFactoryTest$.MODULE$.parameters();
    }

    private TableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        TestCollectionTableFactory$.MODULE$.reset();
    }

    @Test
    public void testTableSourceSinkFactory() {
        TestContextTableFactory factory = new TestContextTableFactory(ObjectIdentifier.of((String)"cat", (String)"default", (String)"t1"), ObjectIdentifier.of((String)"cat", (String)"default", (String)"t2"), this.isBatch);
        this.util().tableEnv().getConfig().set(TestContextTableFactory$.MODULE$.REQUIRED_KEY(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().registerCatalog("cat", (Catalog)new GenericInMemoryCatalog(null, factory){
            private final TestContextTableFactory factory$1;

            public Optional<TableFactory> getTableFactory() {
                return Optional.of(this.factory$1);
            }
            {
                this.factory$1 = factory$1;
                super("default");
            }
        });
        this.util().tableEnv().useCatalog("cat");
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as a + 1\n        |) with (\n        |  'connector.type' = 'filesystem',\n        |  'connector.path' = '/to/my/path1',\n        |  'format.type' = 'csv'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b as c - 1,\n        |  c int\n        |) with (\n        |  'connector.type' = 'filesystem',\n        |  'connector.path' = '/to/my/path2',\n        |  'format.type' = 'csv'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.c from t1\n      ")).stripMargin();
        this.util().tableEnv().executeSql(sourceDDL);
        this.util().tableEnv().executeSql(sinkDDL);
        this.util().tableEnv().explainSql(query, new ExplainDetail[0]);
        Assert.assertTrue((boolean)factory.hasInvokedSource());
        Assert.assertTrue((boolean)factory.hasInvokedSink());
    }

    public TableFactoryTest(boolean isBatch) {
        this.isBatch = isBatch;
        this.util = isBatch ? this.batchTestUtil(this.batchTestUtil$default$1()) : this.streamTestUtil(this.streamTestUtil$default$1());
    }
}

