/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.CatalogViewImpl;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.common.ViewsExpandingTest$;
import org.apache.flink.table.planner.utils.TableFunc0;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.planner.utils.TableTestUtilBase;
import org.apache.flink.table.types.DataType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u0001E\u0011!CV5foN,\u0005\u0010]1oI&tw\rV3ti*\u00111\u0001B\u0001\u0007G>lWn\u001c8\u000b\u0005\u00151\u0011\u0001\u00029mC:T!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)b!A\u0003vi&d7/\u0003\u0002\u0018)\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u000ei\u0006\u0014G.\u001a+fgR,F/\u001b7\u0011\tmq\"\u0003I\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\tIa)\u001e8di&|g.\r\t\u0003'\u0005J!A\t\u000b\u0003\u001bQ\u000b'\r\\3UKN$X\u000b^5m\u0011\u0015!\u0003\u0001\"\u0001&\u0003\u0019a\u0014N\\5u}Q\u0011a\u0005\u000b\t\u0003O\u0001i\u0011A\u0001\u0005\u00063\r\u0002\rA\u0007\u0005\u0006U\u0001!\taK\u0001\u001fi\u0016\u001cH/T5yK\u0012\u001c\u0016\u000f\u001c+bE2,g+[3x\u000bb\u0004\u0018M\u001c3j]\u001e$\u0012\u0001\f\t\u000375J!A\f\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003SA\u0002\"!\r\u001b\u000e\u0003IR!a\r\b\u0002\u000b),h.\u001b;\n\u0005U\u0012$\u0001\u0002+fgRDQa\u000e\u0001\u0005\u0002-\nQ\u0003^3tiR\u000b'\r\\3Ba&,\u0005\u0010]1oI&tw\r\u000b\u00027a!)!\b\u0001C\u0001W\u0005\u0001B/Z:u'FdW\t\u001f9b]\u0012Lgn\u001a\u0015\u0003sABQ!\u0010\u0001\u0005\u0002-\nA\u0005^3tiZKWm^#ya\u0006tG-\u001b8h/&$\b.T5t[\u0006$8\r\u001b*poRK\b/\u001a\u0015\u0003yABQ\u0001\u0011\u0001\u0005\u0002-\n\u0011\u0006^3tiZKWm^#ya\u0006tG-\u001b8h/&$\b\u000eT1uKJ\fG\u000eV1cY\u00164UO\\2uS>t\u0007FA 1\u0011\u0015\u0019\u0005\u0001\"\u0001,\u0003\u0011\"Xm\u001d;WS\u0016<X\t\u001f9b]\u0012LgnZ,ji\"\u0014U/\u001b7uS:4UO\\2uS>t\u0007F\u0001\"1\u0011\u00151\u0005\u0001\"\u0001,\u0003a!Xm\u001d;WS\u0016<X\t\u001f9b]\u0012LgnZ,ji\",FI\u0012\u0015\u0003\u000bBBQ!\u0013\u0001\u0005\u0002-\na\u0004^3ti\u0016C\b/\u00198e#V,'/_,ji\"\u001c\u0016p\u001d;f[\u0006c\u0017.Y:)\u0005!\u0003\u0004\"\u0002'\u0001\t\u0013i\u0015!D2sK\u0006$XmU9m-&,w\u000f\u0006\u0002O)B\u0011qJU\u0007\u0002!*\u0011\u0011\u000bC\u0001\bG\u0006$\u0018\r\\8h\u0013\t\u0019\u0006KA\u0006DCR\fGn\\4WS\u0016<\b\"B+L\u0001\u00041\u0016aC8sS\u001eLg\u000eV1cY\u0016\u0004\"a\u00160\u000f\u0005ac\u0006CA-\u001d\u001b\u0005Q&BA.\u0011\u0003\u0019a$o\\8u}%\u0011Q\fH\u0001\u0007!J,G-\u001a4\n\u0005}\u0003'AB*ue&twM\u0003\u0002^9!\"\u0001A\u00195j!\t\u0019g-D\u0001e\u0015\t)''\u0001\u0004sk:tWM]\u0005\u0003O\u0012\u0014qAU;o/&$\b.A\u0003wC2,XmI\u0001k!\tYg.D\u0001m\u0015\ti''A\u0004sk:tWM]:\n\u0005=d'!\u0004)be\u0006lW\r^3sSj,GmB\u0003r\u0005!\u0005!/\u0001\nWS\u0016<8/\u0012=qC:$\u0017N\\4UKN$\bCA\u0014t\r\u0015\t!\u0001#\u0001u'\t\u0019X\u000f\u0005\u0002\u001cm&\u0011q\u000f\b\u0002\u0007\u0003:L(+\u001a4\t\u000b\u0011\u001aH\u0011A=\u0015\u0003IDQa_:\u0005\u0002q\f!\u0002]1sC6,G/\u001a:t)\u0005i\b\u0003B\u000e\u007f\u0003\u0003I!a \u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u000bmq\"#a\u0001\u0011\u0007M\t)!C\u0002\u0002\bQ\u0011\u0011\u0003V1cY\u0016$Vm\u001d;Vi&d')Y:fQ\rQ\u00181\u0002\t\u0005\u0003\u001b\tyB\u0004\u0003\u0002\u0010\u0005ma\u0002BA\t\u00033qA!a\u0005\u0002\u00189\u0019\u0011,!\u0006\n\u0003=I!a\r\b\n\u00055\u0014\u0014bAA\u000fY\u0006i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!!\t\u0002$\tQ\u0001+\u0019:b[\u0016$XM]:\u000b\u0007\u0005uAN\u0002\u0004\u0002(M\u0004\u0011\u0011\u0006\u0002\u0018!JLW.\u001b;jm\u0016\u001c6-\u00197be\u001a+hn\u0019;j_:\u001cB!!\n\u0002,A!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022!\t\u0011BZ;oGRLwN\\:\n\t\u0005U\u0012q\u0006\u0002\u000f'\u000e\fG.\u0019:Gk:\u001cG/[8o\u0011\u001d!\u0013Q\u0005C\u0001\u0003s!\"!a\u000f\u0011\t\u0005u\u0012QE\u0007\u0002g\"A\u0011\u0011IA\u0013\t\u0003\t\u0019%\u0001\u0003fm\u0006dG\u0003CA#\u0003\u0017\n)&!\u0017\u0011\u0007m\t9%C\u0002\u0002Jq\u0011A\u0001T8oO\"A\u0011QJA \u0001\u0004\ty%A\u0001j!\rY\u0012\u0011K\u0005\u0004\u0003'b\"aA%oi\"A\u0011qKA \u0001\u0004\t)%A\u0001m\u0011\u001d\tY&a\u0010A\u0002Y\u000b\u0011a\u001d")
public class ViewsExpandingTest
extends TableTestBase {
    private final Function1<TableTestBase, TableTestUtil> tableTestUtil;

    @Parameterized.Parameters
    public static Function1<TableTestBase, TableTestUtilBase>[] parameters() {
        return ViewsExpandingTest$.MODULE$.parameters();
    }

    @Test
    public void testMixedSqlTableViewExpanding() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableUtil.addDataStream("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.common.ViewsExpandingTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Catalog catalog = (Catalog)tableEnv.getCatalog(tableEnv.getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view1"), (CatalogBaseTable)this.createSqlView("t1"), false);
        tableEnv.createTemporaryView("view2", tableEnv.from("view1"));
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view3"), (CatalogBaseTable)this.createSqlView("view2"), false);
        tableEnv.createTemporaryView("view4", tableEnv.from("view3"));
        tableUtil.verifyExecPlan("select * from view4");
    }

    @Test
    public void testTableApiExpanding() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableUtil.addDataStream("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.common.ViewsExpandingTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        tableEnv.createTemporaryView("view1", tableEnv.from("t1"));
        tableEnv.createTemporaryView("view2", tableEnv.from("view1"));
        tableEnv.createTemporaryView("view3", tableEnv.from("view2"));
        Table query = tableEnv.from("view3");
        tableUtil.verifyExecPlan(query);
    }

    @Test
    public void testSqlExpanding() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableUtil.addDataStream("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.common.ViewsExpandingTest$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Catalog catalog = (Catalog)tableEnv.getCatalog(tableEnv.getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view1"), (CatalogBaseTable)this.createSqlView("t1"), false);
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view2"), (CatalogBaseTable)this.createSqlView("view1"), false);
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view3"), (CatalogBaseTable)this.createSqlView("view2"), false);
        String query = "SELECT * FROM view3";
        tableUtil.verifyExecPlan(query);
    }

    @Test
    public void testViewExpandingWithMismatchRowType() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        String originTableName = "t1";
        tableUtil.addDataStream(originTableName, (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.common.ViewsExpandingTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        CatalogViewImpl aggSqlView = new CatalogViewImpl(new StringBuilder(41).append("select a, b, count(c) from ").append(originTableName).append(" group by a, b").toString(), new StringBuilder(41).append("select a, b, count(c) from ").append(originTableName).append(" group by a, b").toString(), TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT()).build(), new HashMap(), "");
        Catalog catalog = (Catalog)tableEnv.getCatalog(tableEnv.getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view1"), (CatalogBaseTable)aggSqlView, false);
        tableUtil.verifyExecPlan("select * from view1");
    }

    @Test
    public void testViewExpandingWithLateralTableFunction() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableEnv.createTemporarySystemFunction("myFunc", (UserDefinedFunction)new TableFunc0());
        tableEnv.createTemporaryView("source", tableEnv.fromValues(new Object[]{"danny#21", "julian#55", "fabian#30"}).as("f0", new String[0]));
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp_view AS\n        |  SELECT f0, f1\n        |  FROM source as S, LATERAL TABLE(myFunc(f0)) as T(f1, f2)\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        tableUtil.verifyExecPlan("select * from tmp_view");
    }

    @Test
    public void testViewExpandingWithBuiltinFunction() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp_view AS\n        |  SELECT CONCAT('a', 'bc', 'def')\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        ObjectIdentifier objectID = ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)"tmp_view");
        CatalogBaseTable view = ((Catalog)tableEnv.getCatalog(objectID.getCatalogName()).get()).getTable(objectID.toObjectPath());
        Assert.assertThat((Object)((CatalogView)view).getExpandedQuery(), (Matcher)CoreMatchers.is((Object)"SELECT `CONCAT`('a', 'bc', 'def')"));
    }

    @Test
    public void testViewExpandingWithUDF() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableEnv.createTemporaryFunction("func", PrimitiveScalarFunction.class);
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp_view AS\n        |  SELECT func(1, 2, 'abc')\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        ObjectIdentifier objectID = ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)"tmp_view");
        CatalogBaseTable view = ((Catalog)tableEnv.getCatalog(objectID.getCatalogName()).get()).getTable(objectID.toObjectPath());
        Assert.assertThat((Object)((CatalogView)view).getExpandedQuery(), (Matcher)CoreMatchers.is((Object)"SELECT `default_catalog`.`default_database`.`func`(1, 2, 'abc')"));
    }

    @Test
    public void testExpandQueryWithSystemAlias() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableEnv.createTemporaryView("source", tableEnv.fromValues(new Object[]{"danny#21", "julian#55", "fabian#30"}).as("f0", new String[0]));
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |create view tmp_view as\n        |select * from (\n        |  select f0,\n        |  row_number() over (partition by f0 order by f0 desc) as rowNum\n        |  from source)\n        |  where rowNum = 1\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        ObjectIdentifier objectID = ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)"tmp_view");
        CatalogBaseTable view = ((Catalog)tableEnv.getCatalog(objectID.getCatalogName()).get()).getTable(objectID.toObjectPath());
        Assert.assertThat((Object)((CatalogView)view).getExpandedQuery(), (Matcher)CoreMatchers.is((Object)"SELECT *\nFROM (SELECT `source`.`f0`, ROW_NUMBER() OVER (PARTITION BY `source`.`f0` ORDER BY `source`.`f0` DESC) AS `rowNum`\nFROM `default_catalog`.`default_database`.`source`)\nWHERE `rowNum` = 1"));
    }

    private CatalogView createSqlView(String originTable) {
        return new CatalogViewImpl(new StringBuilder(19).append("select * as c from ").append(originTable).toString(), new StringBuilder(14).append("select * from ").append(originTable).toString(), TableSchema.builder().field("a", DataTypes.INT()).field("b", DataTypes.STRING()).field("c", DataTypes.INT()).build(), new HashMap(), "");
    }

    public ViewsExpandingTest(Function1<TableTestBase, TableTestUtil> tableTestUtil) {
        this.tableTestUtil = tableTestUtil;
    }

    public static class PrimitiveScalarFunction
    extends ScalarFunction {
        public long eval(int i, long l, String s) {
            return (long)i + l + (long)s.length();
        }
    }
}

