/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.plan.metadata.AggCallSelectivityEstimator;
import org.apache.flink.table.planner.plan.metadata.AggCallSelectivityEstimatorTest$;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.metadata.MockMetaTable;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimator;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rMc\u0001B\u0001\u0003\u0001E\u0011q$Q4h\u0007\u0006dGnU3mK\u000e$\u0018N^5us\u0016\u001bH/[7bi>\u0014H+Z:u\u0015\t\u0019A!\u0001\u0005nKR\fG-\u0019;b\u0015\t)a!\u0001\u0003qY\u0006t'BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0005?\u0005i\u0011\r\u001c7GS\u0016dGMT1nKN,\u0012\u0001\t\t\u0004C\u00112S\"\u0001\u0012\u000b\u0005\r\"\u0012AC2pY2,7\r^5p]&\u0011QE\t\u0002\u0004'\u0016\f\bCA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011a\u0017M\\4\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0007'R\u0014\u0018N\\4\t\r=\u0002\u0001\u0015!\u0003!\u00039\tG\u000e\u001c$jK2$g*Y7fg\u0002Bq!\r\u0001C\u0002\u0013%!'A\u0007bY24\u0015.\u001a7e)f\u0004Xm]\u000b\u0002gA\u0019\u0011\u0005\n\u001b\u0011\u0005UbT\"\u0001\u001c\u000b\u0005]B\u0014\u0001\u0002;za\u0016T!!\u000f\u001e\u0002\u0007M\fHN\u0003\u0002<\u0019\u000591-\u00197dSR,\u0017BA\u001f7\u0005-\u0019\u0016\u000f\u001c+za\u0016t\u0015-\\3\t\r}\u0002\u0001\u0015!\u00034\u00039\tG\u000e\u001c$jK2$G+\u001f9fg\u0002B!\"\u0011\u0001\u0011\u0002\u0003\r\t\u0015!\u0003C\u0003\rAH%\r\t\u0006'\r+U)R\u0005\u0003\tR\u0011a\u0001V;qY\u0016\u001c\u0004CA\nG\u0013\t9ECA\u0002J]RDq!\u0013\u0001C\u0002\u0013\u0005!*\u0001\u0005oC6,w,\u001b3y+\u0005)\u0005B\u0002'\u0001A\u0003%Q)A\u0005oC6,w,\u001b3yA!9a\n\u0001b\u0001\n\u0003Q\u0015AC1n_VtGoX5eq\"1\u0001\u000b\u0001Q\u0001\n\u0015\u000b1\"Y7pk:$x,\u001b3yA!9!\u000b\u0001b\u0001\n\u0003Q\u0015!\u00039sS\u000e,w,\u001b3y\u0011\u0019!\u0006\u0001)A\u0005\u000b\u0006Q\u0001O]5dK~KG\r\u001f\u0011\t\u000fY\u0003!\u0019!C\u0001/\u0006YA/\u001f9f\r\u0006\u001cGo\u001c:z+\u0005A\u0006CA-\\\u001b\u0005Q&BA\u001e\u0007\u0013\ta&L\u0001\tGY&t7\u000eV=qK\u001a\u000b7\r^8ss\"1a\f\u0001Q\u0001\na\u000bA\u0002^=qK\u001a\u000b7\r^8ss\u0002Bq\u0001\u0019\u0001A\u0002\u0013\u0005\u0011-\u0001\u0006sKb\u0014U/\u001b7eKJ,\u0012A\u0019\t\u00033\u000eL!\u0001\u001a.\u0003\u001f\u0019c\u0017N\\6SKb\u0014U/\u001b7eKJDqA\u001a\u0001A\u0002\u0013\u0005q-\u0001\bsKb\u0014U/\u001b7eKJ|F%Z9\u0015\u0005!\\\u0007CA\nj\u0013\tQGC\u0001\u0003V]&$\bbB!f\u0003\u0003\u0005\rA\u0019\u0005\u0007[\u0002\u0001\u000b\u0015\u00022\u0002\u0017I,\u0007PQ;jY\u0012,'\u000f\t\u0005\b_\u0002\u0011\r\u0011\"\u0001q\u0003-\u0011X\r\u001c#bi\u0006$\u0016\u0010]3\u0016\u0003E\u0004\"A\u001d<\u000e\u0003MT!a\u000e;\u000b\u0005UT\u0014a\u0001:fY&\u0011qo\u001d\u0002\f%\u0016dG)\u0019;b)f\u0004X\r\u0003\u0004z\u0001\u0001\u0006I!]\u0001\re\u0016dG)\u0019;b)f\u0004X\r\t\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0003\ti\u0017/F\u0001~!\tab0\u0003\u0002\u0000\u0005\t)b\t\\5oWJ+G.T3uC\u0012\fG/Y)vKJL\bbBA\u0002\u0001\u0001\u0006I!`\u0001\u0004[F\u0004\u0003bCA\u0004\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0013\tAa]2b]V\u0011\u00111\u0002\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003;\u0002\t\r|'/Z\u0005\u0005\u0003+\tyAA\u0005UC\ndWmU2b]\"Y\u0011\u0011\u0004\u0001A\u0002\u0003\u0007I\u0011AA\u000e\u0003!\u00198-\u00198`I\u0015\fHc\u00015\u0002\u001e!I\u0011)a\u0006\u0002\u0002\u0003\u0007\u00111\u0002\u0005\f\u0003C\u0001\u0001\u0019!A!B\u0013\tY!A\u0003tG\u0006t\u0007\u0005C\u0004\u0002&\u0001!\t!a\n\u0002\u000bM,G/\u001e9\u0015\u0003!DC!a\t\u0002,A!\u0011QFA\u001a\u001b\t\tyCC\u0002\u000229\tQA[;oSRLA!!\u000e\u00020\t1!)\u001a4pe\u0016Dq!!\u000f\u0001\t\u0013\tY$\u0001\u0005n_\u000e\\7kY1o)\u0011\tY!!\u0010\t\u0015\u0005}\u0012q\u0007I\u0001\u0002\u0004\t\t%A\u0005ti\u0006$\u0018n\u001d;jGB!\u00111IA%\u001b\t\t)EC\u0002\u0002H\u0011\tQa\u001d;biNLA!a\u0013\u0002F\tqa\t\\5oWN#\u0018\r^5ti&\u001c\u0007bBA(\u0001\u0011%\u0011\u0011K\u0001\u0010GJ,\u0017\r^3BO\u001e\u0014XmZ1uKR1\u00111KA-\u0003G\u0002B!!\u0004\u0002V%!\u0011qKA\b\u0005%\tum\u001a:fO\u0006$X\r\u0003\u0005\u0002\\\u00055\u0003\u0019AA/\u0003!9'o\\;q'\u0016$\b\u0003B\n\u0002`\u0015K1!!\u0019\u0015\u0005\u0015\t%O]1z\u0011!\t)'!\u0014A\u0002\u0005\u001d\u0014\u0001E:rY\u0006;wMR;o/&$\b.\u0011:h!\u0019\tI'!\u001f\u0002~9!\u00111NA;\u001d\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9!\u00051AH]8pizJ\u0011!F\u0005\u0004\u0003o\"\u0012a\u00029bG.\fw-Z\u0005\u0004K\u0005m$bAA<)A11#a \u0002\u0004\u0016K1!!!\u0015\u0005\u0019!V\u000f\u001d7feA!\u0011QQAD\u001b\u0005A\u0014bAAEq\tq1+\u001d7BO\u001e4UO\\2uS>t\u0007bBA(\u0001\u0011%\u0011Q\u0012\u000b\t\u0003'\ny)!%\u0002\u0014\"A\u0011qAAF\u0001\u0004\tY\u0001\u0003\u0005\u0002\\\u0005-\u0005\u0019AA/\u0011!\t)'a#A\u0002\u0005\u001d\u0004bBAL\u0001\u0011%\u0011\u0011T\u0001\u0015GJ,\u0017\r^3Ok6,'/[2MSR,'/\u00197\u0015\t\u0005m\u0015q\u0015\t\u0005\u0003;\u000b\u0019+\u0004\u0002\u0002 *\u0019\u0011\u0011\u0015\u001e\u0002\u0007I,\u00070\u0003\u0003\u0002&\u0006}%A\u0003*fq2KG/\u001a:bY\"A\u0011\u0011VAK\u0001\u0004\tY+A\u0002ok6\u00042aEAW\u0013\r\ty\u000b\u0006\u0002\u0005\u0019>tw\rC\u0004\u00024\u0002!I!!.\u0002\u001d\r\u0014X-\u0019;f\u0013:\u0004X\u000f\u001e*fMR!\u0011qWA_!\u0011\ti*!/\n\t\u0005m\u0016q\u0014\u0002\f%\u0016D\u0018J\u001c9viJ+g\rC\u0004\u0002@\u0006E\u0006\u0019A#\u0002\u000b%tG-\u001a=\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\u0006Q1M]3bi\u0016\u001c\u0015\r\u001c7\u0015\r\u0005\u001d\u0017QZAl!\u0011\ti*!3\n\t\u0005-\u0017q\u0014\u0002\b%\u0016Dhj\u001c3f\u0011!\ty-!1A\u0002\u0005E\u0017\u0001C8qKJ\fGo\u001c:\u0011\t\u0005\u0015\u00151[\u0005\u0004\u0003+D$aC*rY>\u0003XM]1u_JD\u0001\"!7\u0002B\u0002\u0007\u00111\\\u0001\u0006Kb\u0004(o\u001d\t\u0006'\u0005u\u0017qY\u0005\u0004\u0003?$\"A\u0003\u001fsKB,\u0017\r^3e}!9\u00111\u001d\u0001\u0005\n\u0005\u0015\u0018!E2sK\u0006$XmQ8mk6t7\u000b^1ugRq\u0011q]Az\u0005;\u0011\tC!\f\u0003:\tu\u0003\u0003BAu\u0003_l!!a;\u000b\t\u0005\u001d\u0013Q\u001e\u0006\u0003\u000b!IA!!=\u0002l\nY1i\u001c7v[:\u001cF/\u0019;t\u0011)\t)0!9\u0011\u0002\u0003\u0007\u0011q_\u0001\u0004]\u00124\b#B\n\u0002z\u0006u\u0018bAA~)\t1q\n\u001d;j_:\u0004B!a@\u0003\u00189!!\u0011\u0001B\u000b\u001d\u0011\u0011\u0019Aa\u0005\u000f\t\t\u0015!\u0011\u0003\b\u0005\u0005\u000f\u0011yA\u0004\u0003\u0003\n\t5a\u0002BA7\u0005\u0017I\u0011aD\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\r\t9HB\u0005\u0005\u00053\u0011YBA\u0003K\u0019>twMC\u0002\u0002x\u0019A!Ba\b\u0002bB\u0005\t\u0019AA|\u0003%qW\u000f\u001c7D_VtG\u000f\u0003\u0006\u0003$\u0005\u0005\b\u0013!a\u0001\u0005K\ta!\u0019<h\u0019\u0016t\u0007#B\n\u0002z\n\u001d\u0002\u0003BA\u0000\u0005SIAAa\u000b\u0003\u001c\t9!\nR8vE2,\u0007B\u0003B\u0018\u0003C\u0004\n\u00111\u0001\u00032\u00051Q.\u0019=MK:\u0004RaEA}\u0005g\u00012a\nB\u001b\u0013\r\u00119\u0004\u000b\u0002\b\u0013:$XmZ3s\u0011)\u0011Y$!9\u0011\u0002\u0003\u0007!QH\u0001\u0004[&t\u0007#B\n\u0002z\n}\u0002\u0007\u0002B!\u0005\u0017\u0002Ra\nB\"\u0005\u000fJ1A!\u0012)\u0005)\u0019u.\u001c9be\u0006\u0014G.\u001a\t\u0005\u0005\u0013\u0012Y\u0005\u0004\u0001\u0005\u0019\t5#\u0011HA\u0001\u0002\u0003\u0015\tAa\u0014\u0003\u0007}#\u0013'\u0005\u0003\u0003R\t]\u0003cA\n\u0003T%\u0019!Q\u000b\u000b\u0003\u000f9{G\u000f[5oOB\u00191C!\u0017\n\u0007\tmCCA\u0002B]fD!Ba\u0018\u0002bB\u0005\t\u0019\u0001B1\u0003\ri\u0017\r\u001f\t\u0006'\u0005e(1\r\u0019\u0005\u0005K\u0012I\u0007E\u0003(\u0005\u0007\u00129\u0007\u0005\u0003\u0003J\t%D\u0001\u0004B6\u0005;\n\t\u0011!A\u0003\u0002\t=#aA0%e!9!q\u000e\u0001\u0005\n\tE\u0014\u0001F2sK\u0006$XM\u00127j].\u001cF/\u0019;jgRL7\r\u0006\u0004\u0002B\tM$q\u000f\u0005\u000b\u0005k\u0012i\u0007%AA\u0002\u0005]\u0018\u0001\u0003:po\u000e{WO\u001c;\t\u0015\te$Q\u000eI\u0001\u0002\u0004\u0011Y(\u0001\u0005d_2\u001cF/\u0019;t!\u0015\u0019\u0012\u0011 B?!!\u0011yHa\"\u0003\u000e\u0006\u001dh\u0002\u0002BA\u0005\u0007\u00032!!\u001c\u0015\u0013\r\u0011)\tF\u0001\u0007!J,G-\u001a4\n\t\t%%1\u0012\u0002\u0004\u001b\u0006\u0004(b\u0001BC)A!!q\u0010BH\u0013\ri#1\u0012\u0005\b\u0005'\u0003A\u0011AA\u0014\u0003E!Xm\u001d;Tk6<\u0016\u000e\u001e5FcV\fGn\u001d\u0015\u0005\u0005#\u00139\n\u0005\u0003\u0002.\te\u0015\u0002\u0002BN\u0003_\u0011A\u0001V3ti\"9!q\u0014\u0001\u0005\u0002\u0005\u001d\u0012a\u0005;fgR\u001cV/\\,ji\"dUm]:UQ\u0006t\u0007\u0006\u0002BO\u0005/CqA!*\u0001\t\u0003\t9#A\u000fuKN$8+^7XSRDG*Z:t)\"\fgn\u0014:FcV\fGn\u001d+pQ\u0011\u0011\u0019Ka&\t\u000f\t-\u0006\u0001\"\u0001\u0002(\u00051B/Z:u'Vlw+\u001b;i\u000fJ,\u0017\r^3s)\"\fg\u000e\u000b\u0003\u0003*\n]\u0005b\u0002BY\u0001\u0011\u0005\u0011qE\u0001\u001fi\u0016\u001cHoU;n/&$\bn\u0012:fCR,'\u000f\u00165b]>\u0013X)];bYNDCAa,\u0003\u0018\"9!q\u0017\u0001\u0005\u0002\u0005\u001d\u0012A\u0003;fgRl\u0015\r_'j]\"\"!Q\u0017BL\u0011\u001d\u0011i\f\u0001C\u0001\u0003O\tq\u0001^3ti\u00063x\r\u000b\u0003\u0003<\n]\u0005b\u0002Bb\u0001\u0011\u0005\u0011qE\u0001\ni\u0016\u001cHoQ8v]RDCA!1\u0003\u0018\"9!\u0011\u001a\u0001\u0005\u0002\u0005\u001d\u0012a\u0002;fgR\fe\u000e\u001a\u0015\u0005\u0005\u000f\u00149\nC\u0004\u0003P\u0002!\t!a\n\u0002\rQ,7\u000f^(sQ\u0011\u0011iMa&\t\u0013\tU\u0007!%A\u0005\n\t]\u0017AE7pG.\u001c6-\u00198%I\u00164\u0017-\u001e7uIE*\"A!7+\t\u0005\u0005#1\\\u0016\u0003\u0005;\u0004BAa8\u0003j6\u0011!\u0011\u001d\u0006\u0005\u0005G\u0014)/A\u0005v]\u000eDWmY6fI*\u0019!q\u001d\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003l\n\u0005(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!q\u001e\u0001\u0012\u0002\u0013%!\u0011_\u0001\u001cGJ,\u0017\r^3D_2,XN\\*uCR\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tM(\u0006BA|\u00057D\u0011Ba>\u0001#\u0003%IA!=\u00027\r\u0014X-\u0019;f\u0007>dW/\u001c8Ti\u0006$8\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011%\u0011Y\u0010AI\u0001\n\u0013\u0011i0A\u000ede\u0016\fG/Z\"pYVlgn\u0015;biN$C-\u001a4bk2$HeM\u000b\u0003\u0005\u007fTCA!\n\u0003\\\"I11\u0001\u0001\u0012\u0002\u0013%1QA\u0001\u001cGJ,\u0017\r^3D_2,XN\\*uCR\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\u001d!\u0006\u0002B\u0019\u00057D\u0011ba\u0003\u0001#\u0003%Ia!\u0004\u00027\r\u0014X-\u0019;f\u0007>dW/\u001c8Ti\u0006$8\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019yA\u000b\u0003\u0004\u0012\tm\u0007#B\n\u0002z\u000eM\u0001\u0007BB\u000b\u00073\u0001Ra\nB\"\u0007/\u0001BA!\u0013\u0004\u001a\u0011a!QJB\u0005\u0003\u0003\u0005\tQ!\u0001\u0003P!I1Q\u0004\u0001\u0012\u0002\u0013%1qD\u0001\u001cGJ,\u0017\r^3D_2,XN\\*uCR\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\r\u0005\"\u0006BB\u0012\u00057\u0004RaEA}\u0007K\u0001Daa\n\u0004,A)qEa\u0011\u0004*A!!\u0011JB\u0016\t1\u0011Yga\u0007\u0002\u0002\u0003\u0005)\u0011\u0001B(\u0011%\u0019y\u0003AI\u0001\n\u0013\u0011\t0\u0001\u0010de\u0016\fG/\u001a$mS:\\7\u000b^1uSN$\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%c!I11\u0007\u0001\u0012\u0002\u0013%1QG\u0001\u001fGJ,\u0017\r^3GY&t7n\u0015;bi&\u001cH/[2%I\u00164\u0017-\u001e7uII*\"aa\u000e+\t\tm$1\\\u0004\b\u0007w\u0011\u0001\u0012AB\u001f\u0003}\tumZ\"bY2\u001cV\r\\3di&4\u0018\u000e^=FgRLW.\u0019;peR+7\u000f\u001e\t\u00049\r}bAB\u0001\u0003\u0011\u0003\u0019\teE\u0002\u0004@IAq!GB \t\u0003\u0019)\u0005\u0006\u0002\u0004>!A1\u0011JB \t\u0003\t9#A\u0005cK\u001a|'/Z!mY\"\"1qIB'!\u0011\tica\u0014\n\t\rE\u0013q\u0006\u0002\f\u0005\u00164wN]3DY\u0006\u001c8\u000f")
public class AggCallSelectivityEstimatorTest {
    private final Seq<String> allFieldNames = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "amount", "price"}));
    private final Seq<SqlTypeName> allFieldTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.VARCHAR, SqlTypeName.INTEGER, SqlTypeName.DOUBLE}));
    private final /* synthetic */ Tuple3 x$1;
    private final int name_idx;
    private final int amount_idx;
    private final int price_idx;
    private final FlinkTypeFactory typeFactory;
    private FlinkRexBuilder rexBuilder;
    private final RelDataType relDataType;
    private final FlinkRelMetadataQuery mq;
    private TableScan scan;

    @BeforeClass
    public static void beforeAll() {
        AggCallSelectivityEstimatorTest$.MODULE$.beforeAll();
    }

    private Seq<String> allFieldNames() {
        return this.allFieldNames;
    }

    private Seq<SqlTypeName> allFieldTypes() {
        return this.allFieldTypes;
    }

    public int name_idx() {
        return this.name_idx;
    }

    public int amount_idx() {
        return this.amount_idx;
    }

    public int price_idx() {
        return this.price_idx;
    }

    public FlinkTypeFactory typeFactory() {
        return this.typeFactory;
    }

    public FlinkRexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    public void rexBuilder_$eq(FlinkRexBuilder x$1) {
        this.rexBuilder = x$1;
    }

    public RelDataType relDataType() {
        return this.relDataType;
    }

    public FlinkRelMetadataQuery mq() {
        return this.mq;
    }

    public TableScan scan() {
        return this.scan;
    }

    public void scan_$eq(TableScan x$1) {
        this.scan = x$1;
    }

    @Before
    public void setup() {
        this.scan_$eq(this.mockScan(this.mockScan$default$1()));
    }

    private TableScan mockScan(FlinkStatistic statistic) {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        MockMetaTable table = new MockMetaTable(this.relDataType(), statistic);
        rootSchema.add("test", (Table)table);
        PlannerContext plannerContext = PlannerMocks.newBuilder().withRootSchema(CalciteSchema.from((SchemaPlus)rootSchema)).build().getPlannerContext();
        FlinkRelBuilder relBuilder = plannerContext.createRelBuilder();
        relBuilder.clear();
        return (TableScan)relBuilder.scan(Arrays.asList((Object[])new String[]{"test"})).build();
    }

    private FlinkStatistic mockScan$default$1() {
        return FlinkStatistic$.MODULE$.UNKNOWN();
    }

    private Aggregate createAggregate(int[] groupSet, Seq<Tuple2<SqlAggFunction, Object>> sqlAggFunWithArg) {
        return this.createAggregate(this.scan(), groupSet, sqlAggFunWithArg);
    }

    private Aggregate createAggregate(TableScan scan, int[] groupSet, Seq<Tuple2<SqlAggFunction, Object>> sqlAggFunWithArg) {
        Seq aggCalls = (Seq)sqlAggFunWithArg.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SqlAggFunction sqlAggFun = (SqlAggFunction)tuple2._1();
            int arg = tuple2._2$mcI$sp();
            SqlAggFunction sqlAggFunction = sqlAggFun;
            SqlAggFunction sqlAggFunction2 = SqlStdOperatorTable.COUNT;
            SqlAggFunction sqlAggFunction3 = sqlAggFunction;
            RelDataType relDataType = !(sqlAggFunction2 != null ? !sqlAggFunction2.equals(sqlAggFunction3) : sqlAggFunction3 != null) ? this.typeFactory().createSqlType(SqlTypeName.BIGINT) : ((RelDataTypeField)scan.getRowType().getFieldList().get(arg)).getType();
            RelDataType aggCallType = relDataType;
            AggregateCall aggregateCall = AggregateCall.create((SqlAggFunction)sqlAggFun, (boolean)false, (boolean)false, (List)ImmutableList.of((Object)arg), (int)-1, (int)groupSet.length, (RelNode)scan, (RelDataType)aggCallType, (String)((String)scan.getRowType().getFieldNames().get(arg)));
            return aggregateCall;
        }, Seq$.MODULE$.canBuildFrom());
        return LogicalAggregate.create((RelNode)scan, (ImmutableBitSet)ImmutableBitSet.of((int[])groupSet), null, (List)ImmutableList.copyOf((Object[])((Object[])aggCalls.toArray(ClassTag$.MODULE$.apply(AggregateCall.class)))));
    }

    private RexLiteral createNumericLiteral(long num) {
        return this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(num));
    }

    private RexInputRef createInputRef(int index) {
        RelDataType relDataType = this.typeFactory().createSqlType((SqlTypeName)this.allFieldTypes().apply(index));
        RelDataType relDataTypeWithNullability = this.typeFactory().createTypeWithNullability(relDataType, false);
        return this.rexBuilder().makeInputRef(relDataTypeWithNullability, index);
    }

    private RexNode createCall(SqlOperator operator, Seq<RexNode> exprs) {
        Preconditions.checkArgument((boolean)exprs.nonEmpty());
        return this.rexBuilder().makeCall(operator, (RexNode[])exprs.toArray(ClassTag$.MODULE$.apply(RexNode.class)));
    }

    private ColumnStats createColumnStats(Option<Long> ndv, Option<Long> nullCount, Option<Double> avgLen, Option<Integer> maxLen, Option<Comparable<?>> min, Option<Comparable<?>> max) {
        return ColumnStats.Builder.builder().setNdv((Long)ndv.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setNullCount((Long)nullCount.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setAvgLen((Double)avgLen.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setMaxLen((Integer)maxLen.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setMax((Comparable)max.orNull(Predef$.MODULE$.$conforms())).setMin((Comparable)min.orNull(Predef$.MODULE$.$conforms())).build();
    }

    private Option<Long> createColumnStats$default$1() {
        return None$.MODULE$;
    }

    private Option<Long> createColumnStats$default$2() {
        return None$.MODULE$;
    }

    private Option<Double> createColumnStats$default$3() {
        return None$.MODULE$;
    }

    private Option<Integer> createColumnStats$default$4() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$5() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$6() {
        return None$.MODULE$;
    }

    private FlinkStatistic createFlinkStatistic(Option<Long> rowCount, Option<scala.collection.immutable.Map<String, ColumnStats>> colStats) {
        Predef$.MODULE$.require(rowCount.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "rowCount must be non null now");
        TableStats tableStats = colStats.isDefined() ? new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)colStats.get())) : new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), null);
        return FlinkStatistic$.MODULE$.builder().tableStats(tableStats).build();
    }

    private Option<Long> createFlinkStatistic$default$1() {
        return None$.MODULE$;
    }

    private Option<scala.collection.immutable.Map<String, ColumnStats>> createFlinkStatistic$default$2() {
        return None$.MODULE$;
    }

    @Test
    public void testSumWithEquals() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.025)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)estimator1.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultEqualsSelectivity(), (Object)estimator3.evaluate(predicate1));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg4 = this.createAggregate(this.mockScan(statistic3), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator4 = new AggCallSelectivityEstimator((RelNode)agg4, this.mq());
        Assert.assertEquals((Object)se.defaultEqualsSelectivity(), (Object)estimator4.evaluate(predicate1));
    }

    @Test
    public void testSumWithLessThan() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.25)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testSumWithLessThanOrEqualsTo() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.25)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testSumWithGreaterThan() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.75)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testSumWithGreaterThanOrEquals() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.75)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testMaxMin() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.MAX, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.MIN, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate2));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.MAX, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.MIN, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(50L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate5));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3103448275862069)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.MIN, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.MAX, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate2));
    }

    @Test
    public void testAvg() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate2));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(50L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate5));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3103448275862069)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate2));
    }

    @Test
    public void testCount() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(6L)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(5L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9526830054771714)), (Object)estimator1.evaluate(predicate1));
        Assert.assertEquals((Object)estimator1.defaultAggCallSelectivity(), (Object)estimator1.evaluate(predicate2));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(6L)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.16666666666666666)), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(10L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate5));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)estimator2.evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)estimator3.evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator3.evaluate(predicate2));
    }

    @Test
    public void testAnd() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator = new AggCallSelectivityEstimator((RelNode)agg, this.mq());
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}))}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.23706896551724138)), (Object)estimator.evaluate(predicate));
    }

    @Test
    public void testOr() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator = new AggCallSelectivityEstimator((RelNode)agg, this.mq());
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}))}));
        double s1 = 0.25;
        double s2 = 0.9482758620689655;
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(s1 + s2 - s1 * s2))), (Object)estimator.evaluate(predicate));
    }

    public AggCallSelectivityEstimatorTest() {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int name_idx = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int amount_idx = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int price_idx = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)name_idx), (Object)BoxesRunTime.boxToInteger((int)amount_idx), (Object)BoxesRunTime.boxToInteger((int)price_idx));
        this.x$1 = tuple32;
        this.name_idx = BoxesRunTime.unboxToInt((Object)this.x$1._1());
        this.amount_idx = BoxesRunTime.unboxToInt((Object)this.x$1._2());
        this.price_idx = BoxesRunTime.unboxToInt((Object)this.x$1._3());
        this.typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
        this.rexBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        this.relDataType = this.typeFactory().createStructType(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)this.allFieldTypes().map((Function1 & Serializable & scala.Serializable)typeName -> this.typeFactory().createSqlType(typeName), Seq$.MODULE$.canBuildFrom())), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(this.allFieldNames()));
        this.mq = FlinkRelMetadataQuery.instance();
    }
}

