/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.visitor.ExecNodeVisitor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class TestingBatchExecNode
implements BatchExecNode<RowData> {
    private final String description;
    private final List<ExecEdge> inputEdges;
    private final List<InputProperty> inputProperties;

    public TestingBatchExecNode(String description) {
        this.description = description;
        this.inputEdges = new ArrayList<ExecEdge>();
        this.inputProperties = new ArrayList<InputProperty>();
    }

    public void addInput(ExecNode<?> input) {
        this.addInput(input, InputProperty.DEFAULT);
    }

    public void addInput(ExecNode<?> input, InputProperty inputProperty) {
        this.inputEdges.add(ExecEdge.builder().source(input).target((ExecNode)this).build());
        this.inputProperties.add(inputProperty);
    }

    public List<ExecNode<?>> getInputNodes() {
        return this.inputEdges.stream().map(ExecEdge::getSource).collect(Collectors.toList());
    }

    public int getId() {
        return 0;
    }

    public String getDescription() {
        return this.description;
    }

    public LogicalType getOutputType() {
        return RowType.of((LogicalType[])new LogicalType[0]);
    }

    public List<InputProperty> getInputProperties() {
        return this.inputProperties;
    }

    public List<ExecEdge> getInputEdges() {
        return this.inputEdges;
    }

    public void setInputEdges(List<ExecEdge> inputEdges) {
        this.inputEdges.clear();
        this.inputEdges.addAll(inputEdges);
    }

    public void replaceInputEdge(int index, ExecEdge newInputEdge) {
        Preconditions.checkArgument((index >= 0 && index < this.inputEdges.size() ? 1 : 0) != 0);
        this.inputEdges.set(index, newInputEdge);
    }

    public Transformation<RowData> translateToPlan(Planner planner) {
        throw new TableException("Unsupported operation.");
    }

    public void accept(ExecNodeVisitor visitor) {
        visitor.visit((ExecNode)this);
    }

    public void setCompiled(boolean isCompiled) {
        throw new TableException("Unsupported operation.");
    }

    public String toString() {
        return this.description;
    }
}

