/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;

public class CalcJsonPlanTest
extends TableTestBase {
    private StreamTableTestUtil util;
    private TableEnvironment tEnv;

    @Before
    public void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int not null,\n  c varchar,\n  d timestamp(3)\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl);
    }

    @Test
    public void testSimpleProject() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into MySink select a, b from MyTable");
    }

    @Test
    public void testSimpleFilter() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int,\n  c varchar,\n  d timestamp(3)\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into MySink select * from MyTable where b > 0");
    }

    @Test
    public void testComplexCalc() {
        this.tEnv.createTemporaryFunction("udf1", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc0());
        this.tEnv.createTemporaryFunction("udf2", JavaUserDefinedScalarFunctions.JavaFunc1.class);
        this.tEnv.createTemporarySystemFunction("udf3", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc2());
        this.tEnv.createTemporarySystemFunction("udf4", JavaUserDefinedScalarFunctions.UdfWithOpen.class);
        this.tEnv.createFunction("udf5", JavaUserDefinedScalarFunctions.JavaFunc5.class);
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  a1 varchar,\n  b int,\n  b1 varchar,\n  c1 varchar,\n  c2 varchar,\n  d1 timestamp(3)\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into MySink select a, cast(a as varchar) as a1, b, udf2(b, b, d) as b1, udf3(c, b) as c1, udf4(substring(c, 1, 5)) as c2, udf5(d, 1000) as d1 from MyTable where (udf1(a) > 0 or (a * b) < 100) and b > 10");
    }
}

