/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;

public class MatchRecognizeJsonPlanTest
extends TableTestBase {
    private StreamTableTestUtil util;
    private TableEnvironment tEnv;

    @Before
    public void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
    }

    @Test
    public void testMatch() {
        String srcTableDdl = "CREATE TABLE MyTable (\n  id bigint,\n  name varchar,\n  proctime as PROCTIME()\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b bigint,\n  c bigint\n) with (\n  'connector' = 'values',\n  'sink-insert-only' = 'false',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        String sql = "insert into MySink SELECT T.aid, T.bid, T.cid\n     FROM MyTable MATCH_RECOGNIZE (\n             ORDER BY proctime\n             MEASURES\n             `A\"`.id AS aid,\n             l.id AS bid,\n             C.id AS cid\n             PATTERN (`A\"` l C)\n             DEFINE\n                 `A\"` AS name = 'a',\n                 l AS name = 'b',\n                 C AS name = 'c'\n     ) AS T";
        this.util.verifyJsonPlan(sql);
    }
}

