/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.PlannerConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkRuleSetProgram;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchExecSortAggRuleForOnePhase$;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalSortAggRule$;
import org.apache.flink.table.planner.plan.rules.physical.batch.EnforceLocalAggRuleTestBase;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.junit.Before;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001+\tYRI\u001c4pe\u000e,Gj\\2bYN{'\u000f^!hOJ+H.\u001a+fgRT!a\u0001\u0003\u0002\u000b\t\fGo\u00195\u000b\u0005\u00151\u0011\u0001\u00039isNL7-\u00197\u000b\u0005\u001dA\u0011!\u0002:vY\u0016\u001c(BA\u0005\u000b\u0003\u0011\u0001H.\u00198\u000b\u0005-a\u0011a\u00029mC:tWM\u001d\u0006\u0003\u001b9\tQ\u0001^1cY\u0016T!a\u0004\t\u0002\u000b\u0019d\u0017N\\6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\tYRI\u001c4pe\u000e,Gj\\2bY\u0006;wMU;mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005]\u0001\u0001\"B\u0010\u0001\t\u0003\u0002\u0013!B:fiV\u0004H#A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0003=!\u0002\"!\u000b\u0017\u000e\u0003)R!a\u000b\n\u0002\u000b),h.\u001b;\n\u00055R#A\u0002\"fM>\u0014X\rC\u00030\u0001\u0011\u0005\u0001%\u0001\u0011uKN$(k\u001c7mkB<\u0016\u000e\u001e5V]6,'oZ3bE2,\u0017iZ4DC2d\u0007F\u0001\u00182!\tI#'\u0003\u00024U\t!A+Z:u\u0011\u0015)\u0004\u0001\"\u0001!\u0003y!Xm\u001d;Dk\n,w+\u001b;i+:lWM]4fC\ndW-Q4h\u0007\u0006dG\u000e\u000b\u00025c!)\u0001\b\u0001C\u0001A\u0005\u0019C/Z:u\u000fJ|W\u000f]*fiN<\u0016\u000e\u001e5V]6,'oZ3bE2,\u0017iZ4DC2d\u0007FA\u001c2\u0001")
public class EnforceLocalSortAggRuleTest
extends EnforceLocalAggRuleTestBase {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.util().addFunction("weightedAvg", new JavaUserDefinedAggFunctions.WeightedAvg(), BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class));
        FlinkChainedProgram program = FlinkBatchProgram$.MODULE$.buildProgram((ReadableConfig)this.util().tableEnv().getConfig());
        ((FlinkRuleSetProgram)program.getFlinkRuleSetProgram(FlinkBatchProgram$.MODULE$.PHYSICAL()).get()).remove(RuleSets.ofList((RelOptRule[])new RelOptRule[]{BatchPhysicalSortAggRule$.MODULE$.INSTANCE()}));
        ((FlinkRuleSetProgram)program.getFlinkRuleSetProgram(FlinkBatchProgram$.MODULE$.PHYSICAL()).get()).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{BatchExecSortAggRuleForOnePhase$.MODULE$.INSTANCE()}));
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        calciteConfig = CalciteConfig$.MODULE$.createBuilder(calciteConfig).replaceBatchProgram(program).build();
        this.util().tableEnv().getConfig().setPlannerConfig((PlannerConfig)calciteConfig);
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)"TWO_PHASE");
    }

    @Test
    public void testRollupWithUnmergeableAggCall() {
        this.util().verifyRelPlan("SELECT weightedAvg(a, 1) FROM t GROUP BY ROLLUP (b, c)");
    }

    @Test
    public void testCubeWithUnmergeableAggCall() {
        this.util().verifyRelPlan("SELECT weightedAvg(d, 1) FROM t GROUP BY CUBE (a, b)");
    }

    @Test
    public void testGroupSetsWithUnmergeableAggCall() {
        this.util().verifyRelPlan("select weightedAvg(a, 1) FROM t GROUP BY GROUPING SETS ((b, c), (b, d))");
    }
}

