/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.planner.plan.stream.sql.RelTimeIndicatorConverterTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001M\u0011QDU3m)&lW-\u00138eS\u000e\fGo\u001c:D_:4XM\u001d;feR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\ruKN$8+[7qY\u0016l\u0015\r^3sS\u0006d\u0017N_1uS>tG#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003OE\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\t\u0002\u000b),h.\u001b;\n\u0005Y\u001a$\u0001\u0002+fgRDQ\u0001\u000f\u0001\u0005\u0002%\nQ\u0002^3tiN+G.Z2u\u00032d\u0007FA\u001c2\u0011\u0015Y\u0004\u0001\"\u0001*\u0003Y!Xm\u001d;GS2$XM]5oO>s'k\\<uS6,\u0007F\u0001\u001e2\u0011\u0015q\u0004\u0001\"\u0001*\u0003U!Xm\u001d;He>,\b/\u001b8h\u001f:\u0014vn\u001e;j[\u0016D#!P\u0019\t\u000b\u0005\u0003A\u0011A\u0015\u00021Q,7\u000f^!hOJ,w-\u0019;j_:|eNU8xi&lW\r\u000b\u0002Ac!)A\t\u0001C\u0001S\u00051B/Z:u\u000fJ|W\u000f]5oO>s\u0007K]8di&lW\r\u000b\u0002Dc!)q\t\u0001C\u0001S\u0005IB/Z:u\u0003\u001e<'/Z4bi&|gn\u00148Qe>\u001cG/[7fQ\t1\u0015\u0007C\u0003K\u0001\u0011\u0005\u0011&A\tuKN$H+\u00192mK\u001a+hn\u0019;j_:D#!S\u0019\t\u000b5\u0003A\u0011A\u0015\u0002\u0013Q,7\u000f^+oS>t\u0007F\u0001'2\u0011\u0015\u0001\u0006\u0001\"\u0001*\u0003)!Xm\u001d;XS:$wn\u001e\u0015\u0003\u001fFBQa\u0015\u0001\u0005\u0002%\n1\u0002^3ti^Kg\u000eZ8xe!\u0012!+\r\u0005\u0006-\u0002!\t!K\u0001\u0010i\u0016\u001cH/T;mi&<\u0016N\u001c3po\"\u0012Q+\r\u0005\u00063\u0002!\t!K\u0001#i\u0016\u001cHoV5oI><x+\u001b;i\u0003\u001e<'/Z4bi&|gn\u00148S_^$\u0018.\\3)\u0005a\u000b\u0004\"\u0002/\u0001\t\u0003I\u0013\u0001\f;fgR<\u0016N\u001c3po^KG\u000f[!hOJ,w-\u0019;j_:|eNU8xi&lWmV5uQ\"\u000bg/\u001b8hQ\tY\u0016\u0007C\u0003`\u0001\u0011\u0005\u0011&\u0001\u0017uKN$8*Z3q!J|7-Z:t)&lW-\u0011;ue\u00063G/\u001a:Tk\n<%/\u00199i\u001fB$\u0018.\\5{K\"\u0012a,M\u0004\u0006E\nA\taY\u0001\u001e%\u0016dG+[7f\u0013:$\u0017nY1u_J\u001cuN\u001c<feR,'\u000fV3tiB\u0011a\u0004\u001a\u0004\u0006\u0003\tA\t!Z\n\u0003I\u001a\u0004\"aK4\n\u0005!d#AB!osJ+g\rC\u0003\u001cI\u0012\u0005!\u000eF\u0001d\r\u0011aG\rA7\u0003\u0013Q\u000b'\r\\3Gk:\u001c7CA6o!\ry'\u000f^\u0007\u0002a*\u0011\u0011OC\u0001\nMVt7\r^5p]NL!a\u001d9\u0003\u001bQ\u000b'\r\\3Gk:\u001cG/[8o!\t)HP\u0004\u0002wuB\u0011q\u000fL\u0007\u0002q*\u0011\u0011PE\u0001\u0007yI|w\u000e\u001e \n\u0005md\u0013A\u0002)sK\u0012,g-\u0003\u0002~}\n11\u000b\u001e:j]\u001eT!a\u001f\u0017\t\rmYG\u0011AA\u0001)\t\t\u0019\u0001E\u0002\u0002\u0006-l\u0011\u0001\u001a\u0005\n\u0003\u0013Y'\u0019!C\u0001\u0003\u0017\t\u0011\u0001^\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00185\u0011\u0011\u0011\u0003\u0006\u0004\u0007\u0005M!BAA\u000b\u0003\u0011Q\u0017M^1\n\t\u0005e\u0011\u0011\u0003\u0002\n)&lWm\u001d;b[BD\u0001\"!\blA\u0003%\u0011QB\u0001\u0003i\u0002Bq!!\tl\t\u0003\t\u0019#\u0001\u0003fm\u0006dGc\u0002\u0016\u0002&\u0005U\u0012\u0011\b\u0005\t\u0003O\ty\u00021\u0001\u0002*\u0005)A/[7fcA!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020)\tA\u0001Z1uC&!\u00111GA\u0017\u00055!\u0016.\\3ti\u0006l\u0007\u000fR1uC\"A\u0011qGA\u0010\u0001\u0004\ti!A\u0003uS6,'\u0007C\u0004\u0002<\u0005}\u0001\u0019\u0001;\u0002\rM$(/\u001b8h\u0001")
public class RelTimeIndicatorConverterTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testSimpleMaterialization() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime FROM\n        |    (SELECT FLOOR(rowtime TO DAY) AS rowtime, long FROM MyTable WHERE long > 0) t\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSelectAll() {
        this.util().verifyExecPlan("SELECT * FROM MyTable");
    }

    @Test
    public void testFilteringOnRowtime() {
        String sqlQuery = "SELECT rowtime FROM MyTable1 WHERE rowtime > CAST('1990-12-02 12:11:11' AS TIMESTAMP(3))";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingOnRowtime() {
        this.util().verifyExecPlan("SELECT COUNT(long) FROM MyTable GROUP BY rowtime");
    }

    @Test
    public void testAggregationOnRowtime() {
        this.util().verifyExecPlan("SELECT MIN(rowtime) FROM MyTable1 GROUP BY long");
    }

    @Test
    public void testGroupingOnProctime() {
        this.util().verifyExecPlan("SELECT COUNT(long) FROM MyTable2 GROUP BY proctime");
    }

    @Test
    public void testAggregationOnProctime() {
        this.util().verifyExecPlan("SELECT MIN(proctime) FROM MyTable2 GROUP BY long");
    }

    @Test
    public void testTableFunction() {
        this.util().addFunction("tableFunc", new TableFunc(), BasicTypeInfo.getInfoFor(String.class));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, proctime, s\n        |FROM MyTable, LATERAL TABLE(tableFunc(rowtime, proctime, '')) AS T(s)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testUnion() {
        this.util().verifyExecPlan("SELECT rowtime FROM MyTable1 UNION ALL SELECT rowtime FROM MyTable1");
    }

    @Test
    public void testWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(rowtime, INTERVAL '10' SECOND),\n        |    long,\n        |    SUM(`int`)\n        |FROM MyTable1\n        |    GROUP BY TUMBLE(rowtime, INTERVAL '10' SECOND), long\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testWindow2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(rowtime, INTERVAL '0.1' SECOND) AS `rowtime`,\n        |    `long`,\n        |   SUM(`int`)\n        |FROM MyTable1\n        |   GROUP BY `long`, TUMBLE(rowtime, INTERVAL '0.1' SECOND)\n        |\n        ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testMultiWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(newrowtime, INTERVAL '30' SECOND), long, sum(`int`) FROM (\n        |    SELECT\n        |        TUMBLE_ROWTIME(rowtime, INTERVAL '10' SECOND) AS newrowtime,\n        |        long,\n        |        sum(`int`) as `int`\n        |    FROM MyTable1\n        |        GROUP BY TUMBLE(rowtime, INTERVAL '10' SECOND), long\n        |) t GROUP BY TUMBLE(newrowtime, INTERVAL '30' SECOND), long\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testWindowWithAggregationOnRowtime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MIN(rowtime), long FROM MyTable1\n        |GROUP BY long, TUMBLE(rowtime, INTERVAL '0.1' SECOND)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testWindowWithAggregationOnRowtimeWithHaving() {
        String result = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MIN(rowtime), long FROM MyTable1\n        |GROUP BY long, TUMBLE(rowtime, INTERVAL '1' SECOND)\n        |HAVING QUARTER(TUMBLE_END(rowtime, INTERVAL '1' SECOND)) = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(result);
    }

    @Test
    public void testKeepProcessTimeAttrAfterSubGraphOptimize() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    long,\n        |    SUM(`int`)\n        |FROM MyTable2\n        |    GROUP BY TUMBLE(proctime, INTERVAL '10' SECOND), long\n      ")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sql);
        AppendStreamTableSink<Row> appendSink1 = this.util().createAppendTableSink((String[])((Object[])new String[]{"long", "sum"}), (LogicalType[])((Object[])new LogicalType[]{new BigIntType(), new BigIntType()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink1", appendSink1);
        stmtSet.addInsert("appendSink1", table);
        AppendStreamTableSink<Row> appendSink2 = this.util().createAppendTableSink((String[])((Object[])new String[]{"long", "sum"}), (LogicalType[])((Object[])new LogicalType[]{new BigIntType(), new BigIntType()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink2", appendSink2);
        stmtSet.addInsert("appendSink2", table);
        this.util().verifyExecPlan(stmtSet);
    }

    public RelTimeIndicatorConverterTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "long")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.RelTimeIndicatorConverterTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "long")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.RelTimeIndicatorConverterTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "long")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcJI.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.RelTimeIndicatorConverterTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    public static class TableFunc
    extends TableFunction<String> {
        private final Timestamp t = new Timestamp(0L);

        public Timestamp t() {
            return this.t;
        }

        public void eval(TimestampData time1, Timestamp time2, String string) {
            this.collect(new StringBuilder(0).append(time1.toString()).append(time2.after(this.t())).append(string).toString());
        }
    }
}

