/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001'\t9r+\u001b8e_^$\u0016M\u00197f\rVt7\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0007uKN$H+^7cY\u0016$fK\u0012\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!QK\\5uQ\t9\u0013\u0007\u0005\u00023k5\t1G\u0003\u00025!\u0005)!.\u001e8ji&\u0011ag\r\u0002\u0005)\u0016\u001cH\u000fC\u00039\u0001\u0011\u0005\u0011&A\u000buKN$H+^7cY\u0016$fK\u0012)s_\u000e$\u0018.\\3)\u0005]\n\u0004\"B\u001e\u0001\t\u0003I\u0013A\u0003;fgRDu\u000e\u001d+W\r\"\u0012!(\r\u0005\u0006}\u0001!\t!K\u0001\u0013i\u0016\u001cH\u000fS8q)Z3\u0005K]8di&lW\r\u000b\u0002>c!)\u0011\t\u0001C\u0001S\u0005yA/Z:u\u0007VlW\u000f\\1uKR3f\t\u000b\u0002Ac!)A\t\u0001C\u0001S\u00059B/Z:u\u0007VlW\u000f\\1uKR3f\t\u0015:pGRLW.\u001a\u0015\u0003\u0007FBQa\u0012\u0001\u0005\u0002%\nA\u0004^3ti^Kg\u000eZ8x\u001f:tuN\u001c+j[\u0016\fE\u000f\u001e:jEV$X\r\u000b\u0002Gc!)!\n\u0001C\u0001S\u0005IB/Z:u\u0007>tg\r\\5di&twMR5fY\u0012t\u0015-\\3tQ\tI\u0015\u0007C\u0003N\u0001\u0011\u0005\u0011&A\fuKN$H+^7cY\u0016$fKR,ji\"|eMZ:fi\"\u0012A*\r\u0005\u0006!\u0002!\t!K\u0001 i\u0016\u001cH\u000fV;nE2,GK\u0016$XSRDg*Z4bi&4Xm\u00144gg\u0016$\bFA(2\u0011\u0015\u0019\u0006\u0001\"\u0001*\u0003Q!Xm\u001d;I_B$fKR,ji\"|eMZ:fi\"\u0012!+\r\u0005\u0006-\u0002!\t!K\u0001\u001di\u0016\u001cH\u000fS8q)Z3u+\u001b;i\u001d\u0016<\u0017\r^5wK>3gm]3uQ\t)\u0016\u0007C\u0003Z\u0001\u0011\u0005\u0011&A\ruKN$8)^7vY\u0006$X\r\u0016,G/&$\bn\u00144gg\u0016$\bF\u0001-2\u0011\u0015a\u0006\u0001\"\u0001*\u0003\u0005\"Xm\u001d;Dk6,H.\u0019;f)Z3u+\u001b;i\u001d\u0016<\u0017\r^5wK>3gm]3uQ\tY\u0016\u0007")
public class WindowTableFunctionTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testTumbleTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTumbleTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | CUMULATE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testWindowOnNonTimeAttribute() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE VIEW v1 AS\n                               |SELECT *, LOCALTIMESTAMP AS cur_time\n                               |FROM MyTable\n                               |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | TUMBLE(TABLE v1, DESCRIPTOR(cur_time), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.thrown().expectCause(FlinkMatchers.containsCause((Throwable)new ValidationException("The window function requires the timecol is a time attribute type, but is TIMESTAMP(3).")));
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testConflictingFieldNames() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE VIEW v1 AS\n                               |SELECT *, rowtime AS window_start\n                               |FROM MyTable\n                               |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | TUMBLE(TABLE v1, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.thrown().expectMessage("Column 'window_start' is ambiguous");
        this.thrown().expect(ValidationException.class);
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTumbleTVFWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(\n        |   TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE, INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTumbleTVFWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(\n        |   TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE, INTERVAL '-5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  HOP(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  HOP(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '-5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVFWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  CUMULATE(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVFWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  CUMULATE(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '-5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    public WindowTableFunctionTest() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |CREATE TABLE MyTable (\n                              |  a INT,\n                              |  b BIGINT,\n                              |  c STRING,\n                              |  d DECIMAL(10, 3),\n                              |  rowtime TIMESTAMP(3),\n                              |  proctime as PROCTIME(),\n                              |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                              |) with (\n                              |  'connector' = 'values'\n                              |)\n                              |")).stripMargin());
    }
}

