/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.TwoStageAggregateTest$;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001+\t)Bk^8Ti\u0006<W-Q4he\u0016<\u0017\r^3UKN$(BA\u0002\u0005\u0003\r\twm\u001a\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u0013)\tA\u0001\u001d7b]*\u00111\u0002D\u0001\ba2\fgN\\3s\u0015\tia\"A\u0003uC\ndWM\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0005eQ\u0011!B;uS2\u001c\u0018BA\u000e\u0019\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\bE\u0001\u0011\r\u0011\"\u0003$\u0003\u0011)H/\u001b7\u0016\u0003\u0011\u0002\"aF\u0013\n\u0005\u0019B\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0015\u0001A\u0003%A%A\u0003vi&d\u0007\u0005C\u0003+\u0001\u0011\u00051&\u0001\u0004cK\u001a|'/\u001a\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t!QK\\5uQ\tI3\u0007\u0005\u00025o5\tQG\u0003\u00027%\u0005)!.\u001e8ji&\u0011\u0001(\u000e\u0002\u0007\u0005\u00164wN]3\t\u000bi\u0002A\u0011A\u0016\u0002)Q,7\u000f^\"pk:$x+\u001b;i\u000fJ|W\u000f\u001d\"zQ\tID\b\u0005\u00025{%\u0011a(\u000e\u0002\u0005)\u0016\u001cH\u000fC\u0003A\u0001\u0011\u00051&A\fuKN$8i\\;oi^KG\u000f[8vi\u001e\u0013x.\u001e9Cs\"\u0012q\b\u0010\u0005\u0006\u0007\u0002!\taK\u0001\u0013i\u0016\u001cH/\u0011<h/&$\bn\u0012:pkB\u0014\u0015\u0010\u000b\u0002Cy!)a\t\u0001C\u0001W\u0005)B/Z:u\u0003Z<w+\u001b;i_V$xI]8va\nK\bFA#=\u0011\u0015I\u0005\u0001\"\u0001,\u0003q!Xm\u001d;He>,\b/Q4he\u0016<\u0017\r^3XSRDg)\u001b7uKJD#\u0001\u0013\u001f\t\u000b1\u0003A\u0011A\u0016\u0002QQ,7\u000f^$s_V\u0004\u0018iZ4sK\u001e\fG/Z,ji\",\u0005\u0010\u001d:fgNLwN\\%o'\u0016dWm\u0019;)\u0005-c\u0004\"B(\u0001\t\u0003Y\u0013A\b;fgR<%o\\;q\u0003\u001e<'/Z4bi\u0016<\u0016\u000e\u001e5D_:\u001cH/\u00198uQ\tqE\b")
public class TwoStageAggregateTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        this.util().enableMiniBatch();
        this.util().tableEnv().getConfig().setIdleStateRetentionTime(Time.hours((long)1L), Time.hours((long)2L));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)AggregatePhaseStrategy.TWO_PHASE.toString());
    }

    @Test
    public void testCountWithGroupBy() {
        this.util().verifyExecPlan("SELECT COUNT(a) FROM MyTable GROUP BY b");
    }

    @Test
    public void testCountWithoutGroupBy() {
        this.util().verifyExecPlan("SELECT COUNT(a) FROM MyTable");
    }

    @Test
    public void testAvgWithGroupBy() {
        this.util().verifyExecPlan("SELECT AVG(a) FROM MyTable GROUP BY b");
    }

    @Test
    public void testAvgWithoutGroupBy() {
        this.util().verifyRelPlanWithType("SELECT AVG(CAST(a AS DOUBLE)) FROM MyTable");
    }

    @Test
    public void testGroupAggregateWithFilter() {
        this.util().verifyExecPlan("SELECT * FROM (SELECT b, SUM(a) FROM MyTable GROUP BY b) WHERE b = 2");
    }

    @Test
    public void testGroupAggregateWithExpressionInSelect() {
        this.util().verifyExecPlan("SELECT MIN(c), AVG(a) FROM (SELECT a, b + 3 AS d, c FROM MyTable) GROUP BY d");
    }

    @Test
    public void testGroupAggregateWithConstant() {
        this.util().verifyExecPlan("SELECT four, SUM(a) FROM (SELECT b, 4 AS four, a FROM MyTable) GROUP BY b, four");
    }

    public TwoStageAggregateTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.TwoStageAggregateTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

