/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0001U\u0011\u0001BS8j]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0019\u0019HO]3b[*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0006\u0002\u000bU$\u0018\u000e\\:\n\u0005mA\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0005!9!\u0005\u0001b\u0001\n\u0013\u0019\u0013\u0001B;uS2,\u0012\u0001\n\t\u0003/\u0015J!A\n\r\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r!\u0002\u0001\u0015!\u0003%\u0003\u0015)H/\u001b7!\u0011\u0015Q\u0003\u0001\"\u0001,\u0003%\"Xm\u001d;EKB,g\u000eZ3oi\u000e{g\u000eZ5uS>tG)\u001a:jm\u0006$\u0018n\u001c8J]:,'OS8j]R\tA\u0006\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0003V]&$\bFA\u00154!\t!t'D\u00016\u0015\t1$#A\u0003kk:LG/\u0003\u00029k\t!A+Z:u\u0011\u0015Q\u0004\u0001\"\u0001,\u0003E\"Xm\u001d;EKB,g\u000eZ3oi\u000e{g\u000eZ5uS>tG)\u001a:jm\u0006$\u0018n\u001c8J]:,'OS8j]^KG\u000f\u001b+sk\u0016D#!O\u001a\t\u000bu\u0002A\u0011A\u0016\u0002cQ,7\u000f\u001e#fa\u0016tG-\u001a8u\u0007>tG-\u001b;j_:$UM]5wCRLwN\\%o]\u0016\u0014(j\\5o/&$\bNT;mY\"\u0012Ah\r\u0005\u0006\u0001\u0002!\taK\u0001\u000ei\u0016\u001cH/\u00138oKJTu.\u001b8)\u0005}\u001a\u0004\"B\"\u0001\t\u0003Y\u0013\u0001\u0007;fgRLeN\\3s\u0015>LgnV5uQ\u0016\u000bX/\u00197QW\"\u0012!i\r\u0005\u0006\r\u0002!\taK\u0001\u0014i\u0016\u001cH/\u00138oKJTu.\u001b8XSRD\u0007k\u001b\u0015\u0003\u000bNBQ!\u0013\u0001\u0005\u0002-\n1\u0003^3ti2+g\r\u001e&pS:tuN\\#rk&D#\u0001S\u001a\t\u000b1\u0003A\u0011A\u0016\u0002=Q,7\u000f\u001e'fMRTu.\u001b8XSRDW)];bYB[gj\u001c8FcVL\u0007FA&4\u0011\u0015y\u0005\u0001\"\u0001,\u0003\u0005\"Xm\u001d;MK\u001a$(j\\5o/&$\bNU5hQRtu\u000e\u001e)l\u001d>tW)];jQ\tq5\u0007C\u0003S\u0001\u0011\u00051&A\ruKN$H*\u001a4u\u0015>LgnV5uQB[gj\u001c8FcVL\u0007FA)4\u0011\u0015)\u0006\u0001\"\u0001,\u00031!Xm\u001d;MK\u001a$(j\\5oQ\t!6\u0007C\u0003Y\u0001\u0011\u00051&A\fuKN$H*\u001a4u\u0015>LgnV5uQ\u0016\u000bX/\u00197QW\"\u0012qk\r\u0005\u00067\u0002!\taK\u0001\u001bi\u0016\u001cH\u000fT3gi*{\u0017N\\,ji\"\u0014\u0016n\u001a5u\u001d>$\bk\u001b\u0015\u00035NBQA\u0018\u0001\u0005\u0002-\n!\u0003^3ti2+g\r\u001e&pS:<\u0016\u000e\u001e5QW\"\u0012Ql\r\u0005\u0006C\u0002!\taK\u0001\u0015i\u0016\u001cHOU5hQRTu.\u001b8O_:,\u0015/^5)\u0005\u0001\u001c\u0004\"\u00023\u0001\t\u0003Y\u0013a\b;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQ\u0016\u000bX/\u00197QW:{g.R9vS\"\u00121m\r\u0005\u0006O\u0002!\taK\u0001#i\u0016\u001cHOU5hQRTu.\u001b8XSRD'+[4ii:{G\u000fU6O_:,\u0015/^5)\u0005\u0019\u001c\u0004\"\u00026\u0001\t\u0003Y\u0013A\u0007;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQB[gj\u001c8FcVL\u0007FA54\u0011\u0015i\u0007\u0001\"\u0001,\u00035!Xm\u001d;SS\u001eDGOS8j]\"\u0012An\r\u0005\u0006a\u0002!\taK\u0001\u0019i\u0016\u001cHOU5hQRTu.\u001b8XSRDW)];bYB[\u0007FA84\u0011\u0015\u0019\b\u0001\"\u0001,\u0003m!Xm\u001d;SS\u001eDGOS8j]^KG\u000f\u001b*jO\"$hj\u001c;QW\"\u0012!o\r\u0005\u0006m\u0002!\taK\u0001\u0014i\u0016\u001cHOU5hQRTu.\u001b8XSRD\u0007k\u001b\u0015\u0003kNBQ!\u001f\u0001\u0005\u0002-\n1\u0003^3ti\u001a+H\u000e\u001c&pS:tuN\\#rk&D#\u0001_\u001a\t\u000bq\u0004A\u0011A\u0016\u0002=Q,7\u000f\u001e$vY2Tu.\u001b8XSRDW)];bYB[gj\u001c8FcVL\u0007FA>4\u0011\u0015y\b\u0001\"\u0001,\u0003\u0001\"Xm\u001d;Gk2d'j\\5o/&$\bNR;mY:{G\u000fU6O_:,\u0015/^5)\u0005y\u001c\u0004BBA\u0003\u0001\u0011\u00051&A\ruKN$h)\u001e7m\u0015>LgnV5uQB[gj\u001c8FcVL\u0007fAA\u0002g!1\u00111\u0002\u0001\u0005\u0002-\nA\u0002^3ti\u001a+H\u000e\u001c&pS:D3!!\u00034\u0011\u0019\t\t\u0002\u0001C\u0001W\u00059B/Z:u\rVdGNS8j]^KG\u000f[#rk\u0006d\u0007k\u001b\u0015\u0004\u0003\u001f\u0019\u0004BBA\f\u0001\u0011\u00051&A\ruKN$h)\u001e7m\u0015>LgnV5uQ\u001a+H\u000e\u001c(piB[\u0007fAA\u000bg!1\u0011Q\u0004\u0001\u0005\u0002-\n!\u0003^3ti\u001a+H\u000e\u001c&pS:<\u0016\u000e\u001e5QW\"\u001a\u00111D\u001a\t\r\u0005\r\u0002\u0001\"\u0001,\u0003A!Xm\u001d;TK24'j\\5o!2\fg\u000eK\u0002\u0002\"MBa!!\u000b\u0001\t\u0003Y\u0013\u0001\u0005;fgRTu.\u001b8XSRD7k\u001c:uQ\r\t9c\r\u0005\u0007\u0003_\u0001A\u0011A\u0016\u00023Q,7\u000f\u001e'fMR|U\u000f^3s\u0015>Lg.R9vSB\u0013X\r\u001a\u0015\u0004\u0003[\u0019\u0004BBA\u001b\u0001\u0011\u00051&A\u0011uKN$H*\u001a4u\u001fV$XM\u001d&pS:,\u0015/^5B]\u0012dunY1m!J,G\rK\u0002\u00024MBa!a\u000f\u0001\t\u0003Y\u0013a\t;fgRdUM\u001a;PkR,'OS8j]\u0016\u000bX/[!oI:{g.R9vSB\u0013X\r\u001a\u0015\u0004\u0003s\u0019\u0004BBA!\u0001\u0011\u00051&\u0001\u000euKN$(+[4ii>+H/\u001a:K_&tW)];j!J,G\rK\u0002\u0002@MBa!a\u0012\u0001\t\u0003Y\u0013A\t;fgR\u0014\u0016n\u001a5u\u001fV$XM\u001d&pS:,\u0015/^5B]\u0012dunY1m!J,G\rK\u0002\u0002FMBa!!\u0014\u0001\t\u0003Y\u0013\u0001\n;fgR\u0014\u0016n\u001a5u\u001fV$XM\u001d&pS:,\u0015/^5B]\u0012tuN\\#rk&\u0004&/\u001a3)\u0007\u0005-3\u0007\u0003\u0004\u0002T\u0001!\taK\u0001.i\u0016\u001cHOS8j]\u0006sGmU3mK\u000e$xJ\u001c)beRL\u0017\r\\\"p[B|7/\u001b;f!JLW.\u0019:z\u0017\u0016L\bfAA)g!1\u0011\u0011\f\u0001\u0005\u0002-\n\u0011\u0004^3ti*{\u0017N\u001c#jg>\u0014H-\u001a:DQ\u0006tw-\u001a'pO\"\u001a\u0011qK\u001a\t\r\u0005}\u0003\u0001\"\u0001,\u0003\u0015\"Xm\u001d;K_&tw*\u001e;qkR,\u0006o]3si.+\u0017PT8u\u001b\u0006$8\r[*j].\u00046\u000eK\u0002\u0002^MBa!!\u001a\u0001\t\u0003Y\u0013a\b;fgRTu.\u001b8PkR\u0004X\u000f^+qg\u0016\u0014HoS3z\u0013:\u001c\u0016N\\6QW\"\u001a\u00111M\u001a\t\r\u0005-\u0004\u0001\"\u0001,\u0003\u0015\"Xm\u001d;K_&tw*\u001e;qkRdun\u001d;VaN,'\u000f^&fs^KG\u000f[*j].\u00046\u000eK\u0002\u0002jMBa!!\u001d\u0001\t\u0003Y\u0013a\b;fgRLeN\\3s\u0015>LgnV5uQ\u001aKG\u000e^3s!V\u001c\b\u000eR8x]\"\u001a\u0011qN\u001a\t\r\u0005]\u0004\u0001\"\u0001,\u0003\u0019\"Xm\u001d;J]:,'OS8j]^KG\u000f\u001b&pS:\u001cuN\u001c3ji&|g\u000eU;tQ\u0012{wO\u001c\u0015\u0004\u0003k\u001a\u0004BBA?\u0001\u0011\u00051&\u0001\u0010uKN$H*\u001a4u\u0015>LgnV5uQ\u001aKG\u000e^3s!V\u001c\b\u000eR8x]\"\u001a\u00111P\u001a\t\r\u0005\r\u0005\u0001\"\u0001,\u0003\u0015\"Xm\u001d;MK\u001a$(j\\5o/&$\bNS8j]\u000e{g\u000eZ5uS>t\u0007+^:i\t><h\u000eK\u0002\u0002\u0002NBa!!#\u0001\t\u0003Y\u0013a\b;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQ\u001aKG\u000e^3s!V\u001c\b\u000eR8x]\"\u001a\u0011qQ\u001a\t\r\u0005=\u0005\u0001\"\u0001,\u0003\u0019\"Xm\u001d;SS\u001eDGOS8j]^KG\u000f\u001b&pS:\u001cuN\u001c3ji&|g\u000eU;tQ\u0012{wO\u001c\u0015\u0004\u0003\u001b\u001b\u0004")
public class JoinTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testDependentConditionDerivationInnerJoin() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON (a1 = 1 AND b1 = 1) OR (a2 = 2 AND b2 = 2)");
    }

    @Test
    public void testDependentConditionDerivationInnerJoinWithTrue() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON (a1 = 1 AND b1 = 1) OR (a2 = 2 AND true)");
    }

    @Test
    public void testDependentConditionDerivationInnerJoinWithNull() {
        this.util().verifyExecPlan("SELECT * FROM t JOIN s ON (a = 1 AND x = 1) OR (a = 2 AND y is null)");
    }

    @Test
    public void testInnerJoin() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON a1 = b1");
    }

    @Test
    public void testInnerJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(40).append("SELECT a1, b1 FROM (").append(query1).append(") JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInnerJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(48).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A LEFT JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(57).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithRightNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(56).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN B ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(65).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a2 = b2 AND a1 > b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoin() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A LEFT JOIN B ON a1 = b1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(45).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithRightNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(44).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN B ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(53).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A RIGHT JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(58).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithRightNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(57).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN B ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(66).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a2 = b2 AND a1 > b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoin() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A RIGHT JOIN B ON a1 = b1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(46).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithRightNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A group by a1";
        String query = new StringBuilder(45).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN B ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B group by b1";
        String query = new StringBuilder(54).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A FULL JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(57).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithFullNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(56).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN B ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(65).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a2 = b2 AND a1 > b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoin() {
        String query = "SELECT a1, b1 FROM A FULL JOIN B ON a1 = b1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(45).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithFullNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(44).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN B ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(53).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSelfJoinPlan() {
        this.util().addTableSource("src", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "key")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v"))}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$12 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM (\n         |  SELECT * FROM src WHERE key = 0) src1\n         |LEFT OUTER JOIN (\n         |  SELECT * FROM src WHERE key = 0) src2\n         |ON (src1.key = src2.key AND src2.key > 10)\n       ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinWithSort() {
        this.util().addTableSource("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$13 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable4", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  MyTable3 FULL JOIN\n        |  (SELECT * FROM MyTable4 ORDER BY MyTable4.i DESC, MyTable4.k ASC) MyTable4\n        |  ON MyTable3.i = MyTable4.i and MyTable3.i = MyTable4.k\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testLeftOuterJoinEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z");
    }

    @Test
    public void testLeftOuterJoinEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z AND b < 2");
    }

    @Test
    public void testLeftOuterJoinEquiAndNonEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z AND b < x");
    }

    @Test
    public void testRightOuterJoinEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t RIGHT OUTER JOIN s ON a = z");
    }

    @Test
    public void testRightOuterJoinEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT b, x FROM t RIGHT OUTER JOIN s ON a = z AND x < 2");
    }

    @Test
    public void testRightOuterJoinEquiAndNonEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t RIGHT OUTER JOIN s ON a = z AND b < x");
    }

    @Test
    public void testJoinAndSelectOnPartialCompositePrimaryKey() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE tableWithCompositePk (\n                               |  pk1 INT,\n                               |  pk2 BIGINT,\n                               |  PRIMARY KEY (pk1, pk2) NOT ENFORCED\n                               |) WITH (\n                               |  'connector'='values'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT A.a1 FROM A LEFT JOIN tableWithCompositePk T ON A.a1 = T.pk1");
    }

    @Test
    public void testJoinDisorderChangeLog() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (person String, votes BIGINT) WITH(\n                               |  'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE award (votes BIGINT, prize DOUBLE, PRIMARY KEY(votes) NOT ENFORCED) WITH(\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE people (person STRING, age INT, PRIMARY KEY(person) NOT ENFORCED) WITH(\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT T1.person, T1.sum_votes, T1.prize, T2.age FROM\n                          | (SELECT T.person, T.sum_votes, award.prize FROM\n                          |   (SELECT person, SUM(votes) AS sum_votes FROM src GROUP BY person) T,\n                          |   award\n                          |   WHERE T.sum_votes = award.votes) T1, people T2\n                          | WHERE T1.person = T2.person\n                          |")).stripMargin());
    }

    @Test
    public void testJoinOutputUpsertKeyNotMatchSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_city (\n                               | id varchar,\n                               | city_name varchar,\n                               | primary key (id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_customer (\n                               | customer_id varchar,\n                               | city_id varchar,\n                               | age int,\n                               | gender varchar,\n                               | update_time timestamp(3),\n                               | primary key (customer_id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | city_id varchar,\n                               | city_name varchar,\n                               | customer_cnt bigint,\n                               | primary key (city_name) not enforced\n                               |) with (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select t1.city_id, t2.city_name, t1.customer_cnt\n        | from (select city_id, count(*) customer_cnt from source_customer group by city_id) t1\n        | join source_city t2 on t1.city_id = t2.id\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinOutputUpsertKeyInSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_city (\n                               | id varchar,\n                               | city_name varchar,\n                               | primary key (id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_customer (\n                               | customer_id varchar,\n                               | city_id varchar,\n                               | age int,\n                               | gender varchar,\n                               | update_time timestamp(3),\n                               | primary key (customer_id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | city_id varchar,\n                               | city_name varchar,\n                               | customer_cnt bigint,\n                               | primary key (city_id, city_name) not enforced\n                               |) with (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select t1.city_id, t2.city_name, t1.customer_cnt\n        | from (select city_id, count(*) customer_cnt from source_customer group by city_id) t1\n        | join source_city t2 on t1.city_id = t2.id\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinOutputLostUpsertKeyWithSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_city (\n                               | id varchar,\n                               | city_name varchar,\n                               | primary key (id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_customer (\n                               | customer_id varchar,\n                               | city_id varchar,\n                               | age int,\n                               | gender varchar,\n                               | update_time timestamp(3),\n                               | primary key (customer_id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | city_name varchar,\n                               | customer_cnt bigint,\n                               | primary key (city_name) not enforced\n                               |) with (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select t2.city_name, t1.customer_cnt\n        | from (select city_id, count(*) customer_cnt from source_customer group by city_id) t1\n        | join source_city t2 on t1.city_id = t2.id\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInnerJoinWithFilterPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |   (select a1, count(a2) as a2 from A group by a1)\n                          |   join\n                          |   (select b1, count(b2) as b2 from B group by b1)\n                          |   on true where a1 = b1 and a2 = b2 and b1 = 2\n                          |")).stripMargin());
    }

    @Test
    public void testInnerJoinWithJoinConditionPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |  (select a1, count(a2) as a2 from A group by a1)\n                          |   join\n                          |  (select b1, count(b2) as b2 from B group by b1)\n                          |   on true where a1 = b1 and a2 = b2 and b1 = 2 and a2 = 1\n                          |")).stripMargin());
    }

    @Test
    public void testLeftJoinWithFilterPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |  (select a1, count(a2) as a2 from A group by a1)\n                          |   left join\n                          |  (select b1, count(b2) as b2 from B group by b1)\n                          |   on true where a1 = b1 and b2 = a2 and a1 = 2\n                          |")).stripMargin());
    }

    @Test
    public void testLeftJoinWithJoinConditionPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |  (select a1, count(a2) as a2 from A group by a1)\n                          |   left join\n                          |  (select b1, count(b2) as b2 from B group by b1)\n                          |   on a1 = b1 and a2 = b2 and a1 = 2 and b2 = 1\n                          |")).stripMargin());
    }

    @Test
    public void testRightJoinWithFilterPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |  (select a1, count(a2) as a2 from A group by a1)\n                          |   right join\n                          |  (select b1, count(b2) as b2 from B group by b1)\n                          |   on true where a1 = b1 and a2 = b2 and b1 = 2\n                          |")).stripMargin());
    }

    @Test
    public void testRightJoinWithJoinConditionPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          | (select a1, count(a2) as a2 from A group by a1)\n                          |   right join\n                          | (select b1, count(b2) as b2 from B group by b1)\n                          |   on a1 = b1 and a2 = b2 and b1 = 2 and a2 = 1\n                          |")).stripMargin());
    }

    public JoinTest() {
        this.util().addTableSource("A", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a3"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("B", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b3"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$9 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$10 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("s", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "x")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "y")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "z"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$11 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

