/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.table;

import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.utils.JavaStreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.junit.Test;

public class ValuesTest
extends TableTestBase {
    @Test
    public void testValuesAllEqualTypes() {
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        Table t = util.getTableEnv().fromValues(new Expression[]{Expressions.row((Object)1, (Object[])new Object[]{2L, "JKL"}), Expressions.row((Object)2, (Object[])new Object[]{3L, "GHI"}), Expressions.row((Object)3, (Object[])new Object[]{4L, "DEF"}), Expressions.row((Object)4, (Object[])new Object[]{5L, "ABC"})});
        util.verifyExecPlan(t);
    }

    @Test
    public void testValuesFromLiterals() {
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        Table t = util.getTableEnv().fromValues(new Object[]{1, Float.valueOf(3.1f), 99L, null});
        util.verifyExecPlan(t);
    }

    @Test
    public void testValuesFromRowExpression() {
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        Table t = util.getTableEnv().fromValues(new Expression[]{Expressions.row((Object)Expressions.lit((Object)1).plus((Object)3), (Object[])new Object[]{"ABC", Expressions.map((Object)"a", (Object)3.0, (Object[])new Object[0])}), Expressions.row((Object)((ApiExpression)Expressions.lit((Object)-1).abs()).plus((Object)2), (Object[])new Object[]{"ABC", Expressions.map((Object)"a", (Object)((ApiExpression)Expressions.lit((Object)-5).abs()).plus((Object)-5), (Object[])new Object[0])}), Expressions.row((Object)Expressions.pi(), (Object[])new Object[]{"ABC", Expressions.map((Object)"abc", (Object)Float.valueOf(3.0f), (Object[])new Object[0])}), Expressions.row((Object)Float.valueOf(3.1f), (Object[])new Object[]{"DEF", Expressions.map((Object)"abcd", (Object)3L, (Object[])new Object[0])}), Expressions.row((Object)99L, (Object[])new Object[]{"DEFG", Expressions.map((Object)"a", (Object)1, (Object[])new Object[0])}), Expressions.row((Object)0.0, (Object[])new Object[]{"D", Expressions.lit(null, (DataType)DataTypes.MAP((DataType)DataTypes.CHAR((int)1), (DataType)DataTypes.INT()))})});
        util.verifyExecPlan(t);
    }

    @Test
    public void testValuesFromRowObject() {
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        Table t = util.getTableEnv().fromValues(new Object[]{Row.of((Object[])new Object[]{1, "ABC", null}), Row.of((Object[])new Object[]{Math.PI, "ABC", 1}), Row.of((Object[])new Object[]{Float.valueOf(3.1f), "DEF", 2}), Row.of((Object[])new Object[]{99L, "DEFG", 3}), Row.of((Object[])new Object[]{0.0, "D", 4})});
        util.verifyExecPlan(t);
    }

    @Test
    public void testValuesFromMixedObjectsAndExpressions() {
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        Table t = util.getTableEnv().fromValues(new Object[]{Expressions.row((Object)1, (Object[])new Object[]{"ABC", null}), Row.of((Object[])new Object[]{Math.PI, "ABC", 1}), Row.of((Object[])new Object[]{Float.valueOf(3.1f), "DEF", 2}), Expressions.row((Object)99L, (Object[])new Object[]{"DEFG", Expressions.nullOf((DataType)DataTypes.INT())}), Row.of((Object[])new Object[]{0.0, "D", 4})});
        util.verifyExecPlan(t);
    }

    @Test
    public void testValuesFromRowObjectInCollection() {
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        List<Object> data = Arrays.asList(Expressions.row((Object)1, (Object[])new Object[]{Expressions.lit((Object)"ABC")}), Expressions.row((Object)Math.PI, (Object[])new Object[]{"ABC"}), Expressions.row((Object)Float.valueOf(3.1f), (Object[])new Object[]{"DEF"}), Expressions.row((Object)99L, (Object[])new Object[]{Expressions.lit((Object)"DEFG")}), Expressions.row((Object)0.0, (Object[])new Object[]{"D"}));
        DataType rowType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)((DataType)DataTypes.DECIMAL((int)10, (int)2).notNull())), DataTypes.FIELD((String)"b", (DataType)((DataType)DataTypes.CHAR((int)4).notNull()))});
        Table t = util.getTableEnv().fromValues((AbstractDataType)rowType, data);
        util.verifyExecPlan(t);
    }

    @Test
    public void testValuesFromNestedRowObject() {
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        Table t = util.getTableEnv().fromValues(new Object[]{Row.of((Object[])new Object[]{1, Row.of((Object[])new Object[]{"A", 2}), Collections.singletonList(1)}), Row.of((Object[])new Object[]{Math.PI, Row.of((Object[])new Object[]{"ABC", 3.0}), Collections.singletonList(3L)})});
        util.verifyExecPlan(t);
    }

    @Test
    public void testValuesOverrideSchema() {
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        Table t = util.getTableEnv().fromValues((AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.STRING())}), new Expression[]{Expressions.row((Object)Expressions.lit((Object)1).plus((Object)2), (Object[])new Object[]{"ABC"}), Expressions.row((Object)2, (Object[])new Object[]{"ABC"})});
        util.verifyExecPlan(t);
    }

    @Test
    public void testValuesOverrideNullability() {
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        Table t = util.getTableEnv().fromValues((AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)((DataType)DataTypes.BIGINT().notNull())), DataTypes.FIELD((String)"b", (DataType)((DataType)DataTypes.VARCHAR((int)4).notNull())), DataTypes.FIELD((String)"c", (DataType)((DataType)DataTypes.BINARY((int)4).notNull()))}), new Expression[]{Expressions.row((Object)Expressions.lit((Object)1).plus((Object)2), (Object[])new Object[]{"ABC", new byte[]{1, 2, 3}})});
        util.verifyExecPlan(t);
    }

    @Test
    public void testValuesWithComplexNesting() {
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        Table t = util.getTableEnv().fromValues((AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"number", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"row", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"string", (DataType)DataTypes.CHAR((int)5)), DataTypes.FIELD((String)"decimal", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"nestedRow", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"time", (DataType)DataTypes.TIME((int)4))}))})), DataTypes.FIELD((String)"array", (DataType)DataTypes.ARRAY((DataType)DataTypes.BIGINT()))}), new Object[]{Row.of((Object[])new Object[]{1, Row.of((Object[])new Object[]{"A", 2, Row.of((Object[])new Object[]{LocalTime.of(0, 0, 0)})}), Collections.singletonList(1)}), Row.of((Object[])new Object[]{Math.PI, Row.of((Object[])new Object[]{"ABC", 3.0, Row.of((Object[])new Object[]{100})}), Collections.singletonList(3L)})});
        util.verifyExecPlan(t);
    }

    @Test
    public void testNoCommonType() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Types in fromValues(...) must have a common super type. Could not find a common type for all rows at column 1.");
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        util.getTableEnv().fromValues(new Expression[]{Expressions.row((Object)"ABC", (Object[])new Object[]{1L}), Expressions.row((Object)"ABC", (Object[])new Object[]{Expressions.lit((Object)LocalTime.of(0, 0, 0))}), Expressions.row((Object)"ABC", (Object[])new Object[]{2})});
    }

    @Test
    public void testCannotCast() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Could not cast the value of the 0 column: [ 4 ] of a row: [ 4 ] to the requested type: BINARY(3)");
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        util.getTableEnv().fromValues((AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1", (DataType)DataTypes.BINARY((int)3))}), new Expression[]{Expressions.row((Object)4, (Object[])new Object[0])});
    }

    @Test
    public void testWrongRowTypeLength() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("All rows in a fromValues(...) clause must have the same fields number. Row [4] has a different length than the expected size: 2.");
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        util.getTableEnv().fromValues((AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1", (DataType)DataTypes.BINARY((int)3)), DataTypes.FIELD((String)"f2", (DataType)DataTypes.STRING())}), new Expression[]{Expressions.row((Object)4, (Object[])new Object[0])});
    }
}

