/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.types.Row;
import org.apache.flink.util.UserClassLoaderJarTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class FunctionITCase
extends BatchTestBase {
    private static final Random random = new Random();
    private String udfClassName;
    private String jarPath;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.udfClassName = "LowerUDF" + random.nextInt(50);
        this.jarPath = UserClassLoaderJarTestUtils.createJarFile((File)TEMPORARY_FOLDER.newFolder(String.format("test-jar-%s", UUID.randomUUID())), (String)"test-classloader-udf.jar", (String)this.udfClassName, (String)String.format("public class %s extends org.apache.flink.table.functions.ScalarFunction {\n  public String eval(String str) {\n    return str.toLowerCase();\n  }\n}\n", this.udfClassName)).toURI().toString();
    }

    @Test
    public void testCreateTemporarySystemFunctionByUsingJar() {
        String ddl1 = String.format("CREATE TEMPORARY SYSTEM FUNCTION f10 AS '%s' USING JAR '%s'", this.udfClassName, this.jarPath);
        String ddl2 = String.format("CREATE TEMPORARY SYSTEM FUNCTION f11 AS '%s' USING JAR '%s'", this.udfClassName, this.jarPath);
        this.tEnv().executeSql(ddl1);
        this.tEnv().executeSql(ddl2);
        List<String> functions = Arrays.asList(this.tEnv().listFunctions());
        Assertions.assertThat(functions).contains((Object[])new String[]{"f10"});
        Assertions.assertThat(functions).contains((Object[])new String[]{"f11"});
        this.tEnv().executeSql("DROP TEMPORARY SYSTEM FUNCTION f10");
        this.tEnv().executeSql("DROP TEMPORARY SYSTEM FUNCTION f11");
        functions = Arrays.asList(this.tEnv().listFunctions());
        Assertions.assertThat(functions).doesNotContain((Object[])new String[]{"f10"});
        Assertions.assertThat(functions).doesNotContain((Object[])new String[]{"f11"});
    }

    @Test
    public void testUserDefinedTemporarySystemFunctionByUsingJar() throws Exception {
        String functionDDL = String.format("create temporary system function lowerUdf as '%s' using jar '%s'", this.udfClassName, this.jarPath);
        String dropFunctionDDL = "drop temporary system function lowerUdf";
        this.testUserDefinedFunctionByUsingJar(functionDDL, dropFunctionDDL);
    }

    private void testUserDefinedFunctionByUsingJar(String createFunctionDDL, String dropFunctionDDL) throws Exception {
        List<Row> sourceData = Arrays.asList(Row.of((Object[])new Object[]{1, "JARK"}), Row.of((Object[])new Object[]{2, "RON"}), Row.of((Object[])new Object[]{3, "LeoNard"}), Row.of((Object[])new Object[]{1, "FLINK"}), Row.of((Object[])new Object[]{2, "CDC"}));
        TestCollectionTableFactory.reset();
        TestCollectionTableFactory.initData(sourceData);
        String sourceDDL = "create table t1(a int, b varchar) with ('connector' = 'COLLECTION')";
        String sinkDDL = "create table t2(a int, b varchar) with ('connector' = 'COLLECTION')";
        String query = "select a, lowerUdf(b) from t1";
        this.tEnv().executeSql(sourceDDL);
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(createFunctionDDL);
        Table t2 = this.tEnv().sqlQuery(query);
        t2.executeInsert("t2").await();
        LinkedList<Row> result = TestCollectionTableFactory.RESULT();
        List<Row> expected = Arrays.asList(Row.of((Object[])new Object[]{1, "jark"}), Row.of((Object[])new Object[]{2, "ron"}), Row.of((Object[])new Object[]{3, "leonard"}), Row.of((Object[])new Object[]{1, "flink"}), Row.of((Object[])new Object[]{2, "cdc"}));
        Assertions.assertThat(result).isEqualTo(expected);
        this.tEnv().executeSql("drop table t1");
        this.tEnv().executeSql("drop table t2");
        this.tEnv().executeSql(dropFunctionDDL);
    }
}

