/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.LegacySinkTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.internal.StatementSetImpl;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.expressions.utils.FuncWithOpen;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.runtime.batch.sql.join.GenericTypeInfoWithoutComparator;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.sinks.CollectRowTableSink;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u0001\u0003\u0001U\u0011!BS8j]&#6)Y:f\u0015\t\u0019A!\u0001\u0003k_&t'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQAY1uG\"T!!\u0003\u0006\u0002\u000fI,h\u000e^5nK*\u00111\u0002D\u0001\ba2\fgN\\3s\u0015\tia\"A\u0003uC\ndWM\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011!B;uS2\u001c\u0018BA\u000e\u0019\u00055\u0011\u0015\r^2i)\u0016\u001cHOQ1tK\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\tfqB,7\r^3e\u0015>Lg\u000eV=qKB\u0011qd\u000e\b\u0003AUr!!\t\u001b\u000f\u0005\t\u001adBA\u00123\u001d\t!\u0013G\u0004\u0002&a9\u0011ae\f\b\u0003O9r!\u0001K\u0017\u000f\u0005%bS\"\u0001\u0016\u000b\u0005-\"\u0012A\u0002\u001fs_>$h(C\u0001\u0014\u0013\t\t\"#\u0003\u0002\u0010!%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A!\u0003\u00027\u0005\u0005A!j\\5o)f\u0004X-\u0003\u00029s\tA!j\\5o)f\u0004XM\u0003\u00027\u0005!)1\b\u0001C\u0001y\u00051A(\u001b8jiz\"\"!P \u0011\u0005y\u0002Q\"\u0001\u0002\t\u000buQ\u0004\u0019\u0001\u0010\t\u000b\u0005\u0003A\u0011\t\"\u0002\r\t,gm\u001c:f)\u0005\u0019\u0005C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%\u0001B+oSRD#\u0001\u0011&\u0011\u0005-sU\"\u0001'\u000b\u00055\u0013\u0012!\u00026v]&$\u0018BA(M\u0005\u0019\u0011UMZ8sK\")\u0011\u000b\u0001C\u0001\u0005\u0006AA/Z:u\u0015>Lg\u000e\u000b\u0002Q'B\u00111\nV\u0005\u0003+2\u0013A\u0001V3ti\")q\u000b\u0001C\u0001\u0005\u0006AB/Z:u\u0019>twMS8j]^KG\u000f\u001b\"jOJ\u000bgnZ3)\u0005Y\u001b\u0006\"\u0002.\u0001\t\u0003\u0011\u0015!\u0007;fgRduN\\4ICND'j\\5o\u000f\u0016tWM]1u_JD#!W*\t\u000bu\u0003A\u0011\u0001\"\u00021Q,7\u000f^(oKNKG-Z*nU\u001aKW\r\u001c3FeJ|'\u000f\u000b\u0002]'\")\u0001\r\u0001C\u0001\u0005\u00061B/Z:u\u0015>LgnU1nK\u001aKW\r\u001c3FcV\fG\u000e\u000b\u0002`'\")1\r\u0001C\u0001\u0005\u0006QA/Z:u\u0015>Lgn\u00148)\u0005\t\u001c\u0006\"\u00024\u0001\t\u0003\u0011\u0015!\u0005;fgRTu.\u001b8O_6\u000bGo\u00195fg\"\u0012Qm\u0015\u0005\u0006S\u0002!\tAQ\u0001\u001ei\u0016\u001cHOS8j]:{W*\u0019;dQ\u0016\u001cx+\u001b;i'V\u0014\u0017/^3ss\"\u0012\u0001n\u0015\u0005\u0006Y\u0002!\tAQ\u0001\u0013i\u0016\u001cHOS8j]^KG\u000f\u001b$jYR,'\u000f\u000b\u0002l'\")q\u000e\u0001C\u0001\u0005\u00061B/Z:u\u0015>LgnV5uQ*{\u0017N\u001c$jYR,'\u000f\u000b\u0002o'\")!\u000f\u0001C\u0001\u0005\u00069C/Z:u\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5C_>dW-\u00198GS2$XM]\"p]\u0012LG/[8oQ\t\t8\u000bC\u0003v\u0001\u0011\u0005!)A\u0013uKN$\u0018J\u001c8fe*{\u0017N\\,ji\"tuN\\#rk&Tu.\u001b8Qe\u0016$\u0017nY1uK\"\u0012Ao\u0015\u0005\u0006q\u0002!\tAQ\u0001\u0019i\u0016\u001cHOS8j]^KG\u000f['vYRL\u0007\u000f\\3LKf\u001c\bFA<T\u0011\u0015Y\b\u0001\"\u0001C\u0003E!Xm\u001d;K_&tw+\u001b;i\u00032L\u0017m\u001d\u0015\u0003uNCQA \u0001\u0005\u0002\t\u000bA\u0004^3ti2+g\r\u001e&pS:<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\u0017\u0016L8\u000f\u000b\u0002~'\"1\u00111\u0001\u0001\u0005\u0002\t\u000bq\u0004^3ti2+g\r\u001e&pS:<\u0016\u000e\u001e5O_:,\u0015/^5K_&t\u0007K]3eQ\r\t\ta\u0015\u0005\u0007\u0003\u0013\u0001A\u0011\u0001\"\u0002;Q,7\u000f\u001e'fMRTu.\u001b8XSRDG*\u001a4u\u0019>\u001c\u0017\r\u001c)sK\u0012D3!a\u0002T\u0011\u0019\ty\u0001\u0001C\u0001\u0005\u0006iB/Z:u%&<\u0007\u000e\u001e&pS:<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\u0017\u0016L8\u000fK\u0002\u0002\u000eMCa!!\u0006\u0001\t\u0003\u0011\u0015\u0001\t;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQ:{g.R9vS*{\u0017N\u001c)sK\u0012D3!a\u0005T\u0011\u0019\tY\u0002\u0001C\u0001\u0005\u0006qB/Z:u%&<\u0007\u000e\u001e&pS:<\u0016\u000e\u001e5MK\u001a$Hj\\2bYB\u0013X\r\u001a\u0015\u0004\u00033\u0019\u0006BBA\u0011\u0001\u0011\u0005!)A\u0011uKN$h)\u001e7m\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\u0017\u0016L8\u000fK\u0002\u0002 MCa!a\n\u0001\t\u0003\u0011\u0015a\b;fgR4U\u000f\u001c7K_&tw+\u001b;i\u001d>tW)];j\u0015>Lg\u000e\u0015:fI\"\u001a\u0011QE*\t\r\u00055\u0002\u0001\"\u0001C\u0003u!Xm\u001d;Gk2d'j\\5o/&$\b\u000eT3gi2{7-\u00197Qe\u0016$\u0007fAA\u0016'\"1\u00111\u0007\u0001\u0005\u0002\t\u000b\u0011\u0003^3ti\u001a+H\u000e\\(vi\u0016\u0014(j\\5oQ\r\t\td\u0015\u0005\u0007\u0003s\u0001A\u0011\u0001\"\u0002CQ,7\u000f\u001e$vY2|U\u000f^3s\u0015>LgnV5uQ>,H/R9vC2\u001cuN\u001c3)\u0007\u0005]2\u000b\u0003\u0004\u0002@\u0001!\tAQ\u0001+i\u0016\u001cHoU5oO2,'k\\<Gk2dw*\u001e;fe*{\u0017N\\,ji\"|W\u000f^#rk\u0006d7i\u001c8eQ\r\tid\u0015\u0005\u0007\u0003\u000b\u0002A\u0011\u0001\"\u0002cQ,7\u000f^*j]\u001edWMU8x\rVdGnT;uKJTu.\u001b8XSRDw.\u001e;FcV\fGnQ8oI:{W*\u0019;dQ\"\u001a\u00111I*\t\r\u0005-\u0003\u0001\"\u0001C\u0003E!Xm\u001d;MK\u001a$x*\u001e;fe*{\u0017N\u001c\u0015\u0004\u0003\u0013\u001a\u0006BBA)\u0001\u0011\u0005!)\u0001\nuKN$(+[4ii>+H/\u001a:K_&t\u0007fAA('\"1\u0011q\u000b\u0001\u0005\u0002\t\u000b\u0001\u0004^3ti2+g\r^(vi\u0016\u0014(j\\5o%\u0016|'\u000fZ3sQ\r\t)f\u0015\u0005\u0007\u0003;\u0002A\u0011\u0001\"\u00023Q,7\u000f\u001e*jO\"$x*\u001e;fe*{\u0017N\u001c*f_J$WM\u001d\u0015\u0004\u00037\u001a\u0006bBA2\u0001\u0011\u0005\u0011QM\u0001.i\u0016\u001cHOU5hQR|U\u000f^3s\u0015>LgNU5hQR|U\u000f^3s\u0015>LgnQ1o]>$(+Z8sI\u0016\u0014X#A\")\u0007\u0005\u00054\u000b\u0003\u0004\u0002l\u0001!\tAQ\u0001\u0015i\u0016\u001cH/\u00138oKJTu.\u001b8SK>\u0014H-\u001a:)\u0007\u0005%4\u000b\u0003\u0004\u0002r\u0001!\tAQ\u0001\u0018i\u0016\u001cHOS8j]^KG\u000f[!hOJ,w-\u0019;j_:D3!a\u001cT\u0011\u0019\t9\b\u0001C\u0001\u0005\u0006iB/Z:u\u0015>LgnQ8oI&$\u0018n\u001c8OK\u0016$7+[7qY&4\u0017\u0010K\u0002\u0002vMCa!! \u0001\t\u0003\u0011\u0015A\u000f;fgRTu.\u001b8D_:$\u0017\u000e^5p]\u0012+'/\u001b<fI\u001a\u0013x.\\\"peJ,G.\u0019;fIN+(-U;feftU-\u001a3TS6\u0004H.\u001b4zQ\r\tYh\u0015\u0005\u0007\u0003\u0007\u0003A\u0011\u0001\"\u0002\u0015Q,7\u000f^*j[BdW\rK\u0002\u0002\u0002NCa!!#\u0001\t\u0003\u0011\u0015A\u0003;fgR\u001cV\r\\3di\"\u001a\u0011qQ*\t\r\u0005=\u0005\u0001\"\u0001C\u00039!Xm\u001d;D_J\u0014X\r\\1uK\u0012D3!!$T\u0011\u0019\t)\n\u0001C\u0001\u0005\u0006\u0019B/Z:u\u0007>\u0014(/\u001a7bi\u0016$W\t_5ti\"\u001a\u00111S*\t\r\u0005m\u0005\u0001\"\u0001C\u0003Q!Xm\u001d;D_J\u0014X\r\\1uK\u0012,\u00050[:ue!\u001a\u0011\u0011T*\t\r\u0005\u0005\u0006\u0001\"\u0001C\u0003Y!Xm\u001d;D_J\u0014X\r\\1uK\u0012tu\u000e^#ySN$\bfAAP'\"1\u0011q\u0015\u0001\u0005\u0002\t\u000ba\u0003^3tiVs7m\u001c:sK2\fG/\u001a3TG\u0006d\u0017M\u001d\u0015\u0004\u0003K\u001b\u0006BBAW\u0001\u0011\u0005!)\u0001\fuKN$X)];bY^KG\u000f[!hON\u001b\u0017\r\\1sQ\r\tYk\u0015\u0005\u0007\u0003g\u0003A\u0011\u0001\"\u0002+Q,7\u000f^\"p[B\f'/[:p]N\u001c6-\u00197be\"\u001a\u0011\u0011W*\t\r\u0005e\u0006\u0001\"\u0001C\u0003A!Xm\u001d;K_&tw+\u001b;i\u001dVdG\u000eK\u0002\u00028NCa!a0\u0001\t\u0003\u0011\u0015!\u0005;fgR\u001c\u0016N\\4mKJ{wOS8j]\"\u001a\u0011QX*\t\r\u0005\u0015\u0007\u0001\"\u0001C\u0003}!Xm\u001d;O_:,U\u000e\u001d;z)\u0006\u0014G.\u001a&pS:,U\u000e\u001d;z)\u0006\u0014G.\u001a\u0015\u0004\u0003\u0007\u001c\u0006BBAf\u0001\u0011\u0005!)\u0001\u000fuKN$X)\u001c9usR\u000b'\r\\3K_&tW)\u001c9usR\u000b'\r\\3)\u0007\u0005%7\u000b\u0003\u0004\u0002R\u0002!\tAQ\u0001\u0012i\u0016\u001cHOS8j]\u000e{G\u000e\\1uS>t\u0007fAAh'\"1\u0011q\u001b\u0001\u0005\u0002\t\u000bQ\u0003^3ti*{\u0017N\\,ji\",FI\u0012$jYR,'\u000fK\u0002\u0002VNCa!!8\u0001\t\u0003\u0011\u0015A\u0007;fgRTu.\u001b8XSRDg)\u001b7uKJ\u0004Vo\u001d5E_^t\u0007fAAn'\"1\u00111\u001d\u0001\u0005\u0002\t\u000b\u0011\u0005^3ti*{\u0017N\\,ji\"Tu.\u001b8D_:$\u0017\u000e^5p]B+8\u000f\u001b#po:D3!!9TQ\u001d\u0001\u0011\u0011^A{\u0003o\u0004B!a;\u0002r6\u0011\u0011Q\u001e\u0006\u0004\u0003_d\u0015A\u0002:v]:,'/\u0003\u0003\u0002t\u00065(a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003s\u0004B!a?\u0003\u00025\u0011\u0011Q \u0006\u0004\u0003\u007fd\u0015a\u0002:v]:,'o]\u0005\u0005\u0005\u0007\tiPA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0004\b\u0005\u000f\u0011\u0001\u0012\u0001B\u0005\u0003)Qu.\u001b8J)\u000e\u000b7/\u001a\t\u0004}\t-aAB\u0001\u0003\u0011\u0003\u0011ia\u0005\u0003\u0003\f\t=\u0001c\u0001#\u0003\u0012%\u0019!1C#\u0003\r\u0005s\u0017PU3g\u0011\u001dY$1\u0002C\u0001\u0005/!\"A!\u0003\t\u0011\tm!1\u0002C\u0001\u0005;\t!\u0002]1sC6,G/\u001a:t)\t\u0011y\u0002\u0005\u0004\u0003\"\t-\"qF\u0007\u0003\u0005GQAA!\n\u0003(\u0005!Q\u000f^5m\u0015\t\u0011I#\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0017\u0005G\u0011!bQ8mY\u0016\u001cG/[8o!\r!%\u0011G\u0005\u0004\u0005g)%aA!os\"B!\u0011\u0004B\u001c\u0005\u000b\u00129\u0005\u0005\u0003\u0003:\t}b\u0002BA~\u0005wIAA!\u0010\u0002~\u0006i\u0001+\u0019:b[\u0016$XM]5{K\u0012LAA!\u0011\u0003D\tQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\tu\u0012Q`\u0001\u0005]\u0006lW-\t\u0002\u0003J\u0005\u00191\u0010M?")
public class JoinITCase
extends BatchTestBase {
    private final Enumeration.Value expectedJoinType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return JoinITCase$.MODULE$.parameters();
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.registerCollection("SmallTable3", TestData$.MODULE$.smallData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfSmallData3());
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        this.registerCollection("Table5", TestData$.MODULE$.data5(), TestData$.MODULE$.type5(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData5());
        this.registerCollection("NullTable3", TestData$.MODULE$.nullData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfNullData3());
        this.registerCollection("NullTable5", TestData$.MODULE$.nullData5(), TestData$.MODULE$.type5(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfNullData5());
        this.registerCollection("l", (Iterable<Row>)TestData$.MODULE$.data2_1(), (TypeInformation<Row>)TestData$.MODULE$.INT_DOUBLE(), "a, b");
        this.registerCollection("r", (Iterable<Row>)TestData$.MODULE$.data2_2(), (TypeInformation<Row>)TestData$.MODULE$.INT_DOUBLE(), "c, d");
        this.registerCollection("t", TestData$.MODULE$.data2_3(), TestData$.MODULE$.INT_DOUBLE(), "c, d", TestData$.MODULE$.nullablesOfData2_3());
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType);
    }

    @Test
    public void testJoin() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 WHERE b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLongJoinWithBigRange() {
        this.registerCollection("inputT1", (Iterable<Row>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0)}))}))), (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO}), "a, b");
        this.registerCollection("inputT2", (Iterable<Row>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0)}))}))), (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO}), "c, d");
        this.checkResult("SELECT a, b, c, d FROM inputT1, inputT2 WHERE a = c", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLongHashJoinGenerator() {
        block0: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.HashJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            TableSink sink = new CollectRowTableSink().configure((String[])((Object[])new String[]{"c"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING}));
            ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("outputTable", sink);
            StatementSet stmtSet = this.tEnv().createStatementSet();
            Table table = this.tEnv().sqlQuery("SELECT c FROM SmallTable3, Table5 WHERE b = e");
            stmtSet.addInsert("outputTable", table);
            TestingTableEnvironment testingTEnv = (TestingTableEnvironment)this.tEnv();
            StatementSetImpl testingStmtSet = (StatementSetImpl)stmtSet;
            List transforms = ((PlannerBase)testingTEnv.getPlanner()).translate(testingStmtSet.getOperations());
            BooleanRef haveTwoOp = BooleanRef.create((boolean)false);
            ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(transforms).map((Function1 & Serializable & scala.Serializable)t -> this.findTwoInputTransform$1((Transformation)t), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)transform -> {
                JoinITCase.$anonfun$testLongHashJoinGenerator$2(haveTwoOp, transform);
                return BoxedUnit.UNIT;
            });
            Assert.assertTrue((boolean)haveTwoOp.elem);
        }
    }

    @Test
    public void testOneSideSmjFieldError() {
        block0: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.SortMergeJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.registerCollection("PojoSmallTable3", TestData$.MODULE$.smallData3(), new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, new GenericTypeInfoWithoutComparator<String>(String.class)}), "a, b, c", TestData$.MODULE$.nullablesOfSmallData3());
            this.registerCollection("PojoTable5", TestData$.MODULE$.data5(), new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, new GenericTypeInfoWithoutComparator<String>(String.class), BasicTypeInfo.LONG_TYPE_INFO}), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData5());
            this.checkResult("SELECT c, g FROM (SELECT h, g, f, e, d FROM PojoSmallTable3, PojoTable5 WHERE b = e), PojoSmallTable3 WHERE b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testJoinSameFieldEqual() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 WHERE b = e and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinOn() {
        this.checkResult("SELECT c, g FROM SmallTable3 JOIN Table5 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinNoMatches() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 where c = g", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testJoinNoMatchesWithSubquery() {
        this.checkResult("SELECT c, g FROM (SELECT * FROM SmallTable3 WHERE b>2), (SELECT * FROM Table5 WHERE e>2) WHERE b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithFilter() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 WHERE b = e AND b < 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithJoinFilter() {
        this.checkResult("SELECT c, g FROM Table3, Table5 WHERE b = e AND a < 6", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "Hallo Welt wie"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testInnerJoinWithBooleanFilterCondition() {
        Seq data1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi", BoxesRunTime.boxToBoolean((boolean)true)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello", BoxesRunTime.boxToBoolean((boolean)false)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world", BoxesRunTime.boxToBoolean((boolean)true)}))}));
        RowTypeInfo type3 = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.BOOLEAN_TYPE_INFO});
        this.registerCollection("table5", (Iterable<Row>)data1, (TypeInformation<Row>)type3, "a1, b1, c1, d1");
        this.registerCollection("table6", (Iterable<Row>)data1, (TypeInformation<Row>)type3, "a2, b2, c2, d2");
        this.checkResult("SELECT a1, a1, c2 FROM table5 INNER JOIN table6 ON d1 = d2 where d1 is true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1, 1, Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1, 1, Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3, 3, Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3, 3, Hi"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testInnerJoinWithNonEquiJoinPredicate() {
        this.checkResult("SELECT c, g FROM Table3, Table5 WHERE b = e AND a < 6 AND h < b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "Hallo Welt wie"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithMultipleKeys() {
        this.checkResult("SELECT c, g FROM NullTable3, NullTable5 WHERE a = d AND b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithAlias() {
        this.registerCollection("AliasTable5", (Iterable<Row>)TestData$.MODULE$.data5(), (TypeInformation<Row>)TestData$.MODULE$.type5(), "d, e, f, g, c");
        this.checkResult("SELECT AliasTable5.c, T.`1-_./\u00dc` FROM (SELECT a, b, c AS `1-_./\u00dc` FROM Table3) AS T, AliasTable5 WHERE a = d AND a < 4", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3", "Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinWithMultipleKeys() {
        this.checkResult("SELECT c, g FROM NullTable3 LEFT JOIN NullTable5 ON a = d and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinWithNonEquiJoinPred() {
        this.checkResult("SELECT c, g FROM NullTable3 LEFT JOIN NullTable5 ON a = d and b <= h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinWithLeftLocalPred() {
        this.checkResult("SELECT c, g FROM NullTable3 LEFT JOIN NullTable5 ON a = d and b = 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testRightJoinWithMultipleKeys() {
        this.checkResult("SELECT c, g FROM NullTable3 RIGHT JOIN NullTable5 ON a = d and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testRightJoinWithNonEquiJoinPred() {
        this.checkResult("SELECT c, g FROM NullTable5 RIGHT JOIN NullTable3 ON a = d and b <= h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testRightJoinWithLeftLocalPred() {
        this.checkResult("SELECT c, g FROM NullTable5 RIGHT JOIN NullTable3 ON a = d and b = 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testFullOuterJoinWithMultipleKeys() {
        block1: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
            if (!(value == null ? value2 != null : !value.equals(value2))) break block1;
            Enumeration.Value value3 = this.expectedJoinType;
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM NullTable3 FULL JOIN NullTable5 ON a = d and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
            }
        }
    }

    @Test
    public void testFullJoinWithNonEquiJoinPred() {
        block1: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
            if (!(value == null ? value2 != null : !value.equals(value2))) break block1;
            Enumeration.Value value3 = this.expectedJoinType;
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM NullTable3 FULL JOIN NullTable5 ON a = d and b <= h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
            }
        }
    }

    @Test
    public void testFullJoinWithLeftLocalPred() {
        block1: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
            if (!(value == null ? value2 != null : !value.equals(value2))) break block1;
            Enumeration.Value value3 = this.expectedJoinType;
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM NullTable3 FULL JOIN NullTable5 ON a = d and b >= 2 and h = 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
            }
        }
    }

    @Test
    public void testFullOuterJoin() {
        block1: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
            if (!(value == null ? value2 != null : !value.equals(value2))) break block1;
            Enumeration.Value value3 = this.expectedJoinType;
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM SmallTable3 FULL OUTER JOIN Table5 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"}))}))), this.checkResult$default$3());
            }
        }
    }

    @Test
    public void testFullOuterJoinWithoutEqualCond() {
        block0: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT t1.c, t2.c FROM SmallTable3 t1 FULL OUTER JOIN SmallTable3 t2 ON t1.b > t2.b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hello world"}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testSingleRowFullOuterJoinWithoutEqualCond() {
        block0: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT c, mc FROM SmallTable3 t1 FULL OUTER JOIN (SELECT min(b) AS mb, max(c) AS mc FROM SmallTable3) t2 ON b > mb", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testSingleRowFullOuterJoinWithoutEqualCondNoMatch() {
        block0: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT c, mc FROM SmallTable3 t1 FULL OUTER JOIN (SELECT max(b) AS mb, max(c) AS mc FROM SmallTable3) t2 ON b > mb", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hi"}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testLeftOuterJoin() {
        this.checkResult("SELECT c, g FROM Table5 LEFT OUTER JOIN SmallTable3 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testRightOuterJoin() {
        this.checkResult("SELECT c, g FROM SmallTable3 RIGHT OUTER JOIN Table5 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLeftOuterJoinReorder() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.registerCollection("T5", TestData$.MODULE$.data5(), TestData$.MODULE$.type5(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData5(), new FlinkStatistic(new TableStats(1000L), FlinkStatistic$.MODULE$.$lessinit$greater$default$2(), FlinkStatistic$.MODULE$.$lessinit$greater$default$3(), FlinkStatistic$.MODULE$.$lessinit$greater$default$4()));
        this.registerCollection("T3", TestData$.MODULE$.smallData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfSmallData3(), new FlinkStatistic(new TableStats(100L), FlinkStatistic$.MODULE$.$lessinit$greater$default$2(), FlinkStatistic$.MODULE$.$lessinit$greater$default$3(), FlinkStatistic$.MODULE$.$lessinit$greater$default$4()));
        this.registerCollection("T2", TestData$.MODULE$.data2(), TestData$.MODULE$.type2(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData2(), new FlinkStatistic(new TableStats(10L), FlinkStatistic$.MODULE$.$lessinit$greater$default$2(), FlinkStatistic$.MODULE$.$lessinit$greater$default$3(), FlinkStatistic$.MODULE$.$lessinit$greater$default$4()));
        this.registerCollection("T1", TestData$.MODULE$.data2(), TestData$.MODULE$.type2(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData2(), new FlinkStatistic(new TableStats(100000L), FlinkStatistic$.MODULE$.$lessinit$greater$default$2(), FlinkStatistic$.MODULE$.$lessinit$greater$default$3(), FlinkStatistic$.MODULE$.$lessinit$greater$default$4()));
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T5.g, T3b.c, T2b.g FROM T5 LEFT OUTER JOIN \n        |(SELECT * FROM T3 WHERE a > 0 ) T3b ON T3b.b = T5.e LEFT OUTER JOIN \n        |(SELECT * FROM T2 WHERE d > 0) T2b ON T3b.b = T2b.e LEFT OUTER JOIN\n        |(SELECT * FROM T1) T1b ON T3b.b = T1b.e\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo", "Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo Welt", "Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo Welt", "Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo Welt wie gehts?", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo Welt wie", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ABC", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"BCD", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"CDE", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"DEF", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"EFG", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"FGH", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"GHI", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HIJ", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"IJK", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"JKL", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"KLM", null, null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testRightOuterJoinReorder() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.registerCollection("T5", TestData$.MODULE$.data5(), TestData$.MODULE$.type5(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData5(), new FlinkStatistic(new TableStats(1000L), FlinkStatistic$.MODULE$.$lessinit$greater$default$2(), FlinkStatistic$.MODULE$.$lessinit$greater$default$3(), FlinkStatistic$.MODULE$.$lessinit$greater$default$4()));
        this.registerCollection("T3", TestData$.MODULE$.smallData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfSmallData3(), new FlinkStatistic(new TableStats(100L), FlinkStatistic$.MODULE$.$lessinit$greater$default$2(), FlinkStatistic$.MODULE$.$lessinit$greater$default$3(), FlinkStatistic$.MODULE$.$lessinit$greater$default$4()));
        this.registerCollection("T2", TestData$.MODULE$.data2(), TestData$.MODULE$.type2(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData2(), new FlinkStatistic(new TableStats(10L), FlinkStatistic$.MODULE$.$lessinit$greater$default$2(), FlinkStatistic$.MODULE$.$lessinit$greater$default$3(), FlinkStatistic$.MODULE$.$lessinit$greater$default$4()));
        this.registerCollection("T1", TestData$.MODULE$.data2(), TestData$.MODULE$.type2(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData2(), new FlinkStatistic(new TableStats(100000L), FlinkStatistic$.MODULE$.$lessinit$greater$default$2(), FlinkStatistic$.MODULE$.$lessinit$greater$default$3(), FlinkStatistic$.MODULE$.$lessinit$greater$default$4()));
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T5.g, T3b.c, T2b.g FROM T5 RIGHT OUTER JOIN \n        |(SELECT * FROM T3 WHERE T3.a > 0) T3b ON T3b.b = T5.e JOIN\n        |(SELECT * FROM T2 WHERE T2.d > 0) T2b ON T3b.b = T2b.e RIGHT OUTER JOIN\n        |(SELECT * FROM T1) T1b ON T3b.b = T1b.e\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo Welt", "Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo Welt", "Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo", "Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testRightOuterJoinRightOuterJoinCannotReorder() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.registerCollection("Table2", TestData$.MODULE$.data2(), TestData$.MODULE$.type2(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData2());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT Table5.g, c, t.g FROM Table5 RIGHT OUTER JOIN\n        |(SELECT * FROM SmallTable3 RIGHT OUTER JOIN Table2 ON b = Table2.e) t ON t.e = Table5.e\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ABC", null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"BCD", null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"CDE", null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"DEF", null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"EFG", null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"FGH", null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"GHI", null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HIJ", null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo Welt wie gehts?", null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo Welt wie", null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo Welt", "Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo Welt", "Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo", "Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"IJK", null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"JKL", null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"KLM", null, "KLM"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testInnerJoinReorder() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.registerCollection("T5", TestData$.MODULE$.data5(), TestData$.MODULE$.type5(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData5(), new FlinkStatistic(new TableStats(1000L), FlinkStatistic$.MODULE$.$lessinit$greater$default$2(), FlinkStatistic$.MODULE$.$lessinit$greater$default$3(), FlinkStatistic$.MODULE$.$lessinit$greater$default$4()));
        this.registerCollection("T3", TestData$.MODULE$.smallData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfSmallData3(), new FlinkStatistic(new TableStats(100L), FlinkStatistic$.MODULE$.$lessinit$greater$default$2(), FlinkStatistic$.MODULE$.$lessinit$greater$default$3(), FlinkStatistic$.MODULE$.$lessinit$greater$default$4()));
        this.registerCollection("T2", TestData$.MODULE$.data2(), TestData$.MODULE$.type2(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData2(), new FlinkStatistic(new TableStats(10L), FlinkStatistic$.MODULE$.$lessinit$greater$default$2(), FlinkStatistic$.MODULE$.$lessinit$greater$default$3(), FlinkStatistic$.MODULE$.$lessinit$greater$default$4()));
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T5.g, c, T2.g FROM T5 JOIN T3 ON b = T5.e\n        |JOIN T2 ON b = T2.e WHERE T2.d > 0 AND T5.d > 0\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo", "Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo Welt", "Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo Welt", "Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithAggregation() {
        this.checkResult("SELECT COUNT(g), COUNT(b) FROM SmallTable3, Table5 WHERE a = d", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)6L), BoxesRunTime.boxToLong((long)6L)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinConditionNeedSimplify() {
        this.checkResult("SELECT A.d FROM Table5 A JOIN SmallTable3 B ON (A.d=B.a and B.a>2) or (A.d=B.a and B.b=1)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinConditionDerivedFromCorrelatedSubQueryNeedSimplify() {
        this.checkResult("SELECT B.a FROM SmallTable3 B WHERE b = (select count(*) from Table5 A where (A.d=B.a and A.d<3) or (A.d=B.a and B.b=5))", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testSimple() {
        this.checkResult("select a, b from l where a in (select c from r where c > 2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testSelect() {
        this.checkResult("select t.a from (select 1 as a)t", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testCorrelated() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.checkResult("select t.a from (select l.a from l, r where l.a = r.c and l.a = 6)t", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)}))}))), this.checkResult$default$3());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Test
    public void testCorrelatedExist() {
        this.checkResult("select * from l where exists (select * from r where l.a = r.c)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
        this.checkResult("select * from l where exists (select * from r where l.a = r.c) and l.a <= 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testCorrelatedExist2() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)123456L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-123456L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Integer.MAX_VALUE)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-2147483647L)}))}));
        this.registerCollection("t1", (Iterable<Row>)data, (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO}), "f1");
        this.checkResult("select * from t1 o where exists (select 1 from t1 i where i.f1=o.f1 limit 0)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testCorrelatedNotExist() {
        this.checkResult("select * from l where not exists (select * from r where l.a = r.c and l.b <> r.d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUncorrelatedScalar() {
        this.checkResult("select (select 1) as b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult("select (select 1 as b)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult("select (select 1 as a) as b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testEqualWithAggScalar() {
        this.checkResult("select a, b from l where a = (select distinct (c) from r where c = 2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testComparisonsScalar() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkEmptyResult("select a, b from l where a = (select c from r where 1 = 2)");
            Row row = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
            Row row2 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
            Row row3 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)}));
            Row row4 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}));
            this.checkResult("select a, b from l where a >= 1.0 * (select avg(d) from r where c > 2)", (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row), this.checkResult$default$3());
        }
        Row row = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
        Row row5 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
        this.checkResult("select a, b from l where a * b < 2.0 * (select avg(d) from r where l.a = r.c and c < 6 )", (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row5).$colon$colon((Object)row), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithNull() {
        block0: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.SortMergeJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT c, g FROM NullTable3, NullTable5 WHERE (a = d OR (a IS NULL AND d IS NULL)) AND b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT c, g FROM NullTable3, NullTable5 WHERE (a = d OR (a IS NULL AND d IS NULL)) and c = 'NullTuple'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"}))}))), this.checkResult$default$3());
            this.registerCollection("NullT", (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, "c"}))})), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.allNullablesOfNullData3());
            this.checkResult("SELECT T1.a, T1.b, T1.c FROM NullT T1, NullT T2 WHERE (T1.a = T2.a OR (T1.a IS NULL AND T2.a IS NULL)) AND (T1.b = T2.b OR (T1.b IS NULL AND T2.b IS NULL)) AND T1.c = T2.c", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"null", "null", "c"}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testSingleRowJoin() {
        block0: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 JOIN (SELECT SUM(b) AS s FROM SmallTable3) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3) JOIN SmallTable3 ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 JOIN (SELECT SUM(b) AS s FROM SmallTable3) ON s <> b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3) JOIN SmallTable3 ON s <> b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testNonEmptyTableJoinEmptyTable() {
        block0: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 JOIN (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) JOIN SmallTable3 ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 FULL JOIN (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "Hello world"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) FULL JOIN SmallTable3 ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "Hello world"}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testEmptyTableJoinEmptyTable() {
        block0: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) JOIN (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) JOIN (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) FULL JOIN (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) FULL JOIN (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
        }
    }

    @Test
    public void testJoinCollation() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH v1 AS (\n        |  SELECT t1.a AS a, (t1.b + t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.a = t2.a\n        |),\n        |\n        |v2 AS (\n        |  SELECT t1.a AS a, (t1.b * t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.a = t2.a\n        |)\n        |\n        |SELECT v1.a, v2.a, v1.b, v2.b FROM v1, v2 WHERE v1.a = v2.a\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH v1 AS (\n        |  SELECT t1.a AS a, (t1.b + t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.a = t2.a\n        |),\n        |\n        |v2 AS (\n        |  SELECT t1.b AS a, (t1.b * t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.b = t2.b\n        |)\n        |\n        |SELECT v1.a, v2.a, v1.b, v2.b FROM v1, v2 WHERE v1.a = v2.a\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithUDFFilter() {
        this.registerFunction("funcWithOpen", new FuncWithOpen());
        this.checkResult("SELECT c, g FROM SmallTable3 join Table5 on funcWithOpen(a + d) where b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithFilterPushDown() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  left join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  left join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where c >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  right join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  right join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where c >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithJoinConditionPushDown() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  left join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)2), null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToInteger((int)2), null, null, null}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  left join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and c >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)2), null, null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToInteger((int)2), null, null, null}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  right join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, null, BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  right join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and c >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, null, BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
    }

    private final TwoInputTransformation findTwoInputTransform$1(Transformation t) {
        TwoInputTransformation twoInputTransformation;
        Transformation transformation;
        while (true) {
            if ((transformation = t) instanceof LegacySinkTransformation) {
                LegacySinkTransformation legacySinkTransformation = (LegacySinkTransformation)transformation;
                t = (Transformation)legacySinkTransformation.getInputs().get(0);
                continue;
            }
            if (!(transformation instanceof OneInputTransformation)) break;
            OneInputTransformation oneInputTransformation = (OneInputTransformation)transformation;
            t = (Transformation)oneInputTransformation.getInputs().get(0);
        }
        if (!(transformation instanceof TwoInputTransformation)) {
            throw new MatchError((Object)transformation);
        }
        TwoInputTransformation twoInputTransformation2 = twoInputTransformation = (TwoInputTransformation)transformation;
        return twoInputTransformation2;
    }

    public static final /* synthetic */ void $anonfun$testLongHashJoinGenerator$2(BooleanRef haveTwoOp$1, TwoInputTransformation transform) {
        StreamOperatorFactory streamOperatorFactory = transform.getOperatorFactory();
        if (streamOperatorFactory instanceof CodeGenOperatorFactory) {
            BoxedUnit boxedUnit;
            CodeGenOperatorFactory codeGenOperatorFactory = (CodeGenOperatorFactory)streamOperatorFactory;
            if (codeGenOperatorFactory.getGeneratedClass().getCode().contains("LongHashJoinOperator")) {
                haveTwoOp$1.elem = true;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public JoinITCase(Enumeration.Value expectedJoinType) {
        this.expectedJoinType = expectedJoinType;
    }
}

