/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.stream.FiniteTestSource;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Md!B\u0001\u0003\u0003\u0003\t\"!\u0007$t'R\u0014X-Y7j]\u001e\u001c\u0016N\\6J)\u000e\u000b7/\u001a\"bg\u0016T!a\u0001\u0003\u0002\rM$(/Z1n\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u0015q\u0002\u0001\"\u0001 \u00039!\u0018.\\3pkR\u0004VM\u001d+fgR,\u0012\u0001\t\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nQA];mKNT!!\n\b\u0002\u000b),h.\u001b;\n\u0005\u001d\u0012#a\u0002+j[\u0016|W\u000f\u001e\u0015\u0003;%\u0002\"AK\u0016\u000e\u0003\u0011J!\u0001\f\u0013\u0003\tI+H.\u001a\u0005\n]\u0001\u0001\r\u00111A\u0005\u0012=\n!B]3tk2$\b+\u0019;i+\u0005\u0001\u0004CA\u0019;\u001d\t\u0011\u0004\b\u0005\u00024m5\tAG\u0003\u00026!\u00051AH]8pizR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\na\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0019\u0019FO]5oO*\u0011\u0011H\u000e\u0005\n}\u0001\u0001\r\u00111A\u0005\u0012}\naB]3tk2$\b+\u0019;i?\u0012*\u0017\u000f\u0006\u0002A\tB\u0011\u0011IQ\u0007\u0002m%\u00111I\u000e\u0002\u0005+:LG\u000fC\u0004F{\u0005\u0005\t\u0019\u0001\u0019\u0002\u0007a$\u0013\u0007C\u0005H\u0001\u0001\u0007\t\u0011)Q\u0005a\u0005Y!/Z:vYR\u0004\u0016\r\u001e5!\u0011\u001dI\u0005A1A\u0005\n)\u000bA\u0001Z1uCV\t1\nE\u0002M\u001fFk\u0011!\u0014\u0006\u0003\u001dZ\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0001VJA\u0002TKF\u0004\"AU+\u000e\u0003MS!\u0001\u0016\u0006\u0002\u000bQL\b/Z:\n\u0005Y\u001b&a\u0001*po\"1\u0001\f\u0001Q\u0001\n-\u000bQ\u0001Z1uC\u0002BqA\u0017\u0001C\u0002\u0013%!*A\u0003eCR\f'\u0007\u0003\u0004]\u0001\u0001\u0006IaS\u0001\u0007I\u0006$\u0018M\r\u0011\t\u000by\u0003A\u0011I0\u0002\r\t,gm\u001c:f)\u0005\u0001\u0005FA/b!\tQ#-\u0003\u0002dI\t1!)\u001a4pe\u0016DQ!\u001a\u0001\u0005\u0002\u0019\fA#\u00193eSRLwN\\1m!J|\u0007/\u001a:uS\u0016\u001cH#A4\u0011\u0007\u0005C\u0007'\u0003\u0002jm\t)\u0011I\u001d:bs\")1\u000e\u0001C\u0001?\u0006YA/Z:u\u001d>t\u0007+\u0019:uQ\tQW\u000e\u0005\u0002+]&\u0011q\u000e\n\u0002\u0005)\u0016\u001cH\u000fC\u0003r\u0001\u0011\u0005q,\u0001\u0005uKN$\b+\u0019:uQ\t\u0001X\u000eC\u0003u\u0001\u0011\u0005q,A\nuKN$X*\u001a;bgR|'/\u001a)pY&\u001c\u0017\u0010\u000b\u0002t[\")q\u000f\u0001C\u0001?\u0006QB/Z:u!\u0006\u0014H/\u001b;j_:<\u0016\u000e\u001e5CCNL7\rR1uK\"\u0012a/\u001c\u0005\u0006u\u0002!\ta_\u0001\u001ei\u0016\u001cH\u000fU1si&$\u0018n\u001c8DkN$x.\u001c$pe6\fG\u000fR1uKR!\u0001\t`A\u0002\u0011\u0015i\u0018\u00101\u0001\u007f\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0002B\u007f&\u0019\u0011\u0011\u0001\u001c\u0003\u000f\t{w\u000e\\3b]\"A\u0011QA=\u0011\u0002\u0003\u0007\u0001'\u0001\u0004q_2L7-\u001f\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0003\u0011!Xm\u001d;\u0015+\u0001\u000bi!a\t\u0002(\u0005-\u0012qFA\u0019\u0003k\tI$!\u0010\u0002@!A\u0011qBA\u0004\u0001\u0004\t\t\"\u0001\u0006eCR\f7\u000b\u001e:fC6\u0004R!a\u0005\u0002 Ek!!!\u0006\u000b\u0007]\n9B\u0003\u0003\u0002\u001a\u0005m\u0011aA1qS*\u0019\u0011Q\u0004\u0006\u0002\u0013M$(/Z1nS:<\u0017\u0002BA\u0011\u0003+\u0011!\u0002R1uCN#(/Z1n\u0011\u001d\t)#a\u0002A\u0002A\n\u0011\u0003^5nK\u0016CHO]1di>\u00148*\u001b8e\u0011\u001d\tI#a\u0002A\u0002A\nQ\u0004^5nK\u0016CHO]1di>\u0014hi\u001c:nCR$XM\u001d)biR,'O\u001c\u0005\b\u0003[\t9\u00011\u00011\u0003Q!\u0018.\\3FqR\u0014\u0018m\u0019;peB\u000bG\u000f^3s]\"1Q0a\u0002A\u0002ABq!a\r\u0002\b\u0001\u0007\u0001'A\u0007d_6l\u0017\u000e\u001e+sS\u001e<WM\u001d\u0005\b\u0003o\t9\u00011\u00011\u0003-\u0019w.\\7ji\u0012+G.Y=\t\u000f\u0005m\u0012q\u0001a\u0001\u0017\u0006AA-\u0019;b)\u0016\u001cH\u000fC\u0005\u0002\u0006\u0005\u001d\u0001\u0013!a\u0001a!I\u0011\u0011IA\u0004!\u0003\u0005\r\u0001M\u0001\u0010gV\u001c7-Z:t\r&dWMT1nK\"9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0013!B2iK\u000e\\G#\u0002!\u0002J\u00055\u0003bBA&\u0003\u0007\u0002\r\u0001M\u0001\tgFd\u0017+^3ss\"9\u0011qJA\"\u0001\u0004Y\u0015AD3ya\u0016\u001cG/\u001a3SKN,H\u000e\u001e\u0005\n\u0003'\u0002\u0011\u0013!C\u0001\u0003+\nq\u0005^3tiB\u000b'\u000f^5uS>t7)^:u_64uN]7bi\u0012\u000bG/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u000b\u0016\u0004a\u0005e3FAA.!\u0011\ti&a\u001a\u000e\u0005\u0005}#\u0002BA1\u0003G\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015d'\u0001\u0006b]:|G/\u0019;j_:LA!!\u001b\u0002`\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u00055\u0004!%A\u0005\n\u0005U\u0013A\u0004;fgR$C-\u001a4bk2$H%\u000f\u0005\n\u0003c\u0002\u0011\u0013!C\u0005\u0003+\nq\u0002^3ti\u0012\"WMZ1vYR$\u0013\u0007\r")
public abstract class FsStreamingSinkITCaseBase
extends StreamingTestBase {
    private String resultPath;
    private final Seq<Row> data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{1, "a", "b", "05-03-2020", "07"}), Row.of((Object[])new Object[]{2, "p", "q", "05-03-2020", "08"}), Row.of((Object[])new Object[]{3, "x", "y", "05-03-2020", "09"}), Row.of((Object[])new Object[]{4, "x", "y", "05-03-2020", "10"}), Row.of((Object[])new Object[]{5, "x", "y", "05-03-2020", "11"})}));
    private final Seq<Row> data2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{1, "a", "b", "20200503", "07"}), Row.of((Object[])new Object[]{2, "p", "q", "20200503", "08"}), Row.of((Object[])new Object[]{3, "x", "y", "20200503", "09"}), Row.of((Object[])new Object[]{4, "x", "y", "20200504", "10"}), Row.of((Object[])new Object[]{5, "x", "y", "20200504", "11"})}));

    @Rule
    public Timeout timeoutPerTest() {
        return Timeout.seconds((long)240L);
    }

    public String resultPath() {
        return this.resultPath;
    }

    public void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private Seq<Row> data() {
        return this.data;
    }

    private Seq<Row> data2() {
        return this.data2;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.env().setParallelism(1);
        this.env().enableCheckpointing(100L);
        this.env().getCheckpointConfig().setCheckpointingMode(CheckpointingMode.EXACTLY_ONCE);
    }

    public String[] additionalProperties() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    @Test
    public void testNonPart() {
        this.testPartitionCustomFormatDate(false, this.testPartitionCustomFormatDate$default$2());
    }

    @Test
    public void testPart() {
        this.testPartitionCustomFormatDate(true, this.testPartitionCustomFormatDate$default$2());
        File basePath = new File(new URI(this.resultPath()).getPath(), "d=05-03-2020");
        Assert.assertEquals((long)5L, (long)basePath.list().length);
        Assert.assertTrue((boolean)new File(new File(basePath, "e=07"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "e=08"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "e=09"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "e=10"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "e=11"), "_MY_SUCCESS").exists());
    }

    @Test
    public void testMetastorePolicy() {
        this.thrown().expectMessage("Can not configure a 'metastore' partition commit policy for a file system table. You can only configure 'metastore' partition commit policy for a hive table.");
        this.testPartitionCustomFormatDate(true, "metastore");
    }

    @Test
    public void testPartitionWithBasicDate() {
        Function1 & Serializable & scala.Serializable fun = (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)FsStreamingSinkITCaseBase.$anonfun$testPartitionWithBasicDate$1(t));
        org.apache.flink.streaming.api.scala.DataStream stream = new org.apache.flink.streaming.api.scala.DataStream((DataStream)this.env().getJavaEnv().addSource((SourceFunction)new FiniteTestSource((Iterable<Row>)this.data2(), (Function1<Row, Object>)fun), (TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.INT, Types.STRING, Types.STRING, Types.STRING, Types.STRING})));
        this.test((org.apache.flink.streaming.api.scala.DataStream<Row>)stream, "default", "yyyyMMdd", "$d", "d", "partition-time", "1d", this.data2(), this.test$default$9(), this.test$default$10());
        File basePath = new File(new URI(this.resultPath()).getPath());
        Assert.assertEquals((long)2L, (long)basePath.list().length);
        Assert.assertTrue((boolean)new File(new File(basePath, "d=20200503"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "d=20200504"), "_MY_SUCCESS").exists());
    }

    public void testPartitionCustomFormatDate(boolean partition, String policy) {
        Function1 & Serializable & scala.Serializable fun = (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)FsStreamingSinkITCaseBase.$anonfun$testPartitionCustomFormatDate$1(t));
        org.apache.flink.streaming.api.scala.DataStream stream = new org.apache.flink.streaming.api.scala.DataStream((DataStream)this.env().getJavaEnv().addSource((SourceFunction)new FiniteTestSource((Iterable<Row>)this.data(), (Function1<Row, Object>)fun), (TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.INT, Types.STRING, Types.STRING, Types.STRING, Types.STRING})));
        this.test((org.apache.flink.streaming.api.scala.DataStream<Row>)stream, "default", "MM-dd-yyyy HH:mm:ss", "$d $e:00:00", partition ? "d,e" : "", "process-time", "1h", this.data(), policy, this.test$default$10());
    }

    private void test(org.apache.flink.streaming.api.scala.DataStream<Row> dataStream, String timeExtractorKind, String timeExtractorFormatterPattern, String timeExtractorPattern, String partition, String commitTrigger, String commitDelay, Seq<Row> dataTest, String policy, String successFileName) {
        this.resultPath_$eq(this.tempFolder().newFolder().toURI().toString());
        this.tEnv().createTemporaryView("my_table", dataStream, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Expressions.$((String)"a"), Expressions.$((String)"b"), Expressions.$((String)"c"), Expressions.$((String)"d"), Expressions.$((String)"e")}));
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(444).append("\n         |create table sink_table (\n         |  a int,\n         |  b string,\n         |  c string,\n         |  d string,\n         |  e string\n         |)\n         |").append((Object)(new StringOps(Predef$.MODULE$.augmentString(partition)).nonEmpty() ? new StringBuilder(18).append("partitioned by (").append(partition).append(") ").toString() : " ")).append("\n         |with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.resultPath()).append("',\n         |  '").append(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_KIND.key()).append("' = '").append(timeExtractorKind).append("',\n         |").append((Object)(new StringOps(Predef$.MODULE$.augmentString(timeExtractorFormatterPattern)).nonEmpty() ? new StringBuilder(2).append(" '").append(new StringBuilder(4).append(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_TIMESTAMP_FORMATTER.key()).append("' = ").toString()).append(new StringBuilder(3).append("'").append(timeExtractorFormatterPattern).append("',").toString()).toString() : "")).append("\n         |\n         |  '").append(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_TIMESTAMP_PATTERN.key()).append("' =\n         |      '").append(timeExtractorPattern).append("',\n         |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_TRIGGER.key()).append("' = '").append(commitTrigger).append("',\n         |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_DELAY.key()).append("' = '").append(commitDelay).append("',\n         |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_POLICY_KIND.key()).append("' = '").append(policy).append("',\n         |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_SUCCESS_FILE_NAME.key()).append("' = '").append(successFileName).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.additionalProperties())).mkString(",\n")).append("\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        this.tEnv().sqlQuery("select * from my_table").executeInsert("sink_table").await();
        this.check("select * from sink_table", dataTest);
    }

    public String testPartitionCustomFormatDate$default$2() {
        return "success-file";
    }

    private String test$default$9() {
        return "success-file";
    }

    private String test$default$10() {
        return "_MY_SUCCESS";
    }

    public void check(String sqlQuery, Seq<Row> expectedResult) {
        CloseableIterator iter = this.tEnv().sqlQuery(sqlQuery).execute().collect();
        List result = CollectionUtil.iteratorToList((Iterator)iter);
        iter.close();
        Assert.assertEquals((Object)((SeqLike)expectedResult.map((Function1 & Serializable & scala.Serializable)x$1 -> TestSinkUtil$.MODULE$.rowToString((Row)x$1, TestSinkUtil$.MODULE$.rowToString$default$2()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$), (Object)((SeqLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).map((Function1 & Serializable & scala.Serializable)x$2 -> TestSinkUtil$.MODULE$.rowToString((Row)x$2, TestSinkUtil$.MODULE$.rowToString$default$2()), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$testPartitionWithBasicDate$1(Row t) {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.parse((CharSequence)t.getFieldAs(3), DateTimeFormatter.BASIC_ISO_DATE), LocalTime.MIDNIGHT);
        return TimestampData.fromLocalDateTime((LocalDateTime)localDateTime).getMillisecond();
    }

    public static final /* synthetic */ long $anonfun$testPartitionCustomFormatDate$1(Row t) {
        LocalDateTime localDateTime = LocalDateTime.parse(new StringBuilder(7).append(t.getField(3)).append(" ").append(t.getField(4)).append(":00:00").toString(), DateTimeFormatter.ofPattern("MM-dd-yyyy HH:mm:ss"));
        return TimestampData.fromLocalDateTime((LocalDateTime)localDateTime).getMillisecond();
    }
}

