/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.junit.Before;
import org.junit.Test;

public class TableSinkJsonPlanITCase
extends JsonPlanTestBase {
    List<String> data = Arrays.asList("1,1,hi", "2,1,hello", "3,2,hello world");

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.createTestCsvSourceTable("MyTable", this.data, "a bigint", "b int", "c varchar");
    }

    @Test
    public void testPartitioning() throws Exception {
        File sinkPath = this.createTestCsvSinkTable("MySink", new String[]{"a bigint", "p int not null", "b int", "c varchar"}, "b");
        this.compileSqlAndExecutePlan("insert into MySink partition (b=3) select * from MyTable").await();
        this.assertResult(this.data, sinkPath);
    }

    @Test
    public void testWritingMetadata() throws Exception {
        this.createTestValuesSinkTable("MySink", new String[]{"a bigint", "b int", "c varchar METADATA"}, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("writable-metadata", "c:STRING");
            }
        });
        this.compileSqlAndExecutePlan("insert into MySink select * from MyTable").await();
        List<String> result = TestValuesTableFactory.getResults("MySink");
        this.assertResult(Arrays.asList("+I[1, 1, hi]", "+I[2, 1, hello]", "+I[3, 2, hello world]"), result);
    }
}

