/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.types.Row;
import org.junit.Test;

public class WatermarkAssignerJsonPlanITCase
extends JsonPlanTestBase {
    @Test
    public void testWatermarkAssigner() throws Exception {
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.data3WithTimestamp()), new String[]{"a int", "b bigint", "c varchar", "ts timestamp(3)", "watermark for ts as ts - interval '5' second"}, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("enable-watermark-push-down", "false");
            }
        });
        File sinkPath = this.createTestCsvSinkTable("MySink", "a int", "b bigint", "ts timestamp(3)");
        this.compileSqlAndExecutePlan("insert into MySink select a, b, ts from MyTable where b = 3").await();
        this.assertResult(Arrays.asList("4,3," + DateTimeUtils.toLocalDateTime((long)4000L), "5,3," + DateTimeUtils.toLocalDateTime((long)5000L), "6,3," + DateTimeUtils.toLocalDateTime((long)6000L)), sinkPath);
    }
}

