/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.table.planner.runtime.stream.sql.CompactionITCaseBase;

public abstract class FileCompactionITCaseBase
extends CompactionITCaseBase {
    protected abstract String format();

    @Override
    protected String partitionField() {
        return "b";
    }

    @Override
    protected void createTable(String path) {
        this.tEnv().executeSql("CREATE TABLE sink_table (a int, b string, c string) with (" + this.options(path) + ")");
    }

    @Override
    protected void createPartitionTable(String path) {
        this.tEnv().executeSql("CREATE TABLE sink_table (a int, b string, c string) partitioned by (b) with (" + this.options(path) + ")");
    }

    private String options(String path) {
        return "'connector'='filesystem','sink.partition-commit.policy.kind'='success-file','auto-compaction'='true','compaction.file-size' = '128MB','sink.rolling-policy.file-size' = '1b'," + this.kv("format", this.format()) + "," + this.kv("path", path);
    }

    private String kv(String key, String value) {
        return String.format("'%s'='%s'", key, value);
    }
}

