/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.TimeZone;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Tumble;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingUpsertTableSink;
import org.apache.flink.table.planner.utils.MemoryTableSourceSinkUtil$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.sinks.CsvTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001%\t)B*Z4bGf$\u0016M\u00197f'&t7.\u0013+DCN,'BA\u0002\u0005\u0003\u0015!\u0018M\u00197f\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0002\f\u0015\taQ\"A\u0003gY&t7N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0003\u0001M\u0001\"\u0001F\r\u000e\u0003UQ!AF\f\u0002\tU$\u0018\u000e\u001c\u0006\u00031-\tA\u0001^3ti&\u0011!$\u0006\u0002\u0011\u0003\n\u001cHO]1diR+7\u000f\u001e\"bg\u0016DQ\u0001\b\u0001\u0005\u0002u\ta\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\u001dU\u001cXm\u001d'fO\u0006\u001c\u0017PU8xgV\t1\u0005\u0005\u0002%O5\tQE\u0003\u0002'\u0015\u0005)Q\u000f^5mg&\u0011\u0001&\n\u0002\u0012\u0019\u0016<\u0017mY=S_^\u0014Vm]8ve\u000e,\u0007F\u0001\u0011+!\tYc&D\u0001-\u0015\tis\"A\u0003kk:LG/\u0003\u00020Y\t!!+\u001e7f\u0011\u0015\t\u0004\u0001\"\u00013\u0003M!Xm\u001d;TiJ,\u0017-\u001c+bE2,7+\u001b8l)\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$\u0001B+oSRD#\u0001\r\u001e\u0011\u0005-Z\u0014B\u0001\u001f-\u0005\u0011!Vm\u001d;\t\u000by\u0002A\u0011\u0001\u001a\u00027Q,7\u000f^!qa\u0016tGmU5oW>s\u0017\t\u001d9f]\u0012$\u0016M\u00197fQ\ti$\bC\u0003B\u0001\u0011\u0005!'A\u000euKN$\u0018\t\u001d9f]\u0012\u001c\u0016N\\6XSRDg*Z:uK\u0012\u0014vn\u001e\u0015\u0003\u0001jBQ\u0001\u0012\u0001\u0005\u0002I\nq\u0005^3ti\u0006\u0003\b/\u001a8e'&t7n\u00148BaB,g\u000e\u001a+bE2,gi\u001c:J]:,'OS8j]\"\u00121I\u000f\u0005\u0006\u000f\u0002!\tAM\u0001\u001fi\u0016\u001cHOU3ue\u0006\u001cGoU5oW>sW\u000b\u001d3bi&tw\rV1cY\u0016D#A\u0012\u001e\t\u000b)\u0003A\u0011\u0001\u001a\u00029Q,7\u000f\u001e*fiJ\f7\r^*j].|e.\u00119qK:$G+\u00192mK\"\u0012\u0011J\u000f\u0005\u0006\u001b\u0002!\tAM\u0001)i\u0016\u001cH/\u00169tKJ$8+\u001b8l\u001f:,\u0006\u000fZ1uS:<G+\u00192mK^KG\u000f\u001b$vY2\\U-\u001f\u0015\u0003\u0019jBQ\u0001\u0015\u0001\u0005\u0002I\n!\u0006^3tiV\u00038/\u001a:u'&t7n\u00148BaB,g\u000eZ5oOR\u000b'\r\\3XSRDg)\u001e7m\u0017\u0016L\u0018\u0007\u000b\u0002Pu!)1\u000b\u0001C\u0001e\u0005QC/Z:u+B\u001cXM\u001d;TS:\\wJ\\!qa\u0016tG-\u001b8h)\u0006\u0014G.Z,ji\"4U\u000f\u001c7LKf\u0014\u0004F\u0001*;\u0011\u00151\u0006\u0001\"\u00013\u00035\"Xm\u001d;VaN,'\u000f^*j].|e.\u00119qK:$\u0017N\\4UC\ndWmV5uQ>,HOR;mY.+\u00170\r\u0015\u0003+jBQ!\u0017\u0001\u0005\u0002I\nQ\u0006^3tiV\u00038/\u001a:u'&t7n\u00148BaB,g\u000eZ5oOR\u000b'\r\\3XSRDw.\u001e;Gk2d7*Z=3Q\tA&\bC\u0003]\u0001\u0011\u0005!'\u0001\ruKN$X\u000b]:feR\u001c\u0016N\\6XSRDg)\u001b7uKJD#a\u0017\u001e\t\u000b}\u0003A\u0011\u0001\u001a\u0002=Q,7\u000f\u001e+p\u0003B\u0004XM\u001c3TiJ,\u0017-\\'vYRL'k\\<uS6,\u0007\u0006\u00020;C\n\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002GB\u0011AmZ\u0007\u0002K*\u0011aMC\u0001\u0004CBL\u0017B\u00015f\u00059!\u0016M\u00197f\u000bb\u001cW\r\u001d;j_:DQA\u001b\u0001\u0005\u0002I\nq\u0004^3tiR{'+\u001a;sC\u000e$8\u000b\u001e:fC6lU\u000f\u001c;j%><H/[7fQ\u0011I'(\u00192\t\u000b5\u0004A\u0011\u0001\u001a\u0002AQ,7\u000f\u001e#fG&l\u0017\r\\!qa\u0016tGm\u0015;sK\u0006lG+\u00192mKNKgn\u001b\u0015\u0003Yj\u0002")
public class LegacyTableSinkITCase
extends AbstractTestBase {
    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    @Test
    public void testStreamTableSink() {
        File tmpFile = File.createTempFile("flink-table-sink-test", ".tmp");
        tmpFile.delete();
        tmpFile.deleteOnExit();
        String path = tmpFile.toURI().toString();
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setParallelism(4);
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("csvSink", new CsvTableSink(path).configure((String[])((Object[])new String[]{"nullableCol", "c", "b"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING(), Types.SQL_TIMESTAMP()})));
        DataStream input = env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$18 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testStreamTableSink$1(x$1))).map((Function1 & Serializable & scala.Serializable)x -> x, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$19 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).setParallelism(4);
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(input).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).where(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(5))).$bar$bar(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(17)))).select(new Expression[]{package$.MODULE$.ifThenElse(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(4)), package$.MODULE$.nullOf(Types.INT()), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))});
        table.executeInsert("csvSink").await();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",Hello world,1970-01-01 00:00:00.002", ",Hello,1970-01-01 00:00:00.002", ",Hi,1970-01-01 00:00:00.001", "18,Comment#12,1970-01-01 00:00:00.006", "19,Comment#13,1970-01-01 00:00:00.006", "20,Comment#14,1970-01-01 00:00:00.006", "21,Comment#15,1970-01-01 00:00:00.006", "4,Hello world, how are you?,1970-01-01 00:00:00.003"}))).mkString("\n");
        TestBaseUtils.compareResultsByLinesInMemory((String)expected, (String)path);
    }

    @Test
    public void testAppendSinkOnAppendTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$20 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testAppendSinkOnAppendTable$1(x$2)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        TestingAppendTableSink sink = new TestingAppendTableSink(TimeZone.getDefault());
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("appendSink", (TableSink)sink.configure((String[])((Object[])new String[]{"t", "icnt", "nsum"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.SQL_TIMESTAMP(), Types.LONG(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "t"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "nsum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("appendSink").await();
        List result = (List)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1970-01-01 00:00:00.005,4,8", (List)new .colon.colon((Object)"1970-01-01 00:00:00.010,5,18", (List)new .colon.colon((Object)"1970-01-01 00:00:00.015,5,24", (List)new .colon.colon((Object)"1970-01-01 00:00:00.020,5,29", (List)new .colon.colon((Object)"1970-01-01 00:00:00.025,2,12", (List)Nil$.MODULE$))))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testAppendSinkWithNestedRow() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$21 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$21 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text"))}));
        tEnv.registerTable("src", t);
        TestingAppendTableSink sink = new TestingAppendTableSink();
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("appendSink", (TableSink)sink.configure((String[])((Object[])new String[]{"t", "item"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.ROW((TypeInformation[])new TypeInformation[]{Types.LONG(), Types.STRING()})}))));
        tEnv.executeSql("INSERT INTO appendSink SELECT id, ROW(num, text) FROM src").await();
        List result = (List)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1,1,Hi", (List)new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,2,Hello world", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testAppendSinkOnAppendTableForInnerJoin() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table ds1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$22 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData5(), (TypeInformation)new CaseClassTypeInfo<Tuple5<Object, Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$23 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$23 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        TestingAppendTableSink sink = new TestingAppendTableSink();
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("appendSink", (TableSink)sink.configure((String[])((Object[])new String[]{"c", "g"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.STRING()}))));
        Table table = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        table.executeInsert("appendSink").await();
        List result = (List)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"Hi,Hallo", (List)new .colon.colon((Object)"Hello,Hallo Welt", (List)new .colon.colon((Object)"Hello world,Hallo Welt", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testRetractSinkOnUpdatingTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$24 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$24 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testRetractSinkOnUpdatingTable$1(x$3)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text"))}));
        TestingRetractTableSink sink = new TestingRetractTableSink();
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("retractSink", (TableSink)sink.configure((String[])((Object[])new String[]{"len", "icnt", "nsum"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.DECIMAL()}))));
        Table table = t.select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")).charLength()).as((Symbol)SymbolLiteral.bootstrap("apply", "len"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "nsum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("retractSink").await();
        List retracted = (List)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"2,1,1.000000000000000000", (List)new .colon.colon((Object)"5,1,2.000000000000000000", (List)new .colon.colon((Object)"11,1,2.000000000000000000", (List)new .colon.colon((Object)"25,1,3.000000000000000000", (List)new .colon.colon((Object)"10,7,39.000000000000000000", (List)new .colon.colon((Object)"14,1,3.000000000000000000", (List)new .colon.colon((Object)"9,9,41.000000000000000000", (List)Nil$.MODULE$))))))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testRetractSinkOnAppendTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$25 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$25 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testRetractSinkOnAppendTable$1(x$4)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        TestingRetractTableSink sink = new TestingRetractTableSink(TimeZone.getDefault());
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("retractSink", (TableSink)sink.configure((String[])((Object[])new String[]{"t", "icnt", "nsum"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.SQL_TIMESTAMP(), Types.LONG(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "t"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "nsum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("retractSink").await();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)sink.getRawResults().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith("(false,"))));
        List retracted = (List)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1970-01-01 00:00:00.005,4,8", (List)new .colon.colon((Object)"1970-01-01 00:00:00.010,5,18", (List)new .colon.colon((Object)"1970-01-01 00:00:00.015,5,24", (List)new .colon.colon((Object)"1970-01-01 00:00:00.020,5,29", (List)new .colon.colon((Object)"1970-01-01 00:00:00.025,2,12", (List)Nil$.MODULE$))))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnUpdatingTableWithFullKey() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$26 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$26 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testUpsertSinkOnUpdatingTableWithFullKey$1(x$6)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text"))}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0, 2}, TimeZone.getDefault()).configure((String[])((Object[])new String[]{"cnt", "lencnt", "cTrue"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.DECIMAL(), Types.BOOLEAN()})));
        sink.expectedKeys_$eq((Option<String[]>)new Some((Object)new String[]{"cnt", "cTrue"}));
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink);
        Table table = t.select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")).charLength()).as((Symbol)SymbolLiteral.bootstrap("apply", "len"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).$greater(package$.MODULE$.int2Literal(0))).as((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "count"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "count")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "count")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "lencnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"))});
        table.executeInsert("upsertSink").await();
        Assert.assertTrue((String)"Results must include delete messages", (boolean)sink.getRawResults().exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith("(false,"))));
        List retracted = (List)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1,5.000000000000000000,true", (List)new .colon.colon((Object)"7,1.000000000000000000,true", (List)new .colon.colon((Object)"9,1.000000000000000000,true", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithFullKey1() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$27 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$27 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithFullKey1$1(x$8)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0, 1, 2}, TimeZone.getDefault()).configure((String[])((Object[])new String[]{"num", "wend", "icnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.SQL_TIMESTAMP(), Types.LONG()})));
        sink.expectedKeys_$eq((Option<String[]>)new Some((Object)new String[]{"wend", "num"}));
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink);
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "window_end"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("upsertSink").await();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)sink.getRawResults().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.startsWith("(false,"))));
        List retracted = (List)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1970-01-01 00:00:00.005,1", "2,1970-01-01 00:00:00.005,2", "3,1970-01-01 00:00:00.005,1", "3,1970-01-01 00:00:00.010,2", "4,1970-01-01 00:00:00.010,3", "4,1970-01-01 00:00:00.015,1", "5,1970-01-01 00:00:00.015,4", "5,1970-01-01 00:00:00.020,1", "6,1970-01-01 00:00:00.020,4", "6,1970-01-01 00:00:00.025,2"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithFullKey2() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$28 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$11[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$11(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$28 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithFullKey2$1(x$10)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0, 1, 2}, TimeZone.getDefault());
        sink.expectedKeys_$eq((Option<String[]>)new Some((Object)new String[]{"wend", "num"}));
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink.configure((String[])((Object[])new String[]{"wstart", "wend", "num", "icnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.SQL_TIMESTAMP(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start()).as((Symbol)SymbolLiteral.bootstrap("apply", "wstart"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "wend"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("upsertSink").await();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)sink.getRawResults().exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.startsWith("(false,"))));
        List retracted = (List)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.000,1970-01-01 00:00:00.005,1,1", "1970-01-01 00:00:00.000,1970-01-01 00:00:00.005,2,2", "1970-01-01 00:00:00.000,1970-01-01 00:00:00.005,3,1", "1970-01-01 00:00:00.005,1970-01-01 00:00:00.010,3,2", "1970-01-01 00:00:00.005,1970-01-01 00:00:00.010,4,3", "1970-01-01 00:00:00.010,1970-01-01 00:00:00.015,4,1", "1970-01-01 00:00:00.010,1970-01-01 00:00:00.015,5,4", "1970-01-01 00:00:00.015,1970-01-01 00:00:00.020,5,1", "1970-01-01 00:00:00.015,1970-01-01 00:00:00.020,6,4", "1970-01-01 00:00:00.020,1970-01-01 00:00:00.025,6,2"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithoutFullKey1() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$29 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$12[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$12(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$29 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithoutFullKey1$1(x$12)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0}, TimeZone.getDefault());
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink.configure((String[])((Object[])new String[]{"wend", "cnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.SQL_TIMESTAMP(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "wend"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "cnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("upsertSink").await();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)sink.getRawResults().exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.startsWith("(false,"))));
        List retracted = (List)sink.getRawResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(true,1970-01-01 00:00:00.005,1)", "(true,1970-01-01 00:00:00.005,2)", "(true,1970-01-01 00:00:00.005,1)", "(true,1970-01-01 00:00:00.010,2)", "(true,1970-01-01 00:00:00.010,3)", "(true,1970-01-01 00:00:00.015,1)", "(true,1970-01-01 00:00:00.015,4)", "(true,1970-01-01 00:00:00.020,1)", "(true,1970-01-01 00:00:00.020,4)", "(true,1970-01-01 00:00:00.025,2)"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithoutFullKey2() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$30 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$13[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$13(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$30 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithoutFullKey2$1(x$14)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0}, TimeZone.getDefault());
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink.configure((String[])((Object[])new String[]{"num", "cnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "cnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("upsertSink").await();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)sink.getRawResults().exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.startsWith("(false,"))));
        List retracted = (List)sink.getRawResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(true,1,1)", "(true,2,2)", "(true,3,1)", "(true,3,2)", "(true,4,3)", "(true,4,1)", "(true,5,4)", "(true,5,1)", "(true,6,4)", "(true,6,2)"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkWithFilter() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setParallelism(4);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$31 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$14[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$14(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$31 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testUpsertSinkWithFilter$1(x$16)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text"))}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0});
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink.configure((String[])((Object[])new String[]{"num", "cnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.LONG()}))));
        Table table = t.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "cnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cnt")).$less$eq(package$.MODULE$.int2Literal(3)));
        table.executeInsert("upsertSink").await();
        .colon.colon expectedWithFilter = new .colon.colon((Object)"1,1", (List)new .colon.colon((Object)"2,2", (List)new .colon.colon((Object)"3,3", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expectedWithFilter.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test(expected=TableException.class)
    public void testToAppendStreamMultiRowtime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$32 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$15[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$15(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$32 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testToAppendStreamMultiRowtime$1(x$17)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        Table r = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).milli())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime(), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime()).as((Symbol)SymbolLiteral.bootstrap("apply", "rowtime2"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(r).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test(expected=TableException.class)
    public void testToRetractStreamMultiRowtime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$33 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$16[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$16(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$33 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testToRetractStreamMultiRowtime$1(x$18)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        Table r = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).milli())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime(), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime()).as((Symbol)SymbolLiteral.bootstrap("apply", "rowtime2"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(r).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testDecimalAppendStreamTableSink() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        MemoryTableSourceSinkUtil$.MODULE$.clear();
        TableSchema schema = TableSchema.builder().field("c", DataTypes.VARCHAR((int)5)).field("b", DataTypes.DECIMAL((int)10, (int)0)).field("d", DataTypes.CHAR((int)5)).build();
        MemoryTableSourceSinkUtil$.MODULE$.createDataTypeAppendStreamTable((TableEnvironment)tEnv, schema, "testSink");
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$34 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$17[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$17(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$34 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("testSink").await();
        java.util.List results = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(MemoryTableSourceSinkUtil$.MODULE$.tableDataStrings()).asJava();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"12345,55,12345"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)results, (String)expected);
    }

    public static final /* synthetic */ long $anonfun$testStreamTableSink$1(Tuple3 x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1._2());
    }

    public static final /* synthetic */ long $anonfun$testAppendSinkOnAppendTable$1(Tuple3 x$2) {
        return BoxesRunTime.unboxToInt((Object)x$2._1());
    }

    public static final /* synthetic */ long $anonfun$testRetractSinkOnUpdatingTable$1(Tuple3 x$3) {
        return BoxesRunTime.unboxToInt((Object)x$3._1());
    }

    public static final /* synthetic */ long $anonfun$testRetractSinkOnAppendTable$1(Tuple3 x$4) {
        return BoxesRunTime.unboxToInt((Object)x$4._1());
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnUpdatingTableWithFullKey$1(Tuple3 x$6) {
        return BoxesRunTime.unboxToInt((Object)x$6._1());
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnAppendingTableWithFullKey1$1(Tuple3 x$8) {
        return BoxesRunTime.unboxToInt((Object)x$8._1());
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnAppendingTableWithFullKey2$1(Tuple3 x$10) {
        return BoxesRunTime.unboxToInt((Object)x$10._1());
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnAppendingTableWithoutFullKey1$1(Tuple3 x$12) {
        return BoxesRunTime.unboxToInt((Object)x$12._1());
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnAppendingTableWithoutFullKey2$1(Tuple3 x$14) {
        return BoxesRunTime.unboxToInt((Object)x$14._1());
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkWithFilter$1(Tuple3 x$16) {
        return BoxesRunTime.unboxToInt((Object)x$16._1());
    }

    public static final /* synthetic */ long $anonfun$testToAppendStreamMultiRowtime$1(Tuple3 x$17) {
        return BoxesRunTime.unboxToInt((Object)x$17._1());
    }

    public static final /* synthetic */ long $anonfun$testToRetractStreamMultiRowtime$1(Tuple3 x$18) {
        return BoxesRunTime.unboxToInt((Object)x$18._1());
    }
}

