/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.typeutils;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.typeutils.RowTypeUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RowTypeUtilsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final RowType srcType = RowType.of((LogicalType[])new LogicalType[]{new IntType(), new VarCharType(), new BigIntType()}, (String[])new String[]{"f0", "f1", "f2"});

    @Test
    public void testGetUniqueName() {
        Assertions.assertThat((List)RowTypeUtils.getUniqueName(Arrays.asList("Dave", "Evan"), Arrays.asList("Alice", "Bob"))).isEqualTo(Arrays.asList("Dave", "Evan"));
        Assertions.assertThat((List)RowTypeUtils.getUniqueName(Arrays.asList("Bob", "Bob", "Dave", "Alice"), Arrays.asList("Alice", "Bob"))).isEqualTo(Arrays.asList("Bob_0", "Bob_1", "Dave", "Alice_0"));
    }

    @Test
    public void testProjectRowType() {
        Assertions.assertThat((Object)RowTypeUtils.projectRowType((RowType)this.srcType, (int[])new int[]{0})).isEqualTo((Object)RowType.of((LogicalType[])new LogicalType[]{new IntType()}, (String[])new String[]{"f0"}));
        Assertions.assertThat((Object)RowTypeUtils.projectRowType((RowType)this.srcType, (int[])new int[]{0, 2})).isEqualTo((Object)RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType()}, (String[])new String[]{"f0", "f2"}));
        Assertions.assertThat((Object)RowTypeUtils.projectRowType((RowType)this.srcType, (int[])new int[]{0, 1, 2})).isEqualTo((Object)this.srcType);
    }

    @Test
    public void testInvalidProjectRowType() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Invalid projection index: 3");
        RowTypeUtils.projectRowType((RowType)this.srcType, (int[])new int[]{0, 1, 2, 3});
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Invalid projection index: 3");
        RowTypeUtils.projectRowType((RowType)this.srcType, (int[])new int[]{0, 1, 3});
        this.expectedException.expect(ValidationException.class);
        this.expectedException.expectMessage("Field names must be unique. Found duplicates");
        RowTypeUtils.projectRowType((RowType)this.srcType, (int[])new int[]{0, 0, 0, 0});
    }
}

