/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.utils.CountMinMaxAcc;
import org.apache.flink.types.Row;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u001f\tY1i\\;oi6Kg.T1y\u0015\t\u0019A!A\u0003vi&d7O\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001B!\u0005\u000b\u001795\t!C\u0003\u0002\u0014\r\u0005Ia-\u001e8di&|gn]\u0005\u0003+I\u0011\u0011#Q4he\u0016<\u0017\r^3Gk:\u001cG/[8o!\t9\"$D\u0001\u0019\u0015\tI\u0002\"A\u0003usB,7/\u0003\u0002\u001c1\t\u0019!k\\<\u0011\u0005uqR\"\u0001\u0002\n\u0005}\u0011!AD\"pk:$X*\u001b8NCb\f5m\u0019\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"!\b\u0001\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\u0015\u0005\u001c7-^7vY\u0006$X\rF\u0002([=\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012A!\u00168ji\")a\u0006\na\u00019\u0005\u0019\u0011mY2\t\u000bA\"\u0003\u0019A\u0019\u0002\u000bY\fG.^3\u0011\u0005!\u0012\u0014BA\u001a*\u0005\rIe\u000e\u001e\u0005\u0006k\u0001!\tEN\u0001\u0012GJ,\u0017\r^3BG\u000e,X.\u001e7bi>\u0014H#\u0001\u000f\t\u000ba\u0002A\u0011I\u001d\u0002\u0011\u001d,GOV1mk\u0016$\"A\u0006\u001e\t\u000b9:\u0004\u0019\u0001\u000f\t\u000bq\u0002A\u0011I\u001f\u0002\u001b\u001d,GOU3tk2$H+\u001f9f)\u0005q\u0004cA G-5\t\u0001I\u0003\u0002B\u0005\u0006AA/\u001f9fS:4wN\u0003\u0002D\t\u000611m\\7n_:T!!\u0012\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002H\u0001\nyA+\u001f9f\u0013:4wN]7bi&|g\u000e")
public class CountMinMax
extends AggregateFunction<Row, CountMinMaxAcc> {
    public void accumulate(CountMinMaxAcc acc, int value) {
        if (acc.count() == 0L || value < acc.min()) {
            acc.min_$eq(value);
        }
        if (acc.count() == 0L || value > acc.max()) {
            acc.max_$eq(value);
        }
        acc.count_$eq(acc.count() + 1L);
    }

    public CountMinMaxAcc createAccumulator() {
        return new CountMinMaxAcc(0L, 0, 0);
    }

    public Row getValue(CountMinMaxAcc acc) {
        int min = acc.count() > 0L ? acc.min() : BoxesRunTime.unboxToInt(null);
        int max = acc.count() > 0L ? acc.max() : BoxesRunTime.unboxToInt(null);
        return Row.of((Object[])new Object[]{acc.count(), min, max});
    }

    public TypeInformation<Row> getResultType() {
        return new RowTypeInfo(new TypeInformation[]{Types.LONG(), Types.INT(), Types.INT()});
    }
}

