/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.planner.runtime.utils.TimeTestUtil;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.tsextractors.ExistingField;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.sources.wmstrategies.PreserveWatermarks;
import org.apache.flink.table.sources.wmstrategies.WatermarkStrategy;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0001\u0003\u0001=\u0011\u0011\u0004V3tiB\u0013Xm]3sm\u0016<V\nV1cY\u0016\u001cv.\u001e:dK*\u00111\u0001B\u0001\u0006kRLGn\u001d\u0006\u0003\u000b\u0019\tq\u0001\u001d7b]:,'O\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005A\t3\u0003\u0002\u0001\u001235\u0002\"AE\f\u000e\u0003MQ!\u0001F\u000b\u0002\t1\fgn\u001a\u0006\u0002-\u0005!!.\u0019<b\u0013\tA2C\u0001\u0004PE*,7\r\u001e\t\u00045uyR\"A\u000e\u000b\u0005q1\u0011aB:pkJ\u001cWm]\u0005\u0003=m\u0011\u0011c\u0015;sK\u0006lG+\u00192mKN{WO]2f!\t\u0001\u0013\u0005\u0004\u0001\u0005\u000b\t\u0002!\u0019A\u0012\u0003\u0003Q\u000b\"\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\u000f9{G\u000f[5oOB\u0011QeK\u0005\u0003Y\u0019\u00121!\u00118z!\tQb&\u0003\u000207\tAB)\u001a4j]\u0016$'k\\<uS6,\u0017\t\u001e;sS\n,H/Z:\t\u0011E\u0002!\u0011!Q\u0001\nI\n1\u0002^1cY\u0016\u001c6\r[3nCB\u00111GN\u0007\u0002i)\u0011QGB\u0001\u0004CBL\u0017BA\u001c5\u0005-!\u0016M\u00197f'\u000eDW-\\1\t\u0011e\u0002!\u0011!Q\u0001\ni\n!B]3ukJtG+\u001f9f!\rY\u0014iH\u0007\u0002y)\u0011QHP\u0001\tif\u0004X-\u001b8g_*\u0011q\bQ\u0001\u0007G>lWn\u001c8\u000b\u0005UB\u0011B\u0001\"=\u0005=!\u0016\u0010]3J]\u001a|'/\\1uS>t\u0007\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\u0002\rY\fG.^3t!\r1e*\u0015\b\u0003\u000f2s!\u0001S&\u000e\u0003%S!A\u0013\b\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0013BA''\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0014)\u0003\u0007M+\u0017O\u0003\u0002NMA!aI\u0015+X\u0013\t\u0019\u0006K\u0001\u0004FSRDWM\u001d\t\u0005KU;v$\u0003\u0002WM\t1A+\u001e9mKJ\u0002\"!\n-\n\u0005e3#\u0001\u0002'p]\u001eD\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001X\u0001\be><H/[7f!\ti\u0016M\u0004\u0002_?B\u0011\u0001JJ\u0005\u0003A\u001a\na\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\u0019\u0019FO]5oO*\u0011\u0001M\n\u0005\u0006K\u0002!\tAZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u001dL'n\u001b7\u0011\u0007!\u0004q$D\u0001\u0003\u0011\u0015\tD\r1\u00013\u0011\u0015ID\r1\u0001;\u0011\u0015!E\r1\u0001F\u0011\u0015YF\r1\u0001]\u0011\u0015q\u0007\u0001\"\u0011p\u0003y9W\r\u001e*poRLW.Z!uiJL'-\u001e;f\t\u0016\u001c8M]5qi>\u00148\u000fF\u0001q!\r\tHO^\u0007\u0002e*\u00111/F\u0001\u0005kRLG.\u0003\u0002ve\n!A*[:u!\tQr/\u0003\u0002y7\tQ\"k\\<uS6,\u0017\t\u001e;sS\n,H/\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe\")!\u0010\u0001C!w\u0006iq-\u001a;ECR\f7\u000b\u001e:fC6$2\u0001`A\u0006!\u0011i\u0018qA\u0010\u000e\u0003yT1a`A\u0001\u0003)!\u0017\r^1tiJ,\u0017-\u001c\u0006\u0004k\u0005\r!bAA\u0003\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0004\u0003\u0013q(A\u0003#bi\u0006\u001cFO]3b[\"9\u0011QB=A\u0002\u0005=\u0011aB3yK\u000e,eN\u001e\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)!\u0011QCA\u0001\u0003-)gN^5s_:lWM\u001c;\n\t\u0005e\u00111\u0003\u0002\u001b'R\u0014X-Y7Fq\u0016\u001cW\u000f^5p]\u0016sg/\u001b:p]6,g\u000e\u001e\u0005\b\u0003;\u0001A\u0011IA\u0010\u000359W\r\u001e*fiV\u0014h\u000eV=qKR\t!\bC\u0004\u0002$\u0001!\t%!\n\u0002\u001d\u001d,G\u000fV1cY\u0016\u001c6\r[3nCR\t!\u0007C\u0004\u0002*\u0001!\t%a\u000b\u0002\u001b\u0015D\b\u000f\\1j]N{WO]2f)\u0005a\u0006")
public class TestPreserveWMTableSource<T>
implements StreamTableSource<T>,
DefinedRowtimeAttributes {
    private final TableSchema tableSchema;
    private final TypeInformation<T> returnType;
    private final Seq<Either<Tuple2<Object, T>, Object>> values;
    private final String rowtime;

    public boolean isBounded() {
        return super.isBounded();
    }

    public List<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptors() {
        return Collections.singletonList(new RowtimeAttributeDescriptor(this.rowtime, (TimestampExtractor)new ExistingField(this.rowtime), (WatermarkStrategy)PreserveWatermarks.INSTANCE));
    }

    public DataStream<T> getDataStream(StreamExecutionEnvironment execEnv) {
        return execEnv.addSource(new TimeTestUtil.EventTimeSourceFunction<T>(this.values)).setParallelism(1).setMaxParallelism(1).returns(this.returnType);
    }

    public TypeInformation<T> getReturnType() {
        return this.returnType;
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public String explainSource() {
        return "";
    }

    public TestPreserveWMTableSource(TableSchema tableSchema, TypeInformation<T> returnType, Seq<Either<Tuple2<Object, T>, Object>> values, String rowtime) {
        this.tableSchema = tableSchema;
        this.returnType = returnType;
        this.values = values;
        this.rowtime = rowtime;
    }
}

