/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.utils;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.calcite.shaded.com.google.common.primitives.Primitives;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionRequirement;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.functions.utils.AggSqlFunction$;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction$;
import org.apache.flink.table.planner.functions.utils.TableSqlFunction;
import org.apache.flink.table.planner.functions.utils.TableSqlFunction$;
import org.apache.flink.table.planner.plan.schema.DeferredTypeFlinkTableFunction;
import org.apache.flink.table.runtime.types.ClassDataTypeConverter;
import org.apache.flink.table.runtime.types.ClassLogicalTypeConverter;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.InstantiationUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.BigDecimal;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class UserDefinedFunctionUtils$ {
    public static UserDefinedFunctionUtils$ MODULE$;

    static {
        new UserDefinedFunctionUtils$();
    }

    public void checkForInstantiation(Class<?> clazz) {
        if (!InstantiationUtil.isPublic(clazz)) {
            throw new ValidationException(new StringBuilder(30).append("Function class ").append(clazz.getCanonicalName()).append(" is not public.").toString());
        }
        if (!InstantiationUtil.isProperClass(clazz)) {
            throw new ValidationException(new StringBuilder(93).append("Function class ").append(clazz.getCanonicalName()).append(" is no proper class,").append(" it is either abstract, an interface, or a primitive type.").toString());
        }
        if (InstantiationUtil.isNonStaticInnerClass(clazz)) {
            throw new ValidationException(new StringBuilder(60).append("The class ").append(clazz.getCanonicalName()).append(" is an inner class, but").append(" not statically accessible.").toString());
        }
    }

    public void checkNotSingleton(Class<?> clazz) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clazz.getFields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).contains((Object)"MODULE$")) {
            throw new ValidationException(new StringBuilder(94).append("TableFunction implemented by class ").append(clazz.getCanonicalName()).append(" ").append("is a Scala object, it is forbidden since concurrent risks.").toString());
        }
    }

    public Method throwValidationException(String name, UserDefinedFunction func, LogicalType[] parameters) {
        throw new ValidationException(new StringBuilder(61).append("Given parameters of function '").append(name).append("' do not match any signature. \n").append(new StringBuilder(10).append("Actual: ").append(this.signatureInternalToString((Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])parameters))).append(" \n").toString()).append(new StringBuilder(10).append("Expected: ").append(this.signaturesToString(func, "eval")).toString()).toString());
    }

    public Class<?>[] getParamClassesConsiderVarArgs(boolean isVarArgs, Class<?>[] matchingSignature, int expectedLength) {
        ObjectRef paramClasses = ObjectRef.create((Object)new ArrayBuffer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), expectedLength).foreach((Function1 & Serializable & scala.Serializable)i -> UserDefinedFunctionUtils$.$anonfun$getParamClassesConsiderVarArgs$1(isVarArgs, matchingSignature, paramClasses, BoxesRunTime.unboxToInt((Object)i)));
        return (Class[])((ArrayBuffer)paramClasses.elem).toArray(ClassTag$.MODULE$.apply(Class.class));
    }

    public Class<?>[] getEvalMethodSignature(ScalarFunction func, LogicalType[] expectedTypes) {
        Method method = (Method)this.getEvalUserDefinedMethod(func, (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])expectedTypes)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.throwValidationException(func.getClass().getCanonicalName(), (UserDefinedFunction)func, expectedTypes));
        return this.getParamClassesConsiderVarArgs(method.isVarArgs(), method.getParameterTypes(), expectedTypes.length);
    }

    public Option<Class<?>[]> getEvalMethodSignatureOption(ScalarFunction func, LogicalType[] expectedTypes) {
        return this.getEvalUserDefinedMethod(func, (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])expectedTypes)).map((Function1 & Serializable & scala.Serializable)method -> MODULE$.getParamClassesConsiderVarArgs(method.isVarArgs(), method.getParameterTypes(), expectedTypes.length));
    }

    public Class<?>[] getEvalMethodSignature(TableFunction<?> func, LogicalType[] expectedTypes) {
        Method method = (Method)this.getEvalUserDefinedMethod(func, (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])expectedTypes)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.throwValidationException(func.getClass().getCanonicalName(), (UserDefinedFunction)func, expectedTypes));
        return this.getParamClassesConsiderVarArgs(method.isVarArgs(), method.getParameterTypes(), expectedTypes.length);
    }

    public DataType[] getAggUserDefinedInputTypes(ImperativeAggregateFunction<?, ?> func, DataType externalAccType, LogicalType[] expectedTypes) {
        Method accMethod = (Method)this.getAggFunctionUDIMethod(func, "accumulate", externalAccType, (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])expectedTypes)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.throwValidationException(func.getClass().getCanonicalName(), (UserDefinedFunction)func, expectedTypes));
        DataType[] udiTypes = (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getParamClassesConsiderVarArgs(accMethod.isVarArgs(), (Class[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])accMethod.getParameterTypes())).drop(1), expectedTypes.length))).map((Function1 & Serializable & scala.Serializable)x$1 -> ClassDataTypeConverter.fromClassToDataType((Class)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
        return (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])udiTypes)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DataType dataType;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            DataType t = (DataType)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (t == null) throw new MatchError((Object)tuple2);
            DataType dataType2 = t;
            LogicalTypeRoot logicalTypeRoot = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)dataType2).getTypeRoot();
            LogicalTypeRoot logicalTypeRoot2 = LogicalTypeRoot.RAW;
            if (!(logicalTypeRoot != null ? !logicalTypeRoot.equals(logicalTypeRoot2) : logicalTypeRoot2 != null)) {
                DataType returnType = LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)expectedTypes[i]);
                dataType = expectedTypes[i].supportsOutputConversion(dataType2.getConversionClass()) ? (DataType)returnType.bridgedTo(dataType2.getConversionClass()) : returnType;
                return dataType;
            } else {
                dataType = dataType2;
            }
            return dataType;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
    }

    public Option<Class<?>[]> getAccumulateMethodSignature(ImperativeAggregateFunction<?, ?> function, Seq<LogicalType> expectedTypes) {
        return this.getAggFunctionUDIMethod(function, "accumulate", this.getAccumulatorTypeOfAggregateFunction(function, this.getAccumulatorTypeOfAggregateFunction$default$2()), expectedTypes).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getParameterTypes());
    }

    public LogicalType[] getParameterTypes(UserDefinedFunction function, Class<?>[] signature) {
        return (LogicalType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signature)).map((Function1 & Serializable & scala.Serializable)c -> {
            LogicalType logicalType;
            try {
                logicalType = TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType((TypeInformation)TypeExtractor.getForClass((Class)c));
            }
            catch (InvalidTypesException ite) {
                throw new ValidationException(new StringBuilder(108).append("Parameter types of function '").append(function.getClass().getCanonicalName()).append("' cannot be ").append("automatically determined. Please provide type information manually.").toString());
            }
            return logicalType;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
    }

    public Option<Method> getEvalUserDefinedMethod(ScalarFunction function, Seq<LogicalType> expectedTypes) {
        return this.getUserDefinedMethod((UserDefinedFunction)function, "eval", this.logicalTypesToExternalClasses(expectedTypes), (LogicalType[])expectedTypes.toArray(ClassTag$.MODULE$.apply(LogicalType.class)), (Function1<Class<?>[], DataType[]>)(Function1 & Serializable & scala.Serializable)paraClasses -> (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])function.getParameterTypes(paraClasses))).map((Function1 & Serializable & scala.Serializable)x$1 -> TypeConversions.fromLegacyInfoToDataType((TypeInformation)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))), this.getUserDefinedMethod$default$6(), this.getUserDefinedMethod$default$7());
    }

    public Option<Method> getEvalUserDefinedMethod(TableFunction<?> function, Seq<LogicalType> expectedTypes) {
        return this.getUserDefinedMethod((UserDefinedFunction)function, "eval", this.logicalTypesToExternalClasses(expectedTypes), (LogicalType[])expectedTypes.toArray(ClassTag$.MODULE$.apply(LogicalType.class)), (Function1<Class<?>[], DataType[]>)(Function1 & Serializable & scala.Serializable)paraClasses -> (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])function.getParameterTypes(paraClasses))).map((Function1 & Serializable & scala.Serializable)x$1 -> TypeConversions.fromLegacyInfoToDataType((TypeInformation)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))), this.getUserDefinedMethod$default$6(), this.getUserDefinedMethod$default$7());
    }

    public Option<Method> getAggFunctionUDIMethod(ImperativeAggregateFunction<?, ?> function, String methodName, DataType accType, Seq<LogicalType> expectedTypes) {
        Seq input = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new LogicalType[]{LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)accType)})).$plus$plus(expectedTypes, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class))))).toSeq();
        Seq possibleSignatures = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[][]{this.logicalTypesToInternalClasses((Seq<LogicalType>)input), this.logicalTypesToExternalClasses((Seq<LogicalType>)input)}));
        return ((TraversableLike)possibleSignatures.flatMap((Function1 & Serializable & scala.Serializable)signatures -> Option$.MODULE$.option2Iterable(MODULE$.getUserDefinedMethod((UserDefinedFunction)function, methodName, (Class<?>[])signatures, (LogicalType[])((TraversableOnce)input.map((Function1 & Serializable & scala.Serializable)t -> t == null ? null : t, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class)), (Function1<Class<?>[], DataType[]>)(Function1 & Serializable & scala.Serializable)cls -> (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new DataType[]{accType})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cls)).drop(1))).map((Function1 & Serializable & scala.Serializable)x$1 -> ClassDataTypeConverter.fromClassToDataType((Class)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))), MODULE$.getUserDefinedMethod$default$6(), MODULE$.getUserDefinedMethod$default$7())), Seq$.MODULE$.canBuildFrom())).headOption();
    }

    public Option<Method> getUserDefinedMethod(UserDefinedFunction function, String methodName, Seq<DataType> signature) {
        return this.getUserDefinedMethod(function, methodName, this.typesToClasses(signature), (LogicalType[])((TraversableOnce)signature.map((Function1 & Serializable & scala.Serializable)t -> t == null ? null : LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)t), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class)), (Function1<Class<?>[], DataType[]>)(Function1 & Serializable & scala.Serializable)cls -> (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cls)).map((Function1 & Serializable & scala.Serializable)clazz -> {
            DataType dataType;
            try {
                dataType = ClassDataTypeConverter.fromClassToDataType((Class)clazz);
            }
            catch (Exception exception) {
                dataType = null;
            }
            return dataType;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))), this.getUserDefinedMethod$default$6(), this.getUserDefinedMethod$default$7());
    }

    public Option<Method> getUserDefinedMethod(UserDefinedFunction function, String methodName, Class<?>[] methodSignature, LogicalType[] internalTypes, Function1<Class<?>[], DataType[]> parameterTypes, Function2<Class<?>, Class<?>, Object> parameterClassEquals, Function2<LogicalType, DataType, Object> parameterDataTypeEquals) {
        Method[] methods = this.checkAndExtractMethods(function, methodName);
        IntRef applyCnt = IntRef.create((int)0);
        Method[] filtered = (Method[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])methods)).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.$anonfun$getUserDefinedMethod$4(methodSignature, internalTypes, parameterTypes, parameterClassEquals, parameterDataTypeEquals, applyCnt, x0$2)));
        int fixedMethodsCount = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filtered)).count((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.$anonfun$getUserDefinedMethod$7(x$3)));
        Method[] found = (Method[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filtered)).filter((Function1 & Serializable & scala.Serializable)cur -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.$anonfun$getUserDefinedMethod$8(fixedMethodsCount, cur))))).filter((Function1 & Serializable & scala.Serializable)cur -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.$anonfun$getUserDefinedMethod$9(cur)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])found)).isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])methods)).exists((Function1 & Serializable & scala.Serializable)method -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.$anonfun$getUserDefinedMethod$10(methodSignature, internalTypes, parameterTypes, parameterClassEquals, parameterDataTypeEquals, method)))) {
            throw new ValidationException(new StringBuilder(114).append("Scala-style variable arguments in '").append(methodName).append("' methods are not supported. Please ").append("add a @scala.annotation.varargs annotation.").toString());
        }
        if (found.length > 1) {
            if (applyCnt.elem > 0) {
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])found)).headOption();
            }
            Method[] nonObjectParameterMethods = (Method[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])found)).filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.$anonfun$getUserDefinedMethod$12(m)));
            if (nonObjectParameterMethods.length == 1) {
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonObjectParameterMethods)).headOption();
            }
            throw new ValidationException(new StringBuilder(52).append("Found multiple '").append(methodName).append("' methods which match the signature.").toString());
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])found)).headOption();
    }

    public Function2<Class<?>, Class<?>, Object> getUserDefinedMethod$default$6() {
        return (Function2 & Serializable & scala.Serializable)(candidate, expected) -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.MODULE$.parameterClassEquals(candidate, expected));
    }

    public Function2<LogicalType, DataType, Object> getUserDefinedMethod$default$7() {
        return (Function2 & Serializable & scala.Serializable)(internal, parameterType) -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.MODULE$.parameterDataTypeEquals(internal, parameterType));
    }

    public boolean ifMethodExistInFunction(String method, UserDefinedFunction function) {
        Method[] methods = (Method[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])function.getClass().getMethods())).filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.$anonfun$ifMethodExistInFunction$1(method, m)));
        return !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])methods)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public Method[] checkAndExtractMethods(UserDefinedFunction function, String methodName) {
        void var3_3;
        Method[] methods = (Method[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])function.getClass().getMethods())).filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.$anonfun$checkAndExtractMethods$1(function, methodName, m)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])methods)).isEmpty()) {
            throw new ValidationException(new StringBuilder(86).append("Function class '").append(function.getClass().getCanonicalName()).append("' does not implement at least ").append(new StringBuilder(54).append("one method named '").append(methodName).append("' which is public, not abstract and ").toString()).append("(in case of table functions) not static.").toString());
        }
        return var3_3;
    }

    public Class<?>[][] getMethodSignatures(UserDefinedFunction function, String methodName) {
        return (Class[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.checkAndExtractMethods(function, methodName))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getParameterTypes(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Class.class))));
    }

    public SqlFunction createScalarSqlFunction(FunctionIdentifier identifier, String displayName, ScalarFunction function, FlinkTypeFactory typeFactory) {
        return new ScalarSqlFunction(identifier, displayName, function, typeFactory, ScalarSqlFunction$.MODULE$.$lessinit$greater$default$5());
    }

    public TableSqlFunction createTableSqlFunction(FunctionIdentifier identifier, String displayName, TableFunction<?> tableFunction, DataType implicitResultType, FlinkTypeFactory typeFactory) {
        DeferredTypeFlinkTableFunction function = new DeferredTypeFlinkTableFunction(tableFunction, implicitResultType);
        return new TableSqlFunction(identifier, displayName, tableFunction, implicitResultType, typeFactory, function, TableSqlFunction$.MODULE$.$lessinit$greater$default$7());
    }

    public SqlFunction createAggregateSqlFunction(FunctionIdentifier identifier, String displayName, AggregateFunction<?, ?> aggFunction, DataType externalResultType, DataType externalAccType, FlinkTypeFactory typeFactory) {
        this.checkAndExtractMethods((UserDefinedFunction)aggFunction, "accumulate");
        return AggSqlFunction$.MODULE$.apply(identifier, displayName, (ImperativeAggregateFunction<?, ?>)aggFunction, externalResultType, externalAccType, typeFactory, aggFunction.getRequirements().contains(FunctionRequirement.OVER_WINDOW_ONLY));
    }

    public DataType getResultTypeOfAggregateFunction(ImperativeAggregateFunction<?, ?> userDefinedAggregateFunction, DataType extractedType) {
        DataType dataType;
        TypeInformation resultType = userDefinedAggregateFunction.getResultType();
        if (resultType != null) {
            dataType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)resultType);
        } else if (extractedType != null) {
            dataType = extractedType;
        } else {
            try {
                dataType = this.extractTypeFromAggregateFunction(userDefinedAggregateFunction, 0);
            }
            catch (InvalidTypesException ite) {
                throw new TableException("Cannot infer generic type of ${aggregateFunction.getClass}. You can override ImperativeAggregateFunction.getResultType() to specify the type.", (Throwable)ite);
            }
        }
        return dataType;
    }

    public DataType getResultTypeOfAggregateFunction$default$2() {
        return null;
    }

    public DataType getAccumulatorTypeOfAggregateFunction(ImperativeAggregateFunction<?, ?> userDefinedAggregateFunction, DataType extractedType) {
        DataType dataType;
        TypeInformation accType = userDefinedAggregateFunction.getAccumulatorType();
        if (accType != null) {
            dataType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)accType);
        } else if (extractedType != null) {
            dataType = extractedType;
        } else {
            try {
                dataType = this.extractTypeFromAggregateFunction(userDefinedAggregateFunction, 1);
            }
            catch (InvalidTypesException ite) {
                throw new TableException("Cannot infer generic type of ${aggregateFunction.getClass}. You can override ImperativeAggregateFunction.getAccumulatorType() to specify the type.", (Throwable)ite);
            }
        }
        return dataType;
    }

    public DataType getAccumulatorTypeOfAggregateFunction$default$2() {
        return null;
    }

    private DataType extractTypeFromAggregateFunction(ImperativeAggregateFunction<?, ?> aggregateFunction, int parameterTypePos) throws InvalidTypesException {
        return TypeConversions.fromLegacyInfoToDataType((TypeInformation)TypeExtractor.createTypeInfo(aggregateFunction, ImperativeAggregateFunction.class, (Class)aggregateFunction.getClass(), (int)parameterTypePos));
    }

    public DataType getResultTypeOfScalarFunction(ScalarFunction function, LogicalType[] argTypes) {
        TypeInformation userDefinedTypeInfo = function.getResultType((Class[])this.getEvalMethodSignature(function, argTypes));
        return userDefinedTypeInfo != null ? TypeConversions.fromLegacyInfoToDataType((TypeInformation)userDefinedTypeInfo) : this.extractTypeFromScalarFunc(function, argTypes);
    }

    public DataType extractTypeFromScalarFunc(ScalarFunction function, LogicalType[] argTypes) {
        DataType dataType;
        try {
            dataType = ClassDataTypeConverter.fromClassToDataType(this.getResultTypeClassOfScalarFunction(function, argTypes));
        }
        catch (InvalidTypesException invalidTypesException) {
            throw new ValidationException(new StringBuilder(111).append("Return type of scalar function '").append(function.getClass().getCanonicalName()).append("' cannot be ").append("automatically determined. Please provide type information manually.").toString());
        }
        return dataType;
    }

    public Class<?> getResultTypeClassOfScalarFunction(ScalarFunction function, LogicalType[] argTypes) {
        return ((Method)this.getEvalUserDefinedMethod(function, (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])argTypes)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Given signature is invalid.");
        })).getReturnType();
    }

    public Tuple3<String[], int[], LogicalType[]> getFieldInfo(DataType inputType) {
        TypeInformation inputTypeInfo = TypeInfoDataTypeConverter.fromDataTypeToTypeInfo((DataType)inputType);
        return new Tuple3((Object)FieldInfoUtils.getFieldNames((TypeInformation)inputTypeInfo), (Object)FieldInfoUtils.getFieldIndices((TypeInformation)inputTypeInfo), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])FieldInfoUtils.getFieldTypes((TypeInformation)inputTypeInfo))).map((Function1 & Serializable & scala.Serializable)x$1 -> TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType((TypeInformation)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class))));
    }

    public String signatureToString(Class<?>[] signature) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signature)).map((Function1 & Serializable & scala.Serializable)clazz -> clazz == null ? "null" : clazz.getCanonicalName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("(", ", ", ")");
    }

    public String signatureInternalToString(Seq<LogicalType> signature) {
        return this.signatureToString(this.logicalTypesToExternalClasses(signature));
    }

    public String signatureToString(Seq<DataType> signature) {
        return this.signatureToString(this.typesToClasses(signature));
    }

    public String signaturesToString(UserDefinedFunction function, String name) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getMethodSignatures(function, name))).map((Function1 & Serializable & scala.Serializable)signature -> MODULE$.signatureToString((Class<?>[])signature), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
    }

    public Class<?>[] typesToClasses(Seq<DataType> types) {
        return (Class[])((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)t -> t == null ? null : t.getConversionClass(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class));
    }

    public Class<?>[] logicalTypesToExternalClasses(Seq<LogicalType> types) {
        return (Class[])((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)t -> t == null ? null : ClassLogicalTypeConverter.getDefaultExternalClassForType((LogicalType)t), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class));
    }

    public Class<?>[] logicalTypesToInternalClasses(Seq<LogicalType> types) {
        return (Class[])((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)t -> t == null ? null : LogicalTypeUtils.toInternalConversionClass((LogicalType)t), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parameterClassEquals(Class<?> candidate, Class<?> expected) {
        if (candidate == null) return true;
        Class<?> clazz = candidate;
        Class<?> clazz2 = expected;
        if (clazz == null) {
            if (clazz2 == null) return true;
        } else if (clazz.equals(clazz2)) return true;
        Class<?> clazz3 = expected;
        Class<Object> clazz4 = Object.class;
        if (clazz3 == null) {
            if (clazz4 == null) return true;
        } else if (clazz3.equals(clazz4)) return true;
        Class<?> clazz5 = candidate;
        Class<Object> clazz6 = Object.class;
        if (clazz5 == null) {
            if (clazz6 == null) return true;
        } else if (clazz5.equals(clazz6)) return true;
        if (expected.isPrimitive()) {
            Class<?> clazz7 = Primitives.wrap(expected);
            Class<?> clazz8 = candidate;
            if (clazz7 == null) {
                if (clazz8 == null) return true;
            } else if (clazz7.equals(clazz8)) return true;
        }
        Class<?> clazz9 = candidate;
        Class<Date> clazz10 = Date.class;
        if (!(clazz9 != null ? !clazz9.equals(clazz10) : clazz10 != null)) {
            Class<?> clazz11 = expected;
            Class<Integer> clazz12 = Integer.TYPE;
            if (clazz11 == null) {
                if (clazz12 == null) return true;
            } else if (clazz11.equals(clazz12)) return true;
            Class<?> clazz13 = expected;
            Class<Integer> clazz14 = Integer.class;
            if (clazz13 == null) {
                if (clazz14 == null) return true;
            } else if (clazz13.equals(clazz14)) return true;
        }
        Class<?> clazz15 = candidate;
        Class<Time> clazz16 = Time.class;
        if (!(clazz15 != null ? !clazz15.equals(clazz16) : clazz16 != null)) {
            Class<?> clazz17 = expected;
            Class<Integer> clazz18 = Integer.TYPE;
            if (clazz17 == null) {
                if (clazz18 == null) return true;
            } else if (clazz17.equals(clazz18)) return true;
            Class<?> clazz19 = expected;
            Class<Integer> clazz20 = Integer.class;
            if (clazz19 == null) {
                if (clazz20 == null) return true;
            } else if (clazz19.equals(clazz20)) return true;
        }
        Class<?> clazz21 = candidate;
        Class<StringData> clazz22 = StringData.class;
        if (!(clazz21 != null ? !clazz21.equals(clazz22) : clazz22 != null)) {
            Class<?> clazz23 = expected;
            Class<String> clazz24 = String.class;
            if (clazz23 == null) {
                if (clazz24 == null) return true;
            } else if (clazz23.equals(clazz24)) return true;
        }
        Class<?> clazz25 = candidate;
        Class<String> clazz26 = String.class;
        if (!(clazz25 != null ? !clazz25.equals(clazz26) : clazz26 != null)) {
            Class<?> clazz27 = expected;
            Class<StringData> clazz28 = StringData.class;
            if (clazz27 == null) {
                if (clazz28 == null) return true;
            } else if (clazz27.equals(clazz28)) return true;
        }
        Class<?> clazz29 = candidate;
        Class<TimestampData> clazz30 = TimestampData.class;
        if (!(clazz29 != null ? !clazz29.equals(clazz30) : clazz30 != null)) {
            Class<?> clazz31 = expected;
            Class<LocalDateTime> clazz32 = LocalDateTime.class;
            if (clazz31 == null) {
                if (clazz32 == null) return true;
            } else if (clazz31.equals(clazz32)) return true;
        }
        Class<?> clazz33 = candidate;
        Class<Timestamp> clazz34 = Timestamp.class;
        if (!(clazz33 != null ? !clazz33.equals(clazz34) : clazz34 != null)) {
            Class<?> clazz35 = expected;
            Class<TimestampData> clazz36 = TimestampData.class;
            if (clazz35 == null) {
                if (clazz36 == null) return true;
            } else if (clazz35.equals(clazz36)) return true;
        }
        Class<?> clazz37 = candidate;
        Class<TimestampData> clazz38 = TimestampData.class;
        if (!(clazz37 != null ? !clazz37.equals(clazz38) : clazz38 != null)) {
            Class<?> clazz39 = expected;
            Class<Timestamp> clazz40 = Timestamp.class;
            if (clazz39 == null) {
                if (clazz40 == null) return true;
            } else if (clazz39.equals(clazz40)) return true;
        }
        Class<?> clazz41 = candidate;
        Class<LocalDateTime> clazz42 = LocalDateTime.class;
        if (!(clazz41 != null ? !clazz41.equals(clazz42) : clazz42 != null)) {
            Class<?> clazz43 = expected;
            Class<TimestampData> clazz44 = TimestampData.class;
            if (clazz43 == null) {
                if (clazz44 == null) return true;
            } else if (clazz43.equals(clazz44)) return true;
        }
        Class<?> clazz45 = candidate;
        Class<TimestampData> clazz46 = TimestampData.class;
        if (!(clazz45 != null ? !clazz45.equals(clazz46) : clazz46 != null)) {
            Class<?> clazz47 = expected;
            Class<Instant> clazz48 = Instant.class;
            if (clazz47 == null) {
                if (clazz48 == null) return true;
            } else if (clazz47.equals(clazz48)) return true;
        }
        Class<?> clazz49 = candidate;
        Class<Instant> clazz50 = Instant.class;
        if (!(clazz49 != null ? !clazz49.equals(clazz50) : clazz50 != null)) {
            Class<?> clazz51 = expected;
            Class<TimestampData> clazz52 = TimestampData.class;
            if (clazz51 == null) {
                if (clazz52 == null) return true;
            } else if (clazz51.equals(clazz52)) return true;
        }
        if (RowData.class.isAssignableFrom(candidate)) {
            Class<?> clazz53 = expected;
            Class<Row> clazz54 = Row.class;
            if (clazz53 == null) {
                if (clazz54 == null) return true;
            } else if (clazz53.equals(clazz54)) return true;
        }
        Class<?> clazz55 = candidate;
        Class<Row> clazz56 = Row.class;
        if (!(clazz55 != null ? !clazz55.equals(clazz56) : clazz56 != null)) {
            if (RowData.class.isAssignableFrom(expected)) return true;
        }
        if (RowData.class.isAssignableFrom(candidate)) {
            Class<?> clazz57 = expected;
            Class<RowData> clazz58 = RowData.class;
            if (clazz57 == null) {
                if (clazz58 == null) return true;
            } else if (clazz57.equals(clazz58)) return true;
        }
        Class<?> clazz59 = candidate;
        Class<RowData> clazz60 = RowData.class;
        if (!(clazz59 != null ? !clazz59.equals(clazz60) : clazz60 != null)) {
            if (RowData.class.isAssignableFrom(expected)) return true;
        }
        Class<?> clazz61 = candidate;
        Class<DecimalData> clazz62 = DecimalData.class;
        if (!(clazz61 != null ? !clazz61.equals(clazz62) : clazz62 != null)) {
            Class<?> clazz63 = expected;
            Class<BigDecimal> clazz64 = BigDecimal.class;
            if (clazz63 == null) {
                if (clazz64 == null) return true;
            } else if (clazz63.equals(clazz64)) return true;
        }
        Class<?> clazz65 = candidate;
        Class<BigDecimal> clazz66 = BigDecimal.class;
        if (!(clazz65 != null ? !clazz65.equals(clazz66) : clazz66 != null)) {
            Class<?> clazz67 = expected;
            Class<DecimalData> clazz68 = DecimalData.class;
            if (clazz67 == null) {
                if (clazz68 == null) return true;
            } else if (clazz67.equals(clazz68)) return true;
        }
        if (!candidate.isArray()) return false;
        if (!expected.isArray()) return false;
        if (!(candidate.getComponentType() instanceof Object)) return false;
        Class<?> clazz69 = expected.getComponentType();
        Class<Object> clazz70 = Object.class;
        if (clazz69 != null) {
            if (!clazz69.equals(clazz70)) return false;
            return true;
        }
        if (clazz70 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parameterDataTypeEquals(LogicalType internal, DataType parameterType) {
        LogicalType paraInternalType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)parameterType);
        if (TypeCheckUtils.isRaw((LogicalType)internal) && TypeCheckUtils.isRaw((LogicalType)paraInternalType)) {
            Class clazz = ClassLogicalTypeConverter.getDefaultExternalClassForType((LogicalType)internal);
            Class clazz2 = ClassLogicalTypeConverter.getDefaultExternalClassForType((LogicalType)paraInternalType);
            if (clazz != null) {
                if (!clazz.equals(clazz2)) return false;
                return true;
            }
            if (clazz2 == null) return true;
            return false;
        }
        LogicalType logicalType = paraInternalType;
        LogicalType logicalType2 = internal;
        if (logicalType == null) {
            if (logicalType2 == null) return true;
        } else if (logicalType.equals(logicalType2)) return true;
        Class clazz = LogicalTypeUtils.toInternalConversionClass((LogicalType)internal);
        Class clazz3 = LogicalTypeUtils.toInternalConversionClass((LogicalType)paraInternalType);
        if (clazz != null) {
            if (!clazz.equals(clazz3)) return false;
            return true;
        }
        if (clazz3 == null) return true;
        return false;
    }

    public LogicalType[] getOperandTypeArray(SqlOperatorBinding callBinding) {
        return (LogicalType[])this.getOperandType(callBinding).toArray(ClassTag$.MODULE$.apply(LogicalType.class));
    }

    public Seq<LogicalType> getOperandType(SqlOperatorBinding callBinding) {
        IndexedSeq operandTypes = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), callBinding.getOperandCount()).map((Function1 & Serializable & scala.Serializable)i -> callBinding.getOperandType(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return (Seq)operandTypes.map((Function1 & Serializable & scala.Serializable)operandType -> {
            SqlTypeName sqlTypeName = operandType.getSqlTypeName();
            SqlTypeName sqlTypeName2 = SqlTypeName.NULL;
            return !(sqlTypeName != null ? !((Object)((Object)sqlTypeName)).equals((Object)sqlTypeName2) : sqlTypeName2 != null) ? null : FlinkTypeFactory$.MODULE$.toLogicalType((RelDataType)operandType);
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Object[] transformRexNodes(List<RexNode> rexNodes) {
        return (Object[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexNodes).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Integer n;
            RexNode rexNode = x0$6;
            if (rexNode instanceof RexLiteral) {
                RexLiteral rexLiteral = (RexLiteral)rexNode;
                Object value = rexLiteral.getValue2();
                SqlTypeName sqlTypeName = rexLiteral.getType().getSqlTypeName();
                Object object = ((Object)((Object)SqlTypeName.INTEGER)).equals((Object)sqlTypeName) ? BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToLong((Object)value))) : (((Object)((Object)SqlTypeName.SMALLINT)).equals((Object)sqlTypeName) ? BoxesRunTime.boxToShort((short)((short)BoxesRunTime.unboxToLong((Object)value))) : (((Object)((Object)SqlTypeName.TINYINT)).equals((Object)sqlTypeName) ? BoxesRunTime.boxToByte((byte)((byte)BoxesRunTime.unboxToLong((Object)value))) : (((Object)((Object)SqlTypeName.FLOAT)).equals((Object)sqlTypeName) ? BoxesRunTime.boxToFloat((float)((float)BoxesRunTime.unboxToDouble((Object)value))) : (((Object)((Object)SqlTypeName.REAL)).equals((Object)sqlTypeName) ? BoxesRunTime.boxToFloat((float)((float)BoxesRunTime.unboxToDouble((Object)value))) : value))));
                n = object;
            } else {
                n = null;
            }
            return n;
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef());
    }

    public RelDataType buildRelDataType(RelDataTypeFactory typeFactory, LogicalType resultType, String[] fieldNames, int[] fieldIndexes) {
        LogicalType[] logicalTypeArray;
        if (fieldIndexes.length != fieldNames.length) {
            throw new TableException("Number of field indexes and field names must be equal.");
        }
        if (fieldNames.length != new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).toSet().size()) {
            throw new TableException("Table field names must be unique.");
        }
        LogicalType logicalType = resultType;
        if (logicalType instanceof RowType) {
            RowType rowType = (RowType)logicalType;
            if (fieldNames.length != rowType.getFieldCount()) {
                throw new TableException(new StringBuilder(53).append("Arity of type (").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rowType.getFieldNames().toArray())).deep()).append(") ").append("not equal to number of field names ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).deep()).append(".").toString());
            }
            logicalTypeArray = (LogicalType[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(fieldIndexes)).map((Function1 & Serializable & scala.Serializable)i -> rowType.getTypeAt(BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
        } else {
            if (fieldIndexes.length != 1 || fieldIndexes[0] != 0) {
                throw new TableException("Non-composite input type may have only a single field and its index must be 0.");
            }
            logicalTypeArray = (LogicalType[])((Object[])new LogicalType[]{resultType});
        }
        LogicalType[] fieldTypes = logicalTypeArray;
        FlinkTypeFactory flinkTypeFactory = (FlinkTypeFactory)typeFactory;
        RelDataTypeFactory.FieldInfoBuilder builder = flinkTypeFactory.builder();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)f -> builder.add((String)f._1(), flinkTypeFactory.createFieldTypeFromLogicalType((LogicalType)f._2())));
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public <T> TypeInformation<T> extractResultTypeFromTableFunction(TableFunction<T> tf) {
        void var2_2;
        GenericTypeInfo genericTypeInfo;
        try {
            genericTypeInfo = TypeExtractor.createTypeInfo(tf, TableFunction.class, (Class)tf.getClass(), (int)0);
        }
        catch (InvalidTypesException invalidTypesException) {
            genericTypeInfo = new GenericTypeInfo(Object.class);
        }
        GenericTypeInfo implicitResultType = genericTypeInfo;
        return var2_2;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$getParamClassesConsiderVarArgs$1(boolean isVarArgs$1, Class[] matchingSignature$1, ObjectRef paramClasses$1, int i) {
        return i < matchingSignature$1.length - 1 ? ((ArrayBuffer)paramClasses$1.elem).$plus$eq((Object)matchingSignature$1[i]) : (isVarArgs$1 ? ((ArrayBuffer)paramClasses$1.elem).$plus$eq(((Class)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matchingSignature$1)).last()).getComponentType()) : ((ArrayBuffer)paramClasses$1.elem).$plus$eq(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matchingSignature$1)).last()));
    }

    public static final /* synthetic */ boolean $anonfun$getUserDefinedMethod$5(Class[] methodSignature$1, LogicalType[] internalTypes$1, Function2 parameterClassEquals$1, Function2 parameterDataTypeEquals$1, IntRef applyCnt$1, DataType[] dataTypes$1, Tuple2 x0$3) {
        int i;
        Class clazz;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            clazz = (Class)tuple2._1();
            i = tuple2._2$mcI$sp();
            Class clazz2 = methodSignature$1[i];
            Class<Object> clazz3 = Object.class;
            if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                ++applyCnt$1.elem;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl = BoxesRunTime.unboxToBoolean((Object)parameterClassEquals$1.apply((Object)methodSignature$1[i], (Object)clazz)) || BoxesRunTime.unboxToBoolean((Object)parameterDataTypeEquals$1.apply((Object)internalTypes$1[i], (Object)dataTypes$1[i]));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getUserDefinedMethod$6(LogicalType[] internalTypes$1, Function2 parameterClassEquals$1, Function2 parameterDataTypeEquals$1, Class[] signatures$1, DataType[] dataTypes$2, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            Class clazz = (Class)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (i < signatures$1.length - 1) {
                if (BoxesRunTime.unboxToBoolean((Object)parameterClassEquals$1.apply((Object)clazz, (Object)signatures$1[i]))) return true;
                if (!BoxesRunTime.unboxToBoolean((Object)parameterDataTypeEquals$1.apply((Object)internalTypes$1[i], (Object)dataTypes$2[i]))) return false;
                return true;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Class clazz = (Class)tuple2._1();
        int i = tuple2._2$mcI$sp();
        if (i < signatures$1.length - 1) throw new MatchError((Object)tuple2);
        if (BoxesRunTime.unboxToBoolean((Object)parameterClassEquals$1.apply((Object)clazz, ((Class)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signatures$1)).last()).getComponentType()))) return true;
        if (!BoxesRunTime.unboxToBoolean((Object)parameterDataTypeEquals$1.apply((Object)internalTypes$1[i], (Object)dataTypes$2[i]))) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getUserDefinedMethod$4(Class[] methodSignature$1, LogicalType[] internalTypes$1, Function1 parameterTypes$1, Function2 parameterClassEquals$1, Function2 parameterDataTypeEquals$1, IntRef applyCnt$1, Method x0$2) {
        boolean bl;
        Method method = x0$2;
        if (!method.isVarArgs()) {
            Class<?>[] signatures = method.getParameterTypes();
            DataType[] dataTypes = (DataType[])parameterTypes$1.apply(signatures);
            bl = methodSignature$1.length == signatures.length && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signatures)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.$anonfun$getUserDefinedMethod$5(methodSignature$1, internalTypes$1, parameterClassEquals$1, parameterDataTypeEquals$1, applyCnt$1, dataTypes, x0$3)));
        } else if (method.isVarArgs()) {
            Class[] signatures = method.getParameterTypes();
            DataType[] dataTypes = (DataType[])parameterTypes$1.apply(signatures);
            bl = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])methodSignature$1)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.$anonfun$getUserDefinedMethod$6(internalTypes$1, parameterClassEquals$1, parameterDataTypeEquals$1, signatures, dataTypes, x0$4))) || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])methodSignature$1)).isEmpty() && signatures.length == 1;
        } else {
            throw new MatchError((Object)method);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getUserDefinedMethod$7(Method x$3) {
        return !x$3.isVarArgs();
    }

    public static final /* synthetic */ boolean $anonfun$getUserDefinedMethod$8(int fixedMethodsCount$1, Method cur) {
        return fixedMethodsCount$1 > 0 && !cur.isVarArgs() || fixedMethodsCount$1 == 0 && cur.isVarArgs();
    }

    public static final /* synthetic */ boolean $anonfun$getUserDefinedMethod$9(Method cur) {
        return !Modifier.isVolatile(cur.getModifiers());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getUserDefinedMethod$11(Class[] methodSignature$1, LogicalType[] internalTypes$1, Function2 parameterClassEquals$1, Function2 parameterDataTypeEquals$1, Class[] signatures$2, DataType[] dataTypes$3, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            Class clazz = (Class)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (i < signatures$2.length - 1) {
                if (BoxesRunTime.unboxToBoolean((Object)parameterClassEquals$1.apply((Object)methodSignature$1[i], (Object)clazz))) return true;
                if (!BoxesRunTime.unboxToBoolean((Object)parameterDataTypeEquals$1.apply((Object)internalTypes$1[i], (Object)dataTypes$3[i]))) return false;
                return true;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Class clazz = (Class)tuple2._1();
        int i = tuple2._2$mcI$sp();
        if (i != signatures$2.length - 1) throw new MatchError((Object)tuple2);
        return clazz.getName().equals("scala.collection.Seq");
    }

    public static final /* synthetic */ boolean $anonfun$getUserDefinedMethod$10(Class[] methodSignature$1, LogicalType[] internalTypes$1, Function1 parameterTypes$1, Function2 parameterClassEquals$1, Function2 parameterDataTypeEquals$1, Method method) {
        Class[] signatures = method.getParameterTypes();
        DataType[] dataTypes = (DataType[])parameterTypes$1.apply(signatures);
        return !method.isVarArgs() && signatures.length != methodSignature$1.length ? false : (method.isVarArgs() && signatures.length > methodSignature$1.length + 1 ? false : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signatures)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionUtils$.$anonfun$getUserDefinedMethod$11(methodSignature$1, internalTypes$1, parameterClassEquals$1, parameterDataTypeEquals$1, signatures, dataTypes, x0$5))));
    }

    public static final /* synthetic */ boolean $anonfun$getUserDefinedMethod$12(Method m) {
        return !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])m.getParameterTypes())).contains(Object.class);
    }

    public static final /* synthetic */ boolean $anonfun$ifMethodExistInFunction$1(String method$1, Method m) {
        String string = m.getName();
        String string2 = method$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkAndExtractMethods$1(UserDefinedFunction function$2, String methodName$1, Method m) {
        int modifiers = m.getModifiers();
        String string = m.getName();
        String string2 = methodName$1;
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!Modifier.isPublic(modifiers)) return false;
        if (Modifier.isAbstract(modifiers)) return false;
        if (!(function$2 instanceof TableFunction)) return true;
        if (Modifier.isStatic(modifiers)) return false;
        return true;
    }

    private UserDefinedFunctionUtils$() {
        MODULE$ = this;
    }
}

