/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ConfigurationJsonSerializerFilter;
import org.apache.flink.table.planner.plan.nodes.exec.utils.TransformationMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.visitor.ExecNodeVisitor;
import org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class ExecNodeBase<T>
implements ExecNode<T> {
    @JacksonInject(value="isDeserialize")
    private boolean isCompiled;
    private final String description;
    private final LogicalType outputType;
    private final List<InputProperty> inputProperties;
    private List<ExecEdge> inputEdges;
    private transient Transformation<T> transformation;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private final ExecNodeContext context;
    @JsonProperty(value="configuration", access=JsonProperty.Access.WRITE_ONLY)
    private final ReadableConfig persistedConfig;

    @JsonProperty(value="type", access=JsonProperty.Access.READ_ONLY, index=1)
    protected final ExecNodeContext getContextFromAnnotation() {
        return ExecNodeContext.newContext(this.getClass()).withId(this.getId());
    }

    @JsonProperty(value="configuration", access=JsonProperty.Access.READ_ONLY, index=2)
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ConfigurationJsonSerializerFilter.class)
    public ReadableConfig getPersistedConfig() {
        return this.persistedConfig;
    }

    protected ExecNodeBase(int id, ExecNodeContext context, ReadableConfig persistedConfig, List<InputProperty> inputProperties, LogicalType outputType, String description) {
        this.context = ((ExecNodeContext)Preconditions.checkNotNull((Object)context)).withId(id);
        this.persistedConfig = persistedConfig == null ? new Configuration() : persistedConfig;
        this.inputProperties = (List)Preconditions.checkNotNull(inputProperties);
        this.outputType = (LogicalType)Preconditions.checkNotNull((Object)outputType);
        this.description = (String)Preconditions.checkNotNull((Object)description);
    }

    @Override
    public final int getId() {
        return this.context.getId();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public LogicalType getOutputType() {
        return this.outputType;
    }

    @Override
    public List<InputProperty> getInputProperties() {
        return this.inputProperties;
    }

    @Override
    public List<ExecEdge> getInputEdges() {
        return (List)Preconditions.checkNotNull(this.inputEdges, (String)"inputEdges should not null, please call `setInputEdges(List<ExecEdge>)` first.");
    }

    @Override
    public void setInputEdges(List<ExecEdge> inputEdges) {
        Preconditions.checkNotNull(inputEdges, (String)"inputEdges should not be null.");
        this.inputEdges = new ArrayList<ExecEdge>(inputEdges);
    }

    @Override
    public void replaceInputEdge(int index, ExecEdge newInputEdge) {
        List<ExecEdge> edges = this.getInputEdges();
        Preconditions.checkArgument((index >= 0 && index < edges.size() ? 1 : 0) != 0);
        edges.set(index, newInputEdge);
    }

    @Override
    public final Transformation<T> translateToPlan(Planner planner) {
        if (this.transformation == null) {
            this.transformation = this.translateToPlanInternal((PlannerBase)planner, ExecNodeConfig.of(((PlannerBase)planner).getTableConfig(), this.persistedConfig, this.isCompiled));
            if (this instanceof SingleTransformationTranslator && this.inputsContainSingleton()) {
                this.transformation.setParallelism(1);
                this.transformation.setMaxParallelism(1);
            }
        }
        return this.transformation;
    }

    @Override
    public void accept(ExecNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setCompiled(boolean compiled) {
        this.isCompiled = compiled;
    }

    protected abstract Transformation<T> translateToPlanInternal(PlannerBase var1, ExecNodeConfig var2);

    protected boolean inputsContainSingleton() {
        return this.getInputProperties().stream().anyMatch(p -> p.getRequiredDistribution().getType() == InputProperty.DistributionType.SINGLETON);
    }

    @JsonIgnore
    protected String getSimplifiedName() {
        return this.getClass().getSimpleName().replace("StreamExec", "").replace("BatchExec", "");
    }

    protected String createTransformationUid(String operatorName, ExecNodeConfig config) {
        return this.context.generateUid(operatorName, config);
    }

    protected String createTransformationName(ReadableConfig config) {
        return this.createFormattedTransformationName(this.getDescription(), this.getSimplifiedName(), config);
    }

    protected String createTransformationDescription(ReadableConfig config) {
        return this.createFormattedTransformationDescription(this.getDescription(), config);
    }

    protected TransformationMetadata createTransformationMeta(String operatorName, ExecNodeConfig config) {
        if (ExecNodeMetadataUtil.isUnsupported(this.getClass()) || !config.shouldSetUid()) {
            return new TransformationMetadata(this.createTransformationName(config), this.createTransformationDescription(config));
        }
        return new TransformationMetadata(this.createTransformationUid(operatorName, config), this.createTransformationName(config), this.createTransformationDescription(config));
    }

    protected TransformationMetadata createTransformationMeta(String operatorName, String detailName, String simplifiedName, ExecNodeConfig config) {
        String name = this.createFormattedTransformationName(detailName, simplifiedName, config);
        String desc = this.createFormattedTransformationDescription(detailName, config);
        if (ExecNodeMetadataUtil.isUnsupported(this.getClass()) || !config.shouldSetUid()) {
            return new TransformationMetadata(name, desc);
        }
        return new TransformationMetadata(this.createTransformationUid(operatorName, config), name, desc);
    }

    protected String createFormattedTransformationDescription(String description, ReadableConfig config) {
        if (((Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_SIMPLIFY_OPERATOR_NAME_ENABLED)).booleanValue()) {
            return String.format("[%d]:%s", this.getId(), description);
        }
        return description;
    }

    protected String createFormattedTransformationName(String detailName, String simplifiedName, ReadableConfig config) {
        if (((Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_SIMPLIFY_OPERATOR_NAME_ENABLED)).booleanValue()) {
            return String.format("%s[%d]", simplifiedName, this.getId());
        }
        return detailName;
    }

    public void resetTransformation() {
        this.transformation = null;
    }

    @JsonIgnore
    @VisibleForTesting
    public Transformation<T> getTransformation() {
        return this.transformation;
    }
}

