/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonPointer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;

@Internal
final class ContextResolvedTableJsonDeserializer
extends StdDeserializer<ContextResolvedTable> {
    private static final long serialVersionUID = 1L;
    private static final JsonPointer optionsPointer = JsonPointer.compile((String)"/resolvedTable/options");

    ContextResolvedTableJsonDeserializer() {
        super(ContextResolvedTable.class);
    }

    public ContextResolvedTable deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        ResolvedSchema schemaFromCatalog;
        ResolvedSchema schemaFromPlan;
        TableConfigOptions.CatalogPlanRestore planRestoreOption = (TableConfigOptions.CatalogPlanRestore)SerdeContext.get((DatabindContext)ctx).getConfiguration().get(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS);
        CatalogManager catalogManager = SerdeContext.get((DatabindContext)ctx).getFlinkContext().getCatalogManager();
        ObjectNode objectNode = (ObjectNode)jsonParser.readValueAsTree();
        ObjectIdentifier identifier = JsonSerdeUtil.deserializeOptionalField(objectNode, "identifier", ObjectIdentifier.class, jsonParser.getCodec(), ctx).orElse(null);
        ResolvedCatalogTable resolvedCatalogTable = JsonSerdeUtil.deserializeOptionalField(objectNode, "resolvedTable", ResolvedCatalogTable.class, jsonParser.getCodec(), ctx).orElse(null);
        if (identifier == null && resolvedCatalogTable == null) {
            throw new TableException(String.format("The input JSON is invalid because it does neither contain '%s' nor '%s'.", "identifier", "resolvedTable"));
        }
        if (identifier == null) {
            return ContextResolvedTable.anonymous((ResolvedCatalogBaseTable)resolvedCatalogTable);
        }
        Optional contextResolvedTableFromCatalog = catalogManager.getTable(identifier);
        if ((resolvedCatalogTable == null || objectNode.at(optionsPointer).isMissingNode()) && this.isPlanEnforced(planRestoreOption) && contextResolvedTableFromCatalog.map(ContextResolvedTable::isPermanent).orElse(false).booleanValue()) {
            throw ContextResolvedTableJsonDeserializer.lookupDisabled(identifier);
        }
        if (contextResolvedTableFromCatalog.isPresent() && resolvedCatalogTable != null && !this.areResolvedSchemasEqual(schemaFromPlan = resolvedCatalogTable.getResolvedSchema(), schemaFromCatalog = ((ContextResolvedTable)contextResolvedTableFromCatalog.get()).getResolvedSchema())) {
            throw ContextResolvedTableJsonDeserializer.schemaNotMatching(identifier, schemaFromPlan, schemaFromCatalog);
        }
        if (resolvedCatalogTable == null || this.isLookupForced(planRestoreOption)) {
            return (ContextResolvedTable)contextResolvedTableFromCatalog.orElseThrow(() -> ContextResolvedTableJsonDeserializer.missingTableFromCatalog(identifier, this.isLookupForced(planRestoreOption)));
        }
        if (contextResolvedTableFromCatalog.isPresent()) {
            if (objectNode.at(optionsPointer).isMissingNode()) {
                return (ContextResolvedTable)contextResolvedTableFromCatalog.get();
            }
            return contextResolvedTableFromCatalog.flatMap(ContextResolvedTable::getCatalog).map(c -> ContextResolvedTable.permanent((ObjectIdentifier)identifier, (Catalog)c, (ResolvedCatalogBaseTable)resolvedCatalogTable)).orElseGet(() -> ContextResolvedTable.temporary((ObjectIdentifier)identifier, (ResolvedCatalogBaseTable)resolvedCatalogTable));
        }
        return ContextResolvedTable.temporary((ObjectIdentifier)identifier, (ResolvedCatalogBaseTable)resolvedCatalogTable);
    }

    private boolean areResolvedSchemasEqual(ResolvedSchema schemaFromPlan, ResolvedSchema schemaFromCatalog) {
        List columnsFromPlan = schemaFromPlan.getColumns();
        List columnsFromCatalog = schemaFromCatalog.getColumns();
        if (columnsFromPlan.size() != columnsFromCatalog.size()) {
            return false;
        }
        for (int i = 0; i < columnsFromPlan.size(); ++i) {
            Column columnFromPlan = (Column)columnsFromPlan.get(i);
            Column columnFromCatalog = (Column)columnsFromCatalog.get(i);
            if (Objects.equals(columnFromPlan.getName(), columnFromCatalog.getName()) && Objects.equals(columnFromPlan.getClass(), columnFromCatalog.getClass()) && Objects.equals(columnFromPlan.getDataType(), columnFromCatalog.getDataType())) continue;
            return false;
        }
        return Objects.equals(schemaFromPlan.getPrimaryKey(), schemaFromCatalog.getPrimaryKey());
    }

    private boolean isLookupForced(TableConfigOptions.CatalogPlanRestore planRestoreOption) {
        return planRestoreOption == TableConfigOptions.CatalogPlanRestore.IDENTIFIER;
    }

    private boolean isPlanEnforced(TableConfigOptions.CatalogPlanRestore planRestoreOption) {
        return planRestoreOption == TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED;
    }

    static TableException lookupDisabled(ObjectIdentifier objectIdentifier) {
        return new TableException(String.format("The persisted plan does not include all required catalog metadata for table '%s'. However, lookup is disabled because option '%s' = '%s'. Either enable the catalog lookup with '%s' = '%s' / '%s' or regenerate the plan with '%s' = '%s'. Make sure the table is not compiled as a temporary table.", objectIdentifier.asSummaryString(), TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED.name(), TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanRestore.IDENTIFIER.name(), TableConfigOptions.CatalogPlanRestore.ALL.name(), TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanCompilation.ALL.name()));
    }

    static TableException schemaNotMatching(ObjectIdentifier objectIdentifier, ResolvedSchema schemaFromPlan, ResolvedSchema schemaFromCatalog) {
        return new TableException(String.format("The schema of table '%s' from the persisted plan does not match the schema loaded from the catalog: '%s' != '%s'. Make sure the table schema in the catalog is still identical.", objectIdentifier.asSummaryString(), schemaFromPlan, schemaFromCatalog));
    }

    static TableException missingTableFromCatalog(ObjectIdentifier identifier, boolean forcedLookup) {
        String initialReason = forcedLookup ? String.format("Cannot resolve table '%s' and catalog lookup is forced because '%s' = '%s'. ", identifier.asSummaryString(), TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanRestore.IDENTIFIER.name()) : String.format("Cannot resolve table '%s' and the persisted plan does not include all required catalog table metadata. ", identifier.asSummaryString());
        return new TableException(initialReason + String.format("Make sure a registered catalog contains the table when restoring or the table is available as a temporary table. Otherwise regenerate the plan with '%s' != '%s' and make sure the table was not compiled as a temporary table.", TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanCompilation.IDENTIFIER.name()));
    }
}

