/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.stream.IntStream;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.planner.codegen.sort.SortCodeGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.utils.SortUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.SortMergeJoinFunction;
import org.apache.flink.table.types.logical.RowType;

public class SorMergeJoinOperatorUtil {
    public static SortMergeJoinFunction getSortMergeJoinFunction(ClassLoader classLoader, ExecNodeConfig config, FlinkJoinType joinType, RowType leftType, RowType rightType, int[] leftKeys, int[] rightKeys, RowType keyType, boolean leftIsSmaller, boolean[] filterNulls, GeneratedJoinCondition condFunc, double externalBufferMemRatio) {
        int[] keyPositions = IntStream.range(0, leftKeys.length).toArray();
        SortCodeGenerator leftSortGen = SortUtil.newSortGen(config, classLoader, leftKeys, leftType);
        SortCodeGenerator rightSortGen = SortUtil.newSortGen(config, classLoader, rightKeys, rightType);
        return new SortMergeJoinFunction(externalBufferMemRatio, joinType, leftIsSmaller, condFunc, ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, classLoader), "SMJProjection", leftType, keyType, leftKeys), ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, classLoader), "SMJProjection", rightType, keyType, rightKeys), leftSortGen.generateNormalizedKeyComputer("LeftComputer"), leftSortGen.generateRecordComparator("LeftComparator"), rightSortGen.generateNormalizedKeyComputer("RightComputer"), rightSortGen.generateRecordComparator("RightComparator"), SortUtil.newSortGen(config, classLoader, keyPositions, keyType).generateRecordComparator("KeyComparator"), filterNulls);
    }

    private SorMergeJoinOperatorUtil() {
    }
}

