/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.TimeZone;
import org.apache.flink.table.data.TimestampData;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TimestampDataTest {
    @Test
    public void testNormal() {
        Assertions.assertThat((long)TimestampData.fromEpochMillis((long)1123L).getMillisecond()).isEqualTo(1123L);
        Assertions.assertThat((long)TimestampData.fromEpochMillis((long)-1123L).getMillisecond()).isEqualTo(-1123L);
        Assertions.assertThat((long)TimestampData.fromEpochMillis((long)1123L, (int)45678).getMillisecond()).isEqualTo(1123L);
        Assertions.assertThat((int)TimestampData.fromEpochMillis((long)1123L, (int)45678).getNanoOfMillisecond()).isEqualTo(45678);
        Assertions.assertThat((long)TimestampData.fromEpochMillis((long)-1123L, (int)45678).getMillisecond()).isEqualTo(-1123L);
        Assertions.assertThat((int)TimestampData.fromEpochMillis((long)-1123L, (int)45678).getNanoOfMillisecond()).isEqualTo(45678);
        Timestamp t19 = Timestamp.valueOf("1969-01-02 00:00:00.123456789");
        Timestamp t16 = Timestamp.valueOf("1969-01-02 00:00:00.123456");
        Timestamp t13 = Timestamp.valueOf("1969-01-02 00:00:00.123");
        Timestamp t10 = Timestamp.valueOf("1969-01-02 00:00:00");
        Assertions.assertThat((Date)TimestampData.fromTimestamp((Timestamp)t19).toTimestamp()).isEqualTo((Object)t19);
        Assertions.assertThat((Date)TimestampData.fromTimestamp((Timestamp)t16).toTimestamp()).isEqualTo((Object)t16);
        Assertions.assertThat((Date)TimestampData.fromTimestamp((Timestamp)t13).toTimestamp()).isEqualTo((Object)t13);
        Assertions.assertThat((Date)TimestampData.fromTimestamp((Timestamp)t10).toTimestamp()).isEqualTo((Object)t10);
        Timestamp t2 = Timestamp.valueOf("1979-01-02 00:00:00.123456");
        Assertions.assertThat((Date)TimestampData.fromTimestamp((Timestamp)t2).toTimestamp()).isEqualTo((Object)t2);
        Timestamp t3 = new Timestamp(1572333940000L);
        Assertions.assertThat((Date)TimestampData.fromTimestamp((Timestamp)t3).toTimestamp()).isEqualTo((Object)t3);
        LocalDateTime ldt19 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123456789);
        LocalDateTime ldt16 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123456000);
        LocalDateTime ldt13 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123000000);
        LocalDateTime ldt10 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 0);
        Assertions.assertThat((LocalDateTime)TimestampData.fromLocalDateTime((LocalDateTime)ldt19).toLocalDateTime()).isEqualTo((Object)ldt19);
        Assertions.assertThat((LocalDateTime)TimestampData.fromLocalDateTime((LocalDateTime)ldt16).toLocalDateTime()).isEqualTo((Object)ldt16);
        Assertions.assertThat((LocalDateTime)TimestampData.fromLocalDateTime((LocalDateTime)ldt13).toLocalDateTime()).isEqualTo((Object)ldt13);
        Assertions.assertThat((LocalDateTime)TimestampData.fromLocalDateTime((LocalDateTime)ldt10).toLocalDateTime()).isEqualTo((Object)ldt10);
        LocalDateTime ldt2 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 0);
        Assertions.assertThat((LocalDateTime)TimestampData.fromLocalDateTime((LocalDateTime)ldt2).toLocalDateTime()).isEqualTo((Object)ldt2);
        LocalDateTime ldt3 = LocalDateTime.of(1989, 1, 2, 0, 0, 0, 123456789);
        Assertions.assertThat((LocalDateTime)TimestampData.fromLocalDateTime((LocalDateTime)ldt3).toLocalDateTime()).isEqualTo((Object)ldt3);
        LocalDateTime ldt4 = LocalDateTime.of(1989, 1, 2, 0, 0, 0, 123456789);
        Timestamp t4 = Timestamp.valueOf(ldt4);
        Assertions.assertThat((Comparable)TimestampData.fromTimestamp((Timestamp)t4)).isEqualTo((Object)TimestampData.fromLocalDateTime((LocalDateTime)ldt4));
        Instant instant1 = Instant.ofEpochMilli(123L);
        Instant instant2 = Instant.ofEpochSecond(0L, 123456789L);
        Instant instant3 = Instant.ofEpochSecond(-2L, 123456789L);
        Assertions.assertThat((Instant)TimestampData.fromInstant((Instant)instant1).toInstant()).isEqualTo((Object)instant1);
        Assertions.assertThat((Instant)TimestampData.fromInstant((Instant)instant2).toInstant()).isEqualTo((Object)instant2);
        Assertions.assertThat((Instant)TimestampData.fromInstant((Instant)instant3).toInstant()).isEqualTo((Object)instant3);
    }

    @Test
    public void testDaylightSavingTime() {
        TimeZone tz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
        Timestamp dstBegin2018 = Timestamp.valueOf("2018-03-11 03:00:00");
        Assertions.assertThat((Date)TimestampData.fromTimestamp((Timestamp)dstBegin2018).toTimestamp()).isEqualTo((Object)dstBegin2018);
        Timestamp dstBegin2019 = Timestamp.valueOf("2019-03-10 02:00:00");
        Assertions.assertThat((Date)TimestampData.fromTimestamp((Timestamp)dstBegin2019).toTimestamp()).isEqualTo((Object)dstBegin2019);
        TimeZone.setDefault(tz);
    }

    @Test
    public void testToString() {
        Timestamp t = Timestamp.valueOf("1969-01-02 00:00:00.123456789");
        Assertions.assertThat((String)TimestampData.fromTimestamp((Timestamp)t).toString()).isEqualTo("1969-01-02T00:00:00.123456789");
        Assertions.assertThat((String)TimestampData.fromEpochMillis((long)123L).toString()).isEqualTo("1970-01-01T00:00:00.123");
        Assertions.assertThat((String)TimestampData.fromEpochMillis((long)123L, (int)456789).toString()).isEqualTo("1970-01-01T00:00:00.123456789");
        Assertions.assertThat((String)TimestampData.fromEpochMillis((long)-123L).toString()).isEqualTo("1969-12-31T23:59:59.877");
        Assertions.assertThat((String)TimestampData.fromEpochMillis((long)-123L, (int)456789).toString()).isEqualTo("1969-12-31T23:59:59.877456789");
        LocalDateTime ldt = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123456789);
        Assertions.assertThat((String)TimestampData.fromLocalDateTime((LocalDateTime)ldt).toString()).isEqualTo("1969-01-02T00:00:00.123456789");
        Instant instant = Instant.ofEpochSecond(0L, 123456789L);
        Assertions.assertThat((String)TimestampData.fromInstant((Instant)instant).toString()).isEqualTo("1970-01-01T00:00:00.123456789");
    }
}

