/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.io;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.runtime.io.compression.BlockCompressionFactory;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.table.runtime.io.CompressedHeaderlessChannelReaderInputView;
import org.apache.flink.table.runtime.io.CompressedHeaderlessChannelWriterOutputView;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedHeaderlessChannelTest {
    private static final int BUFFER_SIZE = 256;
    private IOManager ioManager = new IOManagerAsync();
    @Parameterized.Parameter
    public static BlockCompressionFactory compressionFactory;

    @Parameterized.Parameters(name="compressionFactory = {0}")
    public static BlockCompressionFactory[] compressionFactory() {
        return new BlockCompressionFactory[]{BlockCompressionFactory.createBlockCompressionFactory((String)"LZ4"), BlockCompressionFactory.createBlockCompressionFactory((String)"LZO"), BlockCompressionFactory.createBlockCompressionFactory((String)"ZSTD")};
    }

    @After
    public void afterTest() throws Exception {
        this.ioManager.close();
    }

    @Test
    public void testCompressedView() throws IOException {
        for (int testTime = 0; testTime < 10; ++testTime) {
            int testRounds = new Random().nextInt(20000);
            FileIOChannel.ID channel = this.ioManager.createChannel();
            BufferFileWriter writer = this.ioManager.createBufferFileWriter(channel);
            CompressedHeaderlessChannelWriterOutputView outputView = new CompressedHeaderlessChannelWriterOutputView(writer, compressionFactory, 256);
            for (int i = 0; i < testRounds; ++i) {
                outputView.writeInt(i);
            }
            outputView.close();
            int blockCount = outputView.getBlockCount();
            CompressedHeaderlessChannelReaderInputView inputView = new CompressedHeaderlessChannelReaderInputView(channel, this.ioManager, compressionFactory, 256, blockCount);
            for (int i = 0; i < testRounds; ++i) {
                Assertions.assertThat((int)inputView.readInt()).isEqualTo(i);
            }
            inputView.close();
        }
    }
}

