/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.dynamicfiltering;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicFilteringData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DynamicFilteringDataTest {
    DynamicFilteringDataTest() {
    }

    @Test
    void testContains() {
        RowType rowType = RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType(), new VarCharType()});
        InternalTypeInfo rowTypeInfo = InternalTypeInfo.of((RowType)rowType);
        ArrayList<RowData> buildRows = new ArrayList<RowData>();
        buildRows.add(this.rowData(1, 1L, "a"));
        buildRows.add(this.rowData(2, 1L, null));
        buildRows.add(this.rowData(1, null, "b"));
        buildRows.add(this.rowData(null, 2L, "c"));
        buildRows.add(this.rowData(0, 31L, "d"));
        List serializedData = buildRows.stream().map(arg_0 -> this.lambda$testContains$0((TypeInformation)rowTypeInfo, arg_0)).collect(Collectors.toList());
        DynamicFilteringData data = new DynamicFilteringData((TypeInformation)rowTypeInfo, rowType, serializedData, true);
        for (RowData r : buildRows) {
            Assertions.assertThat((boolean)data.contains(r)).isTrue();
        }
        Assertions.assertThat((boolean)data.contains(this.rowData(0, 1L, "a"))).isFalse();
        Assertions.assertThat((boolean)data.contains(this.rowData(1, 1L, null))).isFalse();
        Assertions.assertThat((boolean)data.contains(this.rowData(1, 0L, "d"))).isFalse();
    }

    @Test
    void testNotFiltering() {
        RowType rowType = RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType(), new VarCharType()});
        DynamicFilteringData data = new DynamicFilteringData((TypeInformation)InternalTypeInfo.of((RowType)rowType), rowType, Collections.emptyList(), false);
        Assertions.assertThat((boolean)data.contains(this.rowData(1, 1L, "a"))).isTrue();
    }

    @Test
    void testAddHashConflictingData() {
        RowType rowType = RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType(), new VarCharType()});
        InternalTypeInfo rowTypeInfo = InternalTypeInfo.of((RowType)rowType);
        ArrayList<RowData> buildRows = new ArrayList<RowData>();
        buildRows.add(this.rowData(0, 31L, "d"));
        buildRows.add(this.rowData(1, 0L, "d"));
        List serializedData = buildRows.stream().map(arg_0 -> this.lambda$testAddHashConflictingData$1((TypeInformation)rowTypeInfo, arg_0)).collect(Collectors.toList());
        DynamicFilteringData data = new DynamicFilteringData((TypeInformation)rowTypeInfo, rowType, serializedData, true);
        for (RowData r : buildRows) {
            Assertions.assertThat((boolean)data.contains(r)).isTrue();
        }
    }

    @Test
    void testMismatchingRowDataArity() {
        RowType rowType = RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType(), new VarCharType()});
        DynamicFilteringData data = new DynamicFilteringData((TypeInformation)InternalTypeInfo.of((RowType)rowType), rowType, Collections.emptyList(), true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> data.contains(this.rowData(1, 1L))).isInstanceOf(TableException.class)).hasMessage("The arity of RowData is different");
    }

    private RowData rowData(Object ... values) {
        GenericRowData rowData = new GenericRowData(values.length);
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            value = value instanceof String ? new BinaryStringData((String)value) : value;
            rowData.setField(i, value);
        }
        return rowData;
    }

    private byte[] serialize(TypeInformation<RowData> typeInfo, RowData row) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            typeInfo.createSerializer(new ExecutionConfig()).serialize((Object)row, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)baos));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    private /* synthetic */ byte[] lambda$testAddHashConflictingData$1(TypeInformation rowTypeInfo, RowData r) {
        return this.serialize((TypeInformation<RowData>)rowTypeInfo, r);
    }

    private /* synthetic */ byte[] lambda$testContains$0(TypeInformation rowTypeInfo, RowData r) {
        return this.serialize((TypeInformation<RowData>)rowTypeInfo, r);
    }
}

