/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.util.ArrayList;
import org.apache.flink.runtime.operators.testutils.UnionIterator;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.hashtable.BinaryHashTableTest;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.operators.join.Int2HashJoinOperatorTestBase;
import org.apache.flink.table.runtime.util.UniformBinaryRowGenerator;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Test;

public class Int2AdaptiveHashJoinOperatorTest
extends Int2HashJoinOperatorTestBase {
    @Test
    public void testBuildFirstHashInnerJoinFallbackToSMJ() throws Exception {
        int repeatedValue1 = 405590;
        int repeatedValue2 = 928820;
        int repeatedValueCountBuild = 100000;
        int numKeys1 = 100000;
        int numKeys2 = 160000;
        int buildValsPerKey = 3;
        int probeValsPerKey = 2;
        UniformBinaryRowGenerator build1 = new UniformBinaryRowGenerator(100000, 3, false);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build2 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(405590, 17, 100000);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build3 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(928820, 23, 100000);
        ArrayList<Object> builds = new ArrayList<Object>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(160000, 2, true);
        int expectOutSize = 600000;
        this.buildJoin((MutableObjectIterator<BinaryRowData>)buildInput, probeInput, false, false, true, expectOutSize, 100000, -1);
    }

    @Test
    public void testBuildFirstHashLeftOutJoinFallbackToSMJ() throws Exception {
        int repeatedValue1 = 40559;
        int repeatedValue2 = 92882;
        int repeatedValueCountBuild = 100000;
        int numKeys1 = 100000;
        int numKeys2 = 50000;
        int buildValsPerKey = 3;
        int probeValsPerKey = 2;
        UniformBinaryRowGenerator build1 = new UniformBinaryRowGenerator(100000, 3, false);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build2 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(40559, 17, 100000);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build3 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(92882, 23, 100000);
        ArrayList<Object> builds = new ArrayList<Object>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(50000, 2, true);
        int expectOutSize = 750000;
        this.buildJoin((MutableObjectIterator<BinaryRowData>)buildInput, probeInput, true, false, true, expectOutSize, 100000, -1);
    }

    @Test
    public void testBuildFirstHashRightOutJoinFallbackToSMJ() throws Exception {
        int repeatedValue1 = 40559;
        int repeatedValue2 = 92882;
        int repeatedValueCountBuild = 100000;
        int numKeys1 = 100000;
        int numKeys2 = 50000;
        int buildValsPerKey = 3;
        boolean probeValsPerKey = true;
        UniformBinaryRowGenerator build1 = new UniformBinaryRowGenerator(100000, 3, false);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build2 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(40559, 17, 100000);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build3 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(92882, 23, 100000);
        ArrayList<Object> builds = new ArrayList<Object>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(50000, 1, true);
        int expectOutSize = 250000;
        this.buildJoin((MutableObjectIterator<BinaryRowData>)buildInput, probeInput, false, true, true, expectOutSize, 50000, -1);
    }

    @Test
    public void testBuildFirstHashFullOutJoinFallbackToSMJ() throws Exception {
        int repeatedValue1 = 40559;
        int repeatedValue2 = 92882;
        int repeatedValueCountBuild = 100000;
        int numKeys1 = 100000;
        int numKeys2 = 150000;
        int buildValsPerKey = 3;
        boolean probeValsPerKey = true;
        UniformBinaryRowGenerator build1 = new UniformBinaryRowGenerator(100000, 3, false);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build2 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(40559, 17, 100000);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build3 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(92882, 23, 100000);
        ArrayList<Object> builds = new ArrayList<Object>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(150000, 1, true);
        int expectOutSize = 550000;
        this.buildJoin((MutableObjectIterator<BinaryRowData>)buildInput, probeInput, true, true, true, expectOutSize, 150000, -1);
    }

    @Test
    public void testBuildSecondHashLeftOutJoinFallbackToSMJ() throws Exception {
        int repeatedValue1 = 40559;
        int repeatedValue2 = 92882;
        int repeatedValueCountBuild = 100000;
        int numKeys1 = 100000;
        int numKeys2 = 50000;
        int buildValsPerKey = 3;
        boolean probeValsPerKey = true;
        UniformBinaryRowGenerator build1 = new UniformBinaryRowGenerator(100000, 3, false);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build2 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(40559, 17, 100000);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build3 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(92882, 23, 100000);
        ArrayList<Object> builds = new ArrayList<Object>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(50000, 1, true);
        int expectOutSize = 250000;
        this.buildJoin((MutableObjectIterator<BinaryRowData>)buildInput, probeInput, true, false, false, expectOutSize, 50000, -1);
    }

    @Test
    public void testBuildSecondHashRightOutJoinFallbackToSMJ() throws Exception {
        int repeatedValue1 = 40559;
        int repeatedValue2 = 92882;
        int repeatedValueCountBuild = 100000;
        int numKeys1 = 100000;
        int numKeys2 = 50000;
        int buildValsPerKey = 3;
        boolean probeValsPerKey = true;
        UniformBinaryRowGenerator build1 = new UniformBinaryRowGenerator(100000, 3, false);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build2 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(40559, 17, 100000);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build3 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(92882, 23, 100000);
        ArrayList<Object> builds = new ArrayList<Object>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(50000, 1, true);
        int expectOutSize = 500000;
        this.buildJoin((MutableObjectIterator<BinaryRowData>)buildInput, probeInput, false, true, false, expectOutSize, 100000, -1);
    }

    @Test
    public void testSemiJoinFallbackToSMJ() throws Exception {
        int repeatedValue1 = 40559;
        int repeatedValue2 = 92882;
        int repeatedValueCountBuild = 100000;
        int numKeys1 = 100000;
        int numKeys2 = 100000;
        int buildValsPerKey = 3;
        boolean probeValsPerKey = true;
        UniformBinaryRowGenerator build1 = new UniformBinaryRowGenerator(100000, 3, false);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build2 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(40559, 17, 100000);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build3 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(92882, 23, 100000);
        ArrayList<Object> builds = new ArrayList<Object>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(100000, 1, true);
        Object operator = this.newOperator(0x108000L, FlinkJoinType.SEMI, HashJoinType.SEMI, false, false);
        Int2AdaptiveHashJoinOperatorTest.joinAndAssert(operator, (MutableObjectIterator<BinaryRowData>)buildInput, probeInput, 100000, 100000, 0, true);
    }

    @Test
    public void testAntiJoinFallbackToSMJ() throws Exception {
        int repeatedValue1 = 40559;
        int repeatedValue2 = 92882;
        int repeatedValueCountBuild = 100000;
        int numKeys1 = 100000;
        int numKeys2 = 160000;
        int buildValsPerKey = 3;
        boolean probeValsPerKey = true;
        UniformBinaryRowGenerator build1 = new UniformBinaryRowGenerator(100000, 3, false);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build2 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(40559, 17, 100000);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build3 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(92882, 23, 100000);
        ArrayList<Object> builds = new ArrayList<Object>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(160000, 1, true);
        Object operator = this.newOperator(0x108000L, FlinkJoinType.ANTI, HashJoinType.ANTI, false, false);
        int expectOutSize = 60000;
        Int2AdaptiveHashJoinOperatorTest.joinAndAssert(operator, (MutableObjectIterator<BinaryRowData>)buildInput, probeInput, expectOutSize, expectOutSize, 0, true);
    }

    @Test
    public void testBuildLeftSemiJoinFallbackToSMJ() throws Exception {
        int repeatedValue1 = 405;
        int repeatedValue2 = 928;
        int repeatedValueCountBuild = 100000;
        int numKeys1 = 100000;
        int numKeys2 = 1000;
        boolean buildValsPerKey = true;
        int probeValsPerKey = 3;
        UniformBinaryRowGenerator build1 = new UniformBinaryRowGenerator(100000, 1, false);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build2 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(405, 17, 100000);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build3 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(928, 23, 100000);
        ArrayList<Object> builds = new ArrayList<Object>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(1000, 3, true);
        Object operator = this.newOperator(0x108000L, FlinkJoinType.SEMI, HashJoinType.BUILD_LEFT_SEMI, true, false);
        int expectOutSize = 201000;
        Int2AdaptiveHashJoinOperatorTest.joinAndAssert(operator, (MutableObjectIterator<BinaryRowData>)buildInput, probeInput, expectOutSize, 100000, -1, true);
    }

    @Test
    public void testBuildLeftAntiJoinFallbackToSMJ() throws Exception {
        int repeatedValue1 = 40559;
        int repeatedValue2 = 92882;
        int repeatedValueCountBuild = 100000;
        int numKeys1 = 500000;
        int numKeys2 = 100000;
        boolean buildValsPerKey = true;
        int probeValsPerKey = 3;
        UniformBinaryRowGenerator build1 = new UniformBinaryRowGenerator(500000, 1, false);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build2 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(40559, 17, 100000);
        BinaryHashTableTest.ConstantsKeyValuePairsIterator build3 = new BinaryHashTableTest.ConstantsKeyValuePairsIterator(92882, 23, 100000);
        ArrayList<Object> builds = new ArrayList<Object>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(100000, 3, true);
        Object operator = this.newOperator(0x108000L, FlinkJoinType.ANTI, HashJoinType.BUILD_LEFT_ANTI, true, false);
        int expectOutSize = 400000;
        Int2AdaptiveHashJoinOperatorTest.joinAndAssert(operator, (MutableObjectIterator<BinaryRowData>)buildInput, probeInput, expectOutSize, 400000, -1, true);
    }
}

