/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;

public class TestingTwoInputStreamOperator
extends AbstractStreamOperator<RowData>
implements TwoInputStreamOperator<RowData, RowData, RowData>,
BoundedMultiInput {
    private final boolean emitDataInEndInput;
    private final List<StreamRecord<RowData>> receivedElements = new ArrayList<StreamRecord<RowData>>();
    private boolean isOpened = false;
    private StreamRecord<RowData> currentElement1 = null;
    private StreamRecord<RowData> currentElement2 = null;
    private Watermark currentWatermark1 = null;
    private Watermark currentWatermark2 = null;
    private LatencyMarker currentLatencyMarker1 = null;
    private LatencyMarker currentLatencyMarker2 = null;
    private final List<Integer> endInputs = new ArrayList<Integer>();
    private boolean isClosed = false;

    public TestingTwoInputStreamOperator() {
        this(false);
    }

    public TestingTwoInputStreamOperator(boolean emitDataInEndInput) {
        this.emitDataInEndInput = emitDataInEndInput;
    }

    public void open() throws Exception {
        this.isOpened = true;
    }

    public void processElement1(StreamRecord<RowData> element) throws Exception {
        this.currentElement1 = element;
        if (this.emitDataInEndInput) {
            this.receivedElements.add(element);
        } else {
            this.output.collect(element);
        }
    }

    public void processElement2(StreamRecord<RowData> element) throws Exception {
        this.currentElement2 = element;
        if (this.emitDataInEndInput) {
            this.receivedElements.add(element);
        } else {
            this.output.collect(element);
        }
    }

    public void processWatermark1(Watermark mark) throws Exception {
        this.currentWatermark1 = mark;
        this.output.emitWatermark(mark);
    }

    public void processWatermark2(Watermark mark) throws Exception {
        this.currentWatermark2 = mark;
        this.output.emitWatermark(mark);
    }

    public void processLatencyMarker1(LatencyMarker latencyMarker) throws Exception {
        this.currentLatencyMarker1 = latencyMarker;
        this.output.emitLatencyMarker(latencyMarker);
    }

    public void processLatencyMarker2(LatencyMarker latencyMarker) throws Exception {
        this.currentLatencyMarker2 = latencyMarker;
        this.output.emitLatencyMarker(latencyMarker);
    }

    public void endInput(int inputId) throws Exception {
        this.endInputs.add(inputId);
        if (this.emitDataInEndInput) {
            if (this.endInputs.size() == 2) {
                this.receivedElements.forEach(arg_0 -> ((Output)this.output).collect(arg_0));
            }
        } else {
            Preconditions.checkArgument((boolean)this.receivedElements.isEmpty());
        }
    }

    public void close() throws Exception {
        this.isClosed = true;
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public StreamRecord<RowData> getCurrentElement1() {
        return this.currentElement1;
    }

    public StreamRecord<RowData> getCurrentElement2() {
        return this.currentElement2;
    }

    public Watermark getCurrentWatermark1() {
        return this.currentWatermark1;
    }

    public Watermark getCurrentWatermark2() {
        return this.currentWatermark2;
    }

    public LatencyMarker getCurrentLatencyMarker1() {
        return this.currentLatencyMarker1;
    }

    public LatencyMarker getCurrentLatencyMarker2() {
        return this.currentLatencyMarker2;
    }

    public List<Integer> getEndInputs() {
        return this.endInputs;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

