/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.dataview.StateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;

public class SumAggsHandleFunction
implements AggsHandleFunction {
    private final int inputIndex;
    private long sum;

    public SumAggsHandleFunction(int inputIndex) {
        this.inputIndex = inputIndex;
    }

    public void open(StateDataViewStore store) throws Exception {
    }

    public void accumulate(RowData input) throws Exception {
        this.sum += input.getLong(this.inputIndex);
    }

    public void retract(RowData input) throws Exception {
        this.sum -= input.getLong(this.inputIndex);
    }

    public void merge(RowData accumulator) throws Exception {
        this.sum += accumulator.getLong(0);
    }

    public void setAccumulators(RowData accumulator) throws Exception {
        this.sum = accumulator.getLong(0);
    }

    public void resetAccumulators() throws Exception {
        this.sum = 0L;
    }

    public RowData getAccumulators() throws Exception {
        return GenericRowData.of((Object[])new Object[]{this.sum});
    }

    public RowData createAccumulators() throws Exception {
        return GenericRowData.of((Object[])new Object[]{0L});
    }

    public RowData getValue() throws Exception {
        return this.getAccumulators();
    }

    public void setWindowSize(int windowSize) {
    }

    public void cleanup() throws Exception {
    }

    public void close() throws Exception {
    }
}

