/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.slicing;

import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssignerTestBase;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigners;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WindowedSliceAssignerTest
extends SliceAssignerTestBase {
    @Parameterized.Parameter
    public ZoneId shiftTimeZone;
    private SliceAssigner tumbleAssigner;
    private SliceAssigner hopAssigner;
    private SliceAssigner cumulateAssigner;

    @Parameterized.Parameters(name="timezone = {0}")
    public static Collection<ZoneId> parameters() {
        return Arrays.asList(ZoneId.of("America/Los_Angeles"), ZoneId.of("Asia/Shanghai"));
    }

    @Before
    public void setUp() {
        this.tumbleAssigner = SliceAssigners.tumbling((int)-1, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(4L));
        this.hopAssigner = SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        this.cumulateAssigner = SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
    }

    @Test
    public void testSliceAssignment() {
        SliceAssigners.WindowedSliceAssigner assigner = SliceAssigners.windowed((int)0, (SliceAssigner)this.tumbleAssigner);
        Assertions.assertThat((long)WindowedSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.utcMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)WindowedSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.utcMills("1970-01-01T05:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
        Assertions.assertThat((long)WindowedSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.utcMills("1970-01-01T10:00:00"))).isEqualTo(this.utcMills("1970-01-01T10:00:00"));
    }

    @Test
    public void testGetWindowStartForTumble() {
        SliceAssigners.WindowedSliceAssigner assigner = SliceAssigners.windowed((int)0, (SliceAssigner)this.tumbleAssigner);
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1969-12-31T20:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T04:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T08:00:00"))).isEqualTo(this.utcMills("1970-01-01T04:00:00"));
    }

    @Test
    public void testGetWindowStartForHop() {
        SliceAssigners.WindowedSliceAssigner assigner = SliceAssigners.windowed((int)0, (SliceAssigner)this.hopAssigner);
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1969-12-31T19:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T01:00:00"))).isEqualTo(this.utcMills("1969-12-31T20:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T02:00:00"))).isEqualTo(this.utcMills("1969-12-31T21:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T03:00:00"))).isEqualTo(this.utcMills("1969-12-31T22:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T04:00:00"))).isEqualTo(this.utcMills("1969-12-31T23:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T05:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T06:00:00"))).isEqualTo(this.utcMills("1970-01-01T01:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T10:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
    }

    @Test
    public void testGetWindowStartForCumulate() {
        SliceAssigners.WindowedSliceAssigner assigner = SliceAssigners.windowed((int)0, (SliceAssigner)this.cumulateAssigner);
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1969-12-31T19:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T01:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T02:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T03:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T04:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T05:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T06:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T10:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
    }

    @Test
    public void testExpiredSlices() {
        SliceAssigners.WindowedSliceAssigner assigner = SliceAssigners.windowed((int)0, (SliceAssigner)this.tumbleAssigner);
        Assertions.assertThat(WindowedSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T00:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T00:00:00")});
        Assertions.assertThat(WindowedSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T04:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T04:00:00")});
        Assertions.assertThat(WindowedSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T10:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T10:00:00")});
    }

    @Test
    public void testEventTime() {
        SliceAssigners.WindowedSliceAssigner assigner = SliceAssigners.windowed((int)0, (SliceAssigner)this.tumbleAssigner);
        Assertions.assertThat((boolean)assigner.isEventTime()).isTrue();
    }

    @Test
    public void testInvalidParameters() {
        WindowedSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.windowed((int)-1, (SliceAssigner)this.tumbleAssigner), "Windowed slice assigner must have a positive window end index.");
        SliceAssigners.windowed((int)1, (SliceAssigner)this.tumbleAssigner);
    }

    private long localMills(String timestampStr) {
        return this.localMills(timestampStr, this.shiftTimeZone);
    }
}

