/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.triggers;

import java.time.Duration;
import org.apache.flink.table.runtime.operators.window.triggers.ElementTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.EventTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.ProcessingTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.Trigger;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TriggersTest {
    @Test
    public void testEventTime() {
        Trigger trigger = EventTimeTriggers.afterEndOfWindow().withEarlyFirings((Trigger)ElementTriggers.every()).withLateFirings((Trigger)ProcessingTimeTriggers.every((Duration)Duration.ofSeconds(1L)));
        String expected = "EventTime.afterEndOfWindow().withEarlyFirings(Element.every()).withLateFirings(ProcessingTime.every(1000))";
        Assertions.assertThat((String)trigger.toString()).isEqualTo(expected);
        Assertions.assertThat((Object)trigger).isInstanceOf(EventTimeTriggers.AfterEndOfWindowEarlyAndLate.class);
        trigger = EventTimeTriggers.afterEndOfWindow().withEarlyFirings((Trigger)ProcessingTimeTriggers.every((Duration)Duration.ofSeconds(1L))).withLateFirings((Trigger)ElementTriggers.every());
        expected = "EventTime.afterEndOfWindow().withEarlyFirings(ProcessingTime.every(1000))";
        Assertions.assertThat((String)trigger.toString()).isEqualTo(expected);
        Assertions.assertThat((Object)trigger).isInstanceOf(EventTimeTriggers.AfterEndOfWindowNoLate.class);
        trigger = EventTimeTriggers.afterEndOfWindow().withEarlyFirings((Trigger)ProcessingTimeTriggers.every((Duration)Duration.ofSeconds(1L)));
        expected = "EventTime.afterEndOfWindow().withEarlyFirings(ProcessingTime.every(1000))";
        Assertions.assertThat((String)trigger.toString()).isEqualTo(expected);
        Assertions.assertThat((Object)trigger).isInstanceOf(EventTimeTriggers.AfterEndOfWindowNoLate.class);
        trigger = EventTimeTriggers.afterEndOfWindow().withEarlyFirings((Trigger)ElementTriggers.every());
        expected = "EventTime.afterEndOfWindow().withEarlyFirings(Element.every())";
        Assertions.assertThat((String)trigger.toString()).isEqualTo(expected);
        Assertions.assertThat((Object)trigger).isInstanceOf(EventTimeTriggers.AfterEndOfWindowNoLate.class);
        trigger = EventTimeTriggers.afterEndOfWindow().withLateFirings((Trigger)ProcessingTimeTriggers.every((Duration)Duration.ofMillis(1L)));
        expected = "EventTime.afterEndOfWindow().withLateFirings(ProcessingTime.every(1))";
        Assertions.assertThat((String)trigger.toString()).isEqualTo(expected);
        Assertions.assertThat((Object)trigger).isInstanceOf(EventTimeTriggers.AfterEndOfWindowEarlyAndLate.class);
        trigger = EventTimeTriggers.afterEndOfWindow().withLateFirings((Trigger)ElementTriggers.every());
        expected = "EventTime.afterEndOfWindow()";
        Assertions.assertThat((String)trigger.toString()).isEqualTo(expected);
        Assertions.assertThat((Object)trigger).isInstanceOf(EventTimeTriggers.AfterEndOfWindow.class);
    }

    @Test
    public void testProcessingTime() {
        ProcessingTimeTriggers.AfterEndOfWindow trigger = ProcessingTimeTriggers.afterEndOfWindow();
        String expected = "ProcessingTime.afterEndOfWindow()";
        Assertions.assertThat((String)trigger.toString()).isEqualTo(expected);
        Assertions.assertThat((Object)trigger).isInstanceOf(ProcessingTimeTriggers.AfterEndOfWindow.class);
        trigger = ProcessingTimeTriggers.afterEndOfWindow().withEarlyFirings((Trigger)ElementTriggers.every());
        expected = "ProcessingTime.afterEndOfWindow().withEarlyFirings(Element.every())";
        Assertions.assertThat((String)trigger.toString()).isEqualTo(expected);
        Assertions.assertThat((Object)trigger).isInstanceOf(ProcessingTimeTriggers.AfterEndOfWindowNoLate.class);
        trigger = ProcessingTimeTriggers.afterEndOfWindow().withEarlyFirings((Trigger)ProcessingTimeTriggers.every((Duration)Duration.ofSeconds(1L)));
        expected = "ProcessingTime.afterEndOfWindow().withEarlyFirings(ProcessingTime.every(1000))";
        Assertions.assertThat((String)trigger.toString()).isEqualTo(expected);
        Assertions.assertThat((Object)trigger).isInstanceOf(ProcessingTimeTriggers.AfterEndOfWindowNoLate.class);
    }
}

