/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.util.RowDataTestUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;

public class RowDataHarnessAssertor {
    private final LogicalType[] types;
    private final Comparator<GenericRowData> comparator;

    public RowDataHarnessAssertor(LogicalType[] types, Comparator<GenericRowData> comparator) {
        this.types = types;
        this.comparator = comparator;
    }

    public RowDataHarnessAssertor(LogicalType[] types) {
        this(types, new StringComparator());
    }

    public void assertOutputEquals(String message, Collection<Object> expected, Collection<Object> actual) {
        this.assertOutputEquals(message, expected, actual, false);
    }

    public void assertOutputEqualsSorted(String message, Collection<Object> expected, Collection<Object> actual) {
        this.assertOutputEquals(message, expected, actual, true);
    }

    private void assertOutputEquals(String message, Collection<Object> expected, Collection<Object> actual, boolean needSort) {
        if (needSort) {
            Preconditions.checkArgument((this.comparator != null ? 1 : 0) != 0, (Object)"Comparator should not be null!");
        }
        Assertions.assertThat(actual).hasSize(expected.size());
        Iterator<Object> exIt = expected.iterator();
        Iterator<Object> actIt = actual.iterator();
        while (exIt.hasNext()) {
            Object nextEx = exIt.next();
            Object nextAct = actIt.next();
            if (!(nextEx instanceof Watermark)) continue;
            Assertions.assertThat((Object)nextAct).isEqualTo(nextEx);
        }
        ArrayList<GenericRowData> expectedRecords = new ArrayList<GenericRowData>();
        ArrayList<GenericRowData> actualRecords = new ArrayList<GenericRowData>();
        for (Object ex : expected) {
            if (!(ex instanceof StreamRecord)) continue;
            RowData row = (RowData)((StreamRecord)ex).getValue();
            if (row instanceof GenericRowData) {
                expectedRecords.add((GenericRowData)row);
                continue;
            }
            GenericRowData genericRow = RowDataTestUtil.toGenericRowDeeply(row, this.types);
            expectedRecords.add(genericRow);
        }
        for (Object act : actual) {
            if (!(act instanceof StreamRecord)) continue;
            RowData actualOutput = (RowData)((StreamRecord)act).getValue();
            GenericRowData actualRow = RowDataTestUtil.toGenericRowDeeply(actualOutput, this.types);
            actualRecords.add(actualRow);
        }
        GenericRowData[] sortedExpected = expectedRecords.toArray(new GenericRowData[expectedRecords.size()]);
        Object[] sortedActual = actualRecords.toArray(new GenericRowData[actualRecords.size()]);
        if (needSort) {
            Arrays.sort(sortedExpected, this.comparator);
            Arrays.sort(sortedActual, this.comparator);
        }
        ((ObjectArrayAssert)Assertions.assertThat((Object[])sortedActual).as(message, new Object[0])).isEqualTo((Object)sortedExpected);
    }

    private static class StringComparator
    implements Comparator<GenericRowData> {
        private StringComparator() {
        }

        @Override
        public int compare(GenericRowData o1, GenericRowData o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

