/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections.binary;

import java.util.Random;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.util.collections.binary.BytesHashMap;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class BytesMapTestBase {
    protected static final long RANDOM_SEED = 76518743207143L;
    protected static final int PAGE_SIZE = 32768;
    protected static final int NUM_ENTRIES = 10000;

    protected BinaryRowData[] getRandomizedInputs(int num) {
        Random rnd = new Random(76518743207143L);
        return this.getRandomizedInputs(num, rnd, true);
    }

    protected BinaryRowData[] getRandomizedInputs(int num, Random rnd, boolean nullable) {
        BinaryRowData[] lists = new BinaryRowData[num];
        for (int i = 0; i < num; ++i) {
            int intVal = rnd.nextInt(Integer.MAX_VALUE);
            long longVal = -rnd.nextLong();
            boolean boolVal = longVal % 2L == 0L;
            String strVal = nullable && boolVal ? null : this.getString(intVal, intVal % 1024) + i;
            Double doubleVal = rnd.nextDouble();
            Short shotVal = (short)intVal;
            Float floatVal = nullable && boolVal ? null : Float.valueOf(rnd.nextFloat());
            lists[i] = this.createRow(intVal, strVal, doubleVal, longVal, boolVal, floatVal, shotVal);
        }
        return lists;
    }

    protected BinaryRowData createRow(Integer f0, String f1, Double f2, Long f3, Boolean f4, Float f5, Short f6) {
        BinaryRowData row = new BinaryRowData(7);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        if (f0 == null) {
            writer.setNullAt(0);
        } else {
            writer.writeInt(0, f0.intValue());
        }
        if (f1 == null) {
            writer.setNullAt(1);
        } else {
            writer.writeString(1, StringData.fromString((String)f1));
        }
        if (f2 == null) {
            writer.setNullAt(2);
        } else {
            writer.writeDouble(2, f2.doubleValue());
        }
        if (f3 == null) {
            writer.setNullAt(3);
        } else {
            writer.writeLong(3, f3.longValue());
        }
        if (f4 == null) {
            writer.setNullAt(4);
        } else {
            writer.writeBoolean(4, f4.booleanValue());
        }
        if (f5 == null) {
            writer.setNullAt(5);
        } else {
            writer.writeFloat(5, f5.floatValue());
        }
        if (f6 == null) {
            writer.setNullAt(6);
        } else {
            writer.writeShort(6, f6.shortValue());
        }
        writer.complete();
        return row;
    }

    protected int needNumMemSegments(int numEntries, int valLen, int keyLen, int pageSize) {
        return 2 * (valLen + keyLen + 3072 + 4 + 8 + 8) * numEntries / pageSize;
    }

    protected int rowLength(RowType tpe) {
        return BinaryRowData.calculateFixPartSizeInBytes((int)tpe.getFieldCount()) + BytesHashMap.getVariableLength((LogicalType[])tpe.getChildren().toArray(new LogicalType[0]));
    }

    private String getString(int count, int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(count);
        }
        return builder.toString();
    }
}

