/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections.binary;

import java.util.Iterator;
import java.util.Random;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.util.KeyValueIterator;
import org.apache.flink.table.runtime.util.collections.binary.AbstractBytesMultiMap;
import org.apache.flink.table.runtime.util.collections.binary.BytesMap;
import org.apache.flink.table.runtime.util.collections.binary.BytesMapTestBase;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.VarCharType;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class BytesMultiMapTestBase<K>
extends BytesMapTestBase {
    protected static final int NUM_VALUE_PER_KEY = 50;
    static final LogicalType[] KEY_TYPES = new LogicalType[]{new IntType(), VarCharType.STRING_TYPE, new DoubleType(), new BigIntType(), new BooleanType(), new FloatType(), new SmallIntType()};
    static final LogicalType[] VALUE_TYPES = new LogicalType[]{VarCharType.STRING_TYPE, new IntType()};
    protected final PagedTypeSerializer<K> keySerializer;
    protected final BinaryRowDataSerializer valueSerializer;

    public BytesMultiMapTestBase(PagedTypeSerializer<K> keySerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = new BinaryRowDataSerializer(VALUE_TYPES.length);
    }

    public abstract AbstractBytesMultiMap<K> createBytesMultiMap(MemoryManager var1, int var2, LogicalType[] var3, LogicalType[] var4);

    public abstract K[] generateRandomKeys(int var1);

    @Test
    public void testBuildAndRetrieve() throws Exception {
        int numMemSegments = this.needNumMemSegments(10000, this.rowLength(RowType.of((LogicalType[])VALUE_TYPES)), this.rowLength(RowType.of((LogicalType[])KEY_TYPES)), 32768);
        int memorySize = numMemSegments * 32768;
        MemoryManager memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize((long)(numMemSegments * 32768)).build();
        AbstractBytesMultiMap<K> table = this.createBytesMultiMap(memoryManager, memorySize, KEY_TYPES, VALUE_TYPES);
        K[] keys = this.generateRandomKeys(1000);
        BinaryRowData[] values = this.genValues(50);
        for (K key : keys) {
            for (BinaryRowData value : values) {
                BytesMap.LookupInfo lookupInfo = table.lookup(key);
                table.append(lookupInfo, value);
            }
        }
        KeyValueIterator iter = table.getEntryIterator(false);
        while (iter.advanceNext()) {
            int i = 0;
            Iterator valueIter = (Iterator)iter.getValue();
            while (valueIter.hasNext()) {
                Assertions.assertThat((Object)values[i++]).isEqualTo(valueIter.next());
            }
        }
    }

    private BinaryRowData[] genValues(int num) {
        BinaryRowData[] values = new BinaryRowData[num];
        Random rnd = new Random(76518743207143L);
        for (int i = 0; i < num; ++i) {
            values[i] = new BinaryRowData(2);
            BinaryRowWriter writer = new BinaryRowWriter(values[i]);
            writer.writeString(0, StringData.fromString((String)("string" + rnd.nextInt())));
            writer.writeInt(1, rnd.nextInt());
            writer.complete();
        }
        return values;
    }
}

