/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.data.writer.BinaryWriter;
import org.apache.flink.table.runtime.keyselector.EmptyRowDataKeySelector;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;

public class HandwrittenSelectorUtil {
    public static RowDataKeySelector getRowDataSelector(int[] keyFields, LogicalType[] inputFieldTypes) {
        return keyFields.length > 0 ? new HandwrittenKeySelector(keyFields, inputFieldTypes) : EmptyRowDataKeySelector.INSTANCE;
    }

    private static class HandwrittenKeySelector
    implements RowDataKeySelector {
        private static final long serialVersionUID = 1L;
        private final int[] keyFields;
        private final LogicalType[] inputFieldTypes;
        private final LogicalType[] keyFieldTypes;
        private final TypeSerializer<?>[] keySers;
        private final RowData.FieldGetter[] fieldGetters;

        public HandwrittenKeySelector(int[] keyFields, LogicalType[] inputFieldTypes) {
            this.keyFields = keyFields;
            this.inputFieldTypes = inputFieldTypes;
            this.keyFieldTypes = new LogicalType[keyFields.length];
            this.keySers = new TypeSerializer[keyFields.length];
            this.fieldGetters = new RowData.FieldGetter[keyFields.length];
            for (int i = 0; i < keyFields.length; ++i) {
                this.keyFieldTypes[i] = inputFieldTypes[keyFields[i]];
                this.keySers[i] = InternalSerializers.create((LogicalType)this.keyFieldTypes[i]);
                this.fieldGetters[i] = RowData.createFieldGetter((LogicalType)inputFieldTypes[keyFields[i]], (int)keyFields[i]);
            }
        }

        public RowData getKey(RowData value) {
            BinaryRowData ret = new BinaryRowData(this.keyFields.length);
            BinaryRowWriter writer = new BinaryRowWriter(ret);
            for (int i = 0; i < this.keyFields.length; ++i) {
                if (value.isNullAt(i)) {
                    writer.setNullAt(i);
                    continue;
                }
                BinaryWriter.write((BinaryWriter)writer, (int)i, (Object)this.fieldGetters[i].getFieldOrNull(value), (LogicalType)this.inputFieldTypes[this.keyFields[i]], this.keySers[i]);
            }
            writer.complete();
            return ret;
        }

        public InternalTypeInfo<RowData> getProducedType() {
            return InternalTypeInfo.ofFields((LogicalType[])this.keyFieldTypes);
        }
    }
}

