/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.keyselector;

import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;

public class GenericRowDataKeySelector
implements RowDataKeySelector {
    private static final long serialVersionUID = 1L;
    private final InternalTypeInfo<RowData> keyRowType;
    private final RowDataSerializer keySerializer;
    private final GeneratedProjection generatedProjection;
    private transient Projection<RowData, GenericRowData> projection;

    public GenericRowDataKeySelector(InternalTypeInfo<RowData> keyRowType, RowDataSerializer keySerializer, GeneratedProjection generatedProjection) {
        this.keyRowType = keyRowType;
        this.generatedProjection = generatedProjection;
        this.keySerializer = keySerializer;
    }

    public void open() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.projection = (Projection)this.generatedProjection.newInstance(cl);
    }

    public RowData getKey(RowData value) throws Exception {
        if (this.projection == null) {
            this.open();
        }
        return this.keySerializer.copy((RowData)this.projection.apply(value));
    }

    @Override
    public InternalTypeInfo<RowData> getProducedType() {
        return this.keyRowType;
    }

    public GenericRowDataKeySelector copy() {
        return new GenericRowDataKeySelector(this.keyRowType, this.keySerializer, this.generatedProjection);
    }
}

