/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.testutils;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractCompletableFutureAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowableAssertAlternative;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;

public class FlinkCompletableFutureAssert<T>
extends AbstractCompletableFutureAssert<FlinkCompletableFutureAssert<T>, T> {
    private static final String SHOULD_HAVE_SUCCEEDED = "%nExpecting%n  <%s>%nto have succeeded.%n";
    private static final String SHOULD_HAVE_FAILED = "%nExpecting%n  <%s>%nto have failed.%n";
    private static final String SHOULD_NOT_COMPLETED = "%nExpecting%n  <%s>%nto have not completed normally or exceptionally within %s ms.%n";

    FlinkCompletableFutureAssert(CompletableFuture<T> actual) {
        super(actual, FlinkCompletableFutureAssert.class);
    }

    FlinkCompletableFutureAssert(CompletionStage<T> actual) {
        super(actual.toCompletableFuture(), FlinkCompletableFutureAssert.class);
    }

    public ObjectAssert<T> eventuallySucceeds() {
        T object = this.assertEventuallySucceeds((AssertionInfo)this.info, (Future)this.actual);
        return new ObjectAssert(object);
    }

    public WithThrowable eventuallyFails() {
        return new WithThrowable(this.assertEventuallyFails((AssertionInfo)this.info, (Future)this.actual));
    }

    public <E extends Throwable> ThrowableAssertAlternative<E> eventuallyFailsWith(Class<E> exceptionClass) {
        return this.eventuallyFails().withThrowableOfType(exceptionClass);
    }

    public FlinkCompletableFutureAssert<T> willNotCompleteWithin(Duration duration) {
        this.assertWillNotCompleteWithin((AssertionInfo)this.info, (Future)this.actual, duration);
        return (FlinkCompletableFutureAssert)this.myself;
    }

    private T assertEventuallySucceeds(AssertionInfo info, Future<T> actual) {
        Objects.instance().assertNotNull(info, actual);
        try {
            return actual.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            throw Failures.instance().failure(info, (ErrorMessageFactory)new BasicErrorMessageFactory(SHOULD_HAVE_SUCCEEDED, new Object[]{actual}));
        }
    }

    private Exception assertEventuallyFails(AssertionInfo info, Future<?> actual) {
        Objects.instance().assertNotNull(info, actual);
        try {
            actual.get();
            throw Failures.instance().failure(info, (ErrorMessageFactory)new BasicErrorMessageFactory(SHOULD_HAVE_FAILED, new Object[]{actual}));
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            return e;
        }
    }

    private void assertWillNotCompleteWithin(AssertionInfo info, Future<T> actual, Duration duration) {
        Objects.instance().assertNotNull(info, actual);
        try {
            actual.get(duration.toMillis(), TimeUnit.MILLISECONDS);
            throw Failures.instance().failure(info, (ErrorMessageFactory)new BasicErrorMessageFactory(SHOULD_NOT_COMPLETED, new Object[]{actual, duration.toMillis()}));
        }
        catch (TimeoutException timeoutException) {
        }
        catch (Throwable e) {
            throw Failures.instance().failure(info, (ErrorMessageFactory)new BasicErrorMessageFactory(SHOULD_NOT_COMPLETED, new Object[]{actual, duration.toMillis()}));
        }
    }

    public static class WithThrowable {
        private final Throwable throwable;

        private WithThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public <T extends Throwable> ThrowableAssertAlternative<T> withThrowableOfType(Class<T> type) {
            ThrowableAssertAlternative throwableAssert;
            ThrowableAssertAlternative cast = throwableAssert = (ThrowableAssertAlternative)new ThrowableAssertAlternative(this.throwable).isInstanceOf(type);
            return cast;
        }
    }
}

