/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.test.util.TestingSecurityContext;
import org.apache.hadoop.minikdc.MiniKdc;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureTestEnvironment {
    protected static final Logger LOG = LoggerFactory.getLogger(SecureTestEnvironment.class);
    private static MiniKdc kdc;
    private static String testKeytab;
    private static String testPrincipal;
    private static String testZkServerPrincipal;
    private static String testZkClientPrincipal;
    private static String testKafkaServerPrincipal;
    private static String hadoopServicePrincipal;

    public static void prepare(TemporaryFolder tempFolder) {
        try {
            File baseDirForSecureRun = tempFolder.newFolder();
            LOG.info("Base Directory for Secure Environment: {}", (Object)baseDirForSecureRun);
            String hostName = "localhost";
            Properties kdcConf = MiniKdc.createConf();
            if (LOG.isDebugEnabled()) {
                kdcConf.setProperty("debug", "true");
            }
            kdcConf.setProperty("kdc.bind.address", hostName);
            kdc = new MiniKdc(kdcConf, baseDirForSecureRun);
            kdc.start();
            LOG.info("Started Mini KDC");
            File keytabFile = new File(baseDirForSecureRun, "test-users.keytab");
            testKeytab = keytabFile.getAbsolutePath();
            testZkServerPrincipal = "zookeeper/127.0.0.1";
            testZkClientPrincipal = "zk-client/127.0.0.1";
            testKafkaServerPrincipal = "kafka/" + hostName;
            hadoopServicePrincipal = "hadoop/" + hostName;
            testPrincipal = "client/" + hostName;
            kdc.createPrincipal(keytabFile, new String[]{testPrincipal, testZkServerPrincipal, hadoopServicePrincipal, testZkClientPrincipal, testKafkaServerPrincipal});
            testPrincipal = testPrincipal + "@" + kdc.getRealm();
            testZkServerPrincipal = testZkServerPrincipal + "@" + kdc.getRealm();
            testZkClientPrincipal = testZkClientPrincipal + "@" + kdc.getRealm();
            testKafkaServerPrincipal = testKafkaServerPrincipal + "@" + kdc.getRealm();
            hadoopServicePrincipal = hadoopServicePrincipal + "@" + kdc.getRealm();
            LOG.info("-------------------------------------------------------------------");
            LOG.info("Test Principal: {}", (Object)testPrincipal);
            LOG.info("Test ZK Server Principal: {}", (Object)testZkServerPrincipal);
            LOG.info("Test ZK Client Principal: {}", (Object)testZkClientPrincipal);
            LOG.info("Test Kafka Server Principal: {}", (Object)testKafkaServerPrincipal);
            LOG.info("Test Hadoop Service Principal: {}", (Object)hadoopServicePrincipal);
            LOG.info("Test Keytab: {}", (Object)testKeytab);
            LOG.info("-------------------------------------------------------------------");
            Configuration flinkConfig = GlobalConfiguration.loadConfiguration();
            flinkConfig.setBoolean(SecurityOptions.ZOOKEEPER_SASL_DISABLE, false);
            flinkConfig.setString(SecurityOptions.KERBEROS_LOGIN_KEYTAB, testKeytab);
            flinkConfig.setBoolean(SecurityOptions.KERBEROS_LOGIN_USETICKETCACHE, false);
            flinkConfig.setString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL, testPrincipal);
            flinkConfig.setString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, "Client,KafkaClient");
            SecurityConfiguration ctx = new SecurityConfiguration(flinkConfig);
            TestingSecurityContext.install(ctx, SecureTestEnvironment.getClientSecurityConfigurationMap());
            SecureTestEnvironment.populateJavaPropertyVariables();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occured while preparing secure environment.", e);
        }
    }

    public static void cleanup() {
        LOG.info("Cleaning up Secure Environment");
        if (kdc != null) {
            kdc.stop();
            LOG.info("Stopped KDC server");
        }
        SecureTestEnvironment.resetSystemEnvVariables();
        testKeytab = null;
        testPrincipal = null;
        testZkServerPrincipal = null;
        hadoopServicePrincipal = null;
    }

    private static void populateJavaPropertyVariables() {
        if (LOG.isDebugEnabled()) {
            System.setProperty("sun.security.krb5.debug", "true");
        }
        System.setProperty("java.security.krb5.conf", kdc.getKrb5conf().getAbsolutePath());
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.kerberos.removeHostFromPrincipal", "true");
        System.setProperty("zookeeper.kerberos.removeRealmFromPrincipal", "true");
    }

    private static void resetSystemEnvVariables() {
        System.clearProperty("java.security.krb5.conf");
        System.clearProperty("sun.security.krb5.debug");
        System.clearProperty("zookeeper.authProvider.1");
        System.clearProperty("zookeeper.kerberos.removeHostFromPrincipal");
        System.clearProperty("zookeeper.kerberos.removeRealmFromPrincipal");
    }

    public static Configuration populateFlinkSecureConfigurations(@Nullable Configuration flinkConf) {
        Configuration conf = flinkConf == null ? new Configuration() : flinkConf;
        conf.setString(SecurityOptions.KERBEROS_LOGIN_KEYTAB, testKeytab);
        conf.setString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL, testPrincipal);
        return conf;
    }

    public static Map<String, TestingSecurityContext.ClientSecurityConfiguration> getClientSecurityConfigurationMap() {
        HashMap<String, TestingSecurityContext.ClientSecurityConfiguration> clientSecurityConfigurationMap = new HashMap<String, TestingSecurityContext.ClientSecurityConfiguration>();
        if (testZkServerPrincipal != null) {
            TestingSecurityContext.ClientSecurityConfiguration zkServer = new TestingSecurityContext.ClientSecurityConfiguration(testZkServerPrincipal, testKeytab);
            clientSecurityConfigurationMap.put("Server", zkServer);
        }
        if (testZkClientPrincipal != null) {
            TestingSecurityContext.ClientSecurityConfiguration zkClient = new TestingSecurityContext.ClientSecurityConfiguration(testZkClientPrincipal, testKeytab);
            clientSecurityConfigurationMap.put("Client", zkClient);
        }
        if (testKafkaServerPrincipal != null) {
            TestingSecurityContext.ClientSecurityConfiguration kafkaServer = new TestingSecurityContext.ClientSecurityConfiguration(testKafkaServerPrincipal, testKeytab);
            clientSecurityConfigurationMap.put("KafkaServer", kafkaServer);
        }
        return clientSecurityConfigurationMap;
    }

    public static String getTestKeytab() {
        return testKeytab;
    }

    public static String getHadoopServicePrincipal() {
        return hadoopServicePrincipal;
    }

    static {
        testKeytab = null;
        testPrincipal = null;
        testZkServerPrincipal = null;
        testZkClientPrincipal = null;
        testKafkaServerPrincipal = null;
        hadoopServicePrincipal = null;
    }
}

