/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.security.DynamicConfiguration;
import org.apache.flink.runtime.security.KerberosUtils;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.security.modules.JaasModuleFactory;
import org.apache.flink.runtime.security.modules.SecurityModuleFactory;

@Internal
public class TestingSecurityContext {
    public static void install(SecurityConfiguration config, Map<String, ClientSecurityConfiguration> clientSecurityConfigurationMap) throws Exception {
        SecurityUtils.install((SecurityConfiguration)config);
        for (SecurityModuleFactory factory : config.getSecurityModuleFactories()) {
            if (!(factory instanceof JaasModuleFactory)) continue;
            DynamicConfiguration jaasConf = (DynamicConfiguration)Configuration.getConfiguration();
            for (Map.Entry<String, ClientSecurityConfiguration> e : clientSecurityConfigurationMap.entrySet()) {
                AppConfigurationEntry entry = KerberosUtils.keytabEntry((String)e.getValue().getKeytab(), (String)e.getValue().getPrincipal());
                jaasConf.addAppConfigurationEntry(e.getKey(), new AppConfigurationEntry[]{entry});
            }
        }
    }

    static class ClientSecurityConfiguration {
        private final String principal;
        private final String keytab;

        public String getPrincipal() {
            return this.principal;
        }

        public String getKeytab() {
            return this.keytab;
        }

        public ClientSecurityConfiguration(String principal, String keytab) {
            this.principal = principal;
            this.keytab = keytab;
        }
    }
}

