/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators.translation;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.translation.KeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingReduceOperator;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.translation.ReduceTranslationTest$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001=2A!\u0001\u0002\u0001#\t)\"+\u001a3vG\u0016$&/\u00198tY\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003-!(/\u00198tY\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!C8qKJ\fGo\u001c:t\u0015\t9\u0001\"A\u0003tG\u0006d\u0017M\u0003\u0002\n\u0015\u0005\u0019\u0011\r]5\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111#F\u0007\u0002))\tq!\u0003\u0002\u0017)\t1\u0011I\\=SK\u001aDQ\u0001\u0007\u0001\u0005\u0002e\ta\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0002\t\u000bu\u0001A\u0011\u0001\u0010\u00023Q\u0014\u0018M\\:mCR,gj\u001c8He>,\b/\u001a3SK\u0012,8-\u001a\u000b\u0002?A\u00111\u0003I\u0005\u0003CQ\u0011A!\u00168ji\"\u0012Ad\t\t\u0003I\u001dj\u0011!\n\u0006\u0003M9\tQA[;oSRL!\u0001K\u0013\u0003\tQ+7\u000f\u001e\u0005\u0006U\u0001!\tAH\u0001\u001fiJ\fgn\u001d7bi\u0016<%o\\;qK\u0012\u0014V\rZ;dK:{W*\u00199qKJD#!K\u0012\t\u000b5\u0002A\u0011\u0001\u0010\u0002MQ\u0014\u0018M\\:mCR,wI]8va\u0016$'+\u001a3vG\u0016<\u0016\u000e\u001e5LKf,\u0005\u0010\u001e:bGR|'\u000f\u000b\u0002-G\u0001")
public class ReduceTranslationTest {
    @Test
    public void translateNonGroupedReduce() {
        try {
            int parallelism = 8;
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.createLocalEnvironment(parallelism);
            DataSet initialData = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)3.141592), (Object)"foobar", (Object)BoxesRunTime.boxToLong((long)77L))}), ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                        public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.operators.translation.ReduceTranslationTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            }).setParallelism(1);
            initialData.reduce((Function2 & Serializable & scala.Serializable)(v1, v2) -> v1).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan(env.createProgramPlan$default$1());
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            ReduceOperatorBase reducer = (ReduceOperatorBase)sink.getInput();
            Assert.assertEquals((Object)initialData.javaSet().getType(), (Object)reducer.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)initialData.javaSet().getType(), (Object)reducer.getOperatorInfo().getOutputType());
            Assert.assertTrue((reducer.getKeyColumns(0) == null || reducer.getKeyColumns(0).length == 0 ? 1 : 0) != 0);
            Assert.assertTrue((reducer.getParallelism() == 1 || reducer.getParallelism() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(reducer.getInput() instanceof GenericDataSourceBase));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)new StringBuilder(22).append("Test caused an error: ").append(e.getMessage()).toString());
        }
    }

    @Test
    public void translateGroupedReduceNoMapper() {
        try {
            int parallelism = 8;
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.createLocalEnvironment(parallelism);
            DataSet initialData = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)3.141592), (Object)"foobar", (Object)BoxesRunTime.boxToLong((long)77L))}), ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                        public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.api.scala.operators.translation.ReduceTranslationTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            }).setParallelism(1);
            initialData.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).reduce((Function2 & Serializable & scala.Serializable)(v1, v2) -> v1).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan(env.createProgramPlan$default$1());
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            ReduceOperatorBase reducer = (ReduceOperatorBase)sink.getInput();
            Assert.assertEquals((Object)initialData.javaSet().getType(), (Object)reducer.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)initialData.javaSet().getType(), (Object)reducer.getOperatorInfo().getOutputType());
            Assert.assertTrue((reducer.getParallelism() == parallelism || reducer.getParallelism() == -1 ? 1 : 0) != 0);
            Assert.assertArrayEquals((int[])((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}), ClassTag$.MODULE$.Int())), (int[])reducer.getKeyColumns(0));
            Assert.assertTrue((boolean)(reducer.getInput() instanceof GenericDataSourceBase));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)new StringBuilder(22).append("Test caused an error: ").append(e.getMessage()).toString());
        }
    }

    @Test
    public void translateGroupedReduceWithKeyExtractor() {
        try {
            int parallelism = 8;
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.createLocalEnvironment(parallelism);
            DataSet initialData = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)3.141592), (Object)"foobar", (Object)BoxesRunTime.boxToLong((long)77L))}), ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                        public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.api.scala.operators.translation.ReduceTranslationTest$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            }).setParallelism(1);
            initialData.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._2(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).reduce((Function2 & Serializable & scala.Serializable)(v1, v2) -> v1).setParallelism(4).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan(env.createProgramPlan$default$1());
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            MapOperatorBase keyProjector = (MapOperatorBase)sink.getInput();
            PlanUnwrappingReduceOperator reducer = (PlanUnwrappingReduceOperator)keyProjector.getInput();
            MapOperatorBase keyExtractor = (MapOperatorBase)reducer.getInput();
            Assert.assertEquals((long)1L, (long)keyExtractor.getParallelism());
            Assert.assertEquals((long)4L, (long)reducer.getParallelism());
            Assert.assertEquals((long)4L, (long)keyProjector.getParallelism());
            TupleTypeInfo keyValueInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                        public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.api.scala.operators.translation.ReduceTranslationTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            }});
            Assert.assertEquals((Object)initialData.javaSet().getType(), (Object)keyExtractor.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)keyValueInfo, (Object)keyExtractor.getOperatorInfo().getOutputType());
            Assert.assertEquals((Object)keyValueInfo, (Object)reducer.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)keyValueInfo, (Object)reducer.getOperatorInfo().getOutputType());
            Assert.assertEquals((Object)keyValueInfo, (Object)keyProjector.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)initialData.javaSet().getType(), (Object)keyProjector.getOperatorInfo().getOutputType());
            Assert.assertEquals(KeyExtractingMapper.class, (Object)keyExtractor.getUserCodeWrapper().getUserCodeClass());
            Assert.assertTrue((boolean)(keyExtractor.getInput() instanceof GenericDataSourceBase));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)new StringBuilder(22).append("Test caused an error: ").append(e.getMessage()).toString());
        }
    }
}

