/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.upserttest.sink;

import java.util.Arrays;
import org.apache.flink.connector.upserttest.sink.ImmutableByteArrayWrapper;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
class ImmutableByteArrayWrapperTest {
    ImmutableByteArrayWrapperTest() {
    }

    @Test
    void testConstructorCopy() {
        byte[] array = "immutability of constructor".getBytes();
        byte[] clonedArray = new ImmutableByteArrayWrapper((byte[])array).bytes;
        ImmutableByteArrayWrapperTest.assertCopyIsReferenceFree(array, clonedArray);
    }

    @Test
    void testGetterCopy() {
        byte[] array = "immutability of getter".getBytes();
        byte[] clonedArray = new ImmutableByteArrayWrapper(array).array();
        ImmutableByteArrayWrapperTest.assertCopyIsReferenceFree(array, clonedArray);
    }

    private static void assertCopyIsReferenceFree(byte[] original, byte[] clone) {
        Assertions.assertThat((byte[])clone).isNotSameAs((Object)original);
        Assertions.assertThat((byte[])clone).isEqualTo((Object)original);
        Arrays.fill(original, (byte)0);
        Assertions.assertThat((byte[])clone).isNotEqualTo((Object)original);
    }
}

