/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.walkthrough.common.table;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.walkthrough.common.sink.LoggerOutputFormat;

@PublicEvolving
public class SpendReportTableSink
implements AppendStreamTableSink<Row>,
BatchTableSink<Row> {
    private final TableSchema schema = TableSchema.builder().field("accountId", Types.LONG).field("timestamp", Types.SQL_TIMESTAMP).field("amount", Types.DOUBLE).build();

    public void emitDataSet(DataSet<Row> dataSet) {
        dataSet.map(SpendReportTableSink::format).output((OutputFormat)new LoggerOutputFormat());
    }

    public void emitDataStream(DataStream<Row> dataStream) {
        dataStream.map(SpendReportTableSink::format).writeUsingOutputFormat((OutputFormat)new LoggerOutputFormat()).setParallelism(dataStream.getParallelism());
    }

    public TableSchema getTableSchema() {
        return this.schema;
    }

    public DataType getConsumedDataType() {
        return this.getTableSchema().toRowDataType();
    }

    public String[] getFieldNames() {
        return this.getTableSchema().getFieldNames();
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.getTableSchema().getFieldTypes();
    }

    public TableSink<Row> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        return this;
    }

    private static String format(Row row) {
        return String.format("%s, %s, $%.2f", row.getField(0), row.getField(1), row.getField(2));
    }
}

