/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.walkthrough.common.table;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.tsextractors.ExistingField;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.sources.wmstrategies.BoundedOutOfOrderTimestamps;
import org.apache.flink.table.sources.wmstrategies.WatermarkStrategy;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.walkthrough.common.entity.Transaction;
import org.apache.flink.walkthrough.common.source.TransactionSource;

@PublicEvolving
public class UnboundedTransactionTableSource
implements StreamTableSource<Row>,
DefinedRowtimeAttributes {
    public DataStream<Row> getDataStream(StreamExecutionEnvironment execEnv) {
        return execEnv.addSource((SourceFunction)new TransactionSource()).map(this.transactionRowMapFunction()).returns(this.getTableSchema().toRowType());
    }

    private MapFunction<Transaction, Row> transactionRowMapFunction() {
        return (MapFunction & Serializable)transaction -> Row.of((Object[])new Object[]{transaction.getAccountId(), new Timestamp(transaction.getTimestamp()), transaction.getAmount()});
    }

    public DataType getProducedDataType() {
        return this.getTableSchema().toRowDataType();
    }

    public TableSchema getTableSchema() {
        return TableSchema.builder().field("accountId", Types.LONG).field("timestamp", Types.SQL_TIMESTAMP).field("amount", Types.DOUBLE).build();
    }

    public List<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptors() {
        return Collections.singletonList(new RowtimeAttributeDescriptor("timestamp", (TimestampExtractor)new ExistingField("timestamp"), (WatermarkStrategy)new BoundedOutOfOrderTimestamps(100L)));
    }
}

