/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceInformationReflector {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceInformationReflector.class);
    static final ResourceInformationReflector INSTANCE = new ResourceInformationReflector();
    private static final String RESOURCE_INFO_CLASS = "org.apache.hadoop.yarn.api.records.ResourceInformation";
    @Nullable
    private final Method resourceSetResourceInformationMethod;
    @Nullable
    private final Method resourceGetResourcesMethod;
    @Nullable
    private final Method resourceInformationGetNameMethod;
    @Nullable
    private final Method resourceInformationGetValueMethod;
    @Nullable
    private final Method resourceInformationNewInstanceMethod;
    private final boolean isYarnResourceTypesAvailable;

    private ResourceInformationReflector() {
        this(Resource.class.getName(), RESOURCE_INFO_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ResourceInformationReflector(String resourceClassName, String resourceInfoClassName) {
        Method resourceSetResourceInformationMethod = null;
        Method resourceGetResourcesMethod = null;
        Method resourceInformationGetNameMethod = null;
        Method resourceInformationGetValueMethod = null;
        Method resourceInformationNewInstanceMethod = null;
        boolean isYarnResourceTypesAvailable = false;
        try {
            Class<?> resourceClass = Class.forName(resourceClassName);
            Class<?> resourceInfoClass = Class.forName(resourceInfoClassName);
            resourceSetResourceInformationMethod = resourceClass.getMethod("setResourceInformation", String.class, resourceInfoClass);
            resourceGetResourcesMethod = resourceClass.getMethod("getResources", new Class[0]);
            resourceInformationGetNameMethod = resourceInfoClass.getMethod("getName", new Class[0]);
            resourceInformationGetValueMethod = resourceInfoClass.getMethod("getValue", new Class[0]);
            resourceInformationNewInstanceMethod = resourceInfoClass.getMethod("newInstance", String.class, Long.TYPE);
            isYarnResourceTypesAvailable = true;
        }
        catch (Exception e) {
            LOG.debug("The underlying Yarn version does not support external resources.", (Throwable)e);
        }
        finally {
            this.resourceSetResourceInformationMethod = resourceSetResourceInformationMethod;
            this.resourceGetResourcesMethod = resourceGetResourcesMethod;
            this.resourceInformationGetNameMethod = resourceInformationGetNameMethod;
            this.resourceInformationGetValueMethod = resourceInformationGetValueMethod;
            this.resourceInformationNewInstanceMethod = resourceInformationNewInstanceMethod;
            this.isYarnResourceTypesAvailable = isYarnResourceTypesAvailable;
        }
    }

    void setResourceInformation(Resource resource, String resourceName, long amount) {
        this.setResourceInformationUnSafe(resource, resourceName, amount);
    }

    @VisibleForTesting
    void setResourceInformationUnSafe(Object resource, String resourceName, long amount) {
        if (!this.isYarnResourceTypesAvailable) {
            LOG.info("Will not request extended resource {} because the used YARN version does not support it.", (Object)resourceName);
            return;
        }
        try {
            this.resourceSetResourceInformationMethod.invoke(resource, resourceName, this.resourceInformationNewInstanceMethod.invoke(null, resourceName, amount));
        }
        catch (Exception e) {
            LOG.warn("Error in setting the external resource {}. Will not request this resource from YARN.", (Object)resourceName, (Object)e);
        }
    }

    Map<String, Long> getExternalResources(Resource resource) {
        return this.getExternalResourcesUnSafe(resource);
    }

    @VisibleForTesting
    Map<String, Long> getExternalResourcesUnSafe(Object resource) {
        if (!this.isYarnResourceTypesAvailable) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> externalResources = new HashMap<String, Long>();
        try {
            Object[] externalResourcesInfo = (Object[])this.resourceGetResourcesMethod.invoke(resource, new Object[0]);
            for (int i = 2; i < externalResourcesInfo.length; ++i) {
                String name = (String)this.resourceInformationGetNameMethod.invoke(externalResourcesInfo[i], new Object[0]);
                long value = (Long)this.resourceInformationGetValueMethod.invoke(externalResourcesInfo[i], new Object[0]);
                externalResources.put(name, value);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not obtain the external resources supported by the given Resource.", (Throwable)e);
            return Collections.emptyMap();
        }
        return externalResources;
    }

    @VisibleForTesting
    Map<String, Long> getAllResourceInfos(Object resource) {
        if (!this.isYarnResourceTypesAvailable) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> externalResources = new HashMap<String, Long>();
        try {
            Object[] externalResourcesInfo = (Object[])this.resourceGetResourcesMethod.invoke(resource, new Object[0]);
            for (int i = 0; i < externalResourcesInfo.length; ++i) {
                String name = (String)this.resourceInformationGetNameMethod.invoke(externalResourcesInfo[i], new Object[0]);
                long value = (Long)this.resourceInformationGetValueMethod.invoke(externalResourcesInfo[i], new Object[0]);
                externalResources.put(name, value);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not obtain the external resources supported by the given Resource.", (Throwable)e);
            return Collections.emptyMap();
        }
        return externalResources;
    }
}

