/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file.encryption;

import com.google.common.base.Preconditions;
import java.security.Key;
import java.util.Locale;
import org.apache.flume.FlumeException;
import org.apache.flume.channel.file.encryption.CipherProvider;
import org.apache.flume.channel.file.encryption.CipherProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(CipherProviderFactory.class);

    public static CipherProvider.Encryptor getEncrypter(String cipherProviderType, Key key) {
        if (cipherProviderType == null) {
            return null;
        }
        CipherProvider provider = CipherProviderFactory.getProvider(cipherProviderType);
        return provider.newEncryptorBuilder().setKey(key).build();
    }

    public static CipherProvider.Decryptor getDecrypter(String cipherProviderType, Key key, byte[] parameters) {
        if (cipherProviderType == null) {
            return null;
        }
        CipherProvider provider = CipherProviderFactory.getProvider(cipherProviderType);
        return provider.newDecryptorBuilder().setKey(key).setParameters(parameters).build();
    }

    private static CipherProvider getProvider(String cipherProviderType) {
        CipherProviderType type;
        Preconditions.checkNotNull((Object)cipherProviderType, (Object)"cipher provider type must not be null");
        try {
            type = CipherProviderType.valueOf(cipherProviderType.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            logger.debug("Not in enum, loading provider class: {}", (Object)cipherProviderType);
            type = CipherProviderType.OTHER;
        }
        Class<CipherProvider> providerClass = type.getProviderClass();
        if (providerClass == null) {
            try {
                Class<?> c = Class.forName(cipherProviderType);
                if (c == null || !CipherProvider.class.isAssignableFrom(c)) {
                    String errMessage = "Unable to instantiate provider from " + cipherProviderType;
                    logger.error(errMessage);
                    throw new FlumeException(errMessage);
                }
                providerClass = c;
            }
            catch (ClassNotFoundException ex) {
                logger.error("Class not found: " + cipherProviderType, (Throwable)ex);
                throw new FlumeException((Throwable)ex);
            }
        }
        try {
            return providerClass.newInstance();
        }
        catch (Exception ex) {
            String errMessage = "Cannot instantiate provider: " + cipherProviderType;
            logger.error(errMessage, (Throwable)ex);
            throw new FlumeException(errMessage, (Throwable)ex);
        }
    }
}

